""" This file define the attributes and the widgeds a.s.o. for the newCT.
    Some of the imports are not needed in this basic setup, but they show
    who these fields and widgeds to be import.
"""  
import DateTime
from Products.validation import V_REQUIRED
from Products.Archetypes.public import AnnotationStorage
from Products.Archetypes.Marshall import PrimaryFieldMarshaller 
from Products.ATContentTypes.configuration import zconf
from Products.ATContentTypes.content.schemata import finalizeATCTSchema
from Products.ATContentTypes.content.schemata import ATContentTypeSchema

from Products.Archetypes.public import BaseSchema, Schema 
from Products.Archetypes.public import StringField, FileField, DateTimeField
from Products.Archetypes.public import ImageField, TextField, LinesField 
from Products.Archetypes.public import StringWidget, FileWidget, CalendarWidget
from Products.Archetypes.public import ImageWidget, RichWidget, LinesWidget
from Products.Archetypes.public import SelectionWidget

from Products.mdotProtocol.config import *

# Definition of the newCTSchemata
#---------------------------------
mdotProtocolSchema = ATContentTypeSchema.copy() + Schema((
        DateTimeField('meeting_date',
                required=True,
                searchable=False,
                languageIndependent=True,
                widget = CalendarWidget(
                    label_msgid = "label_meeting_date",
                    i18n_domain = "mdotProtocol",
                    description= "Meeting Date",
                    description_msgid = "help_meeting_date",
                    label="Meeting Date",
                )
        ),
        StringField('keeper',
                searchable=True,
                widget = StringWidget(
                    label = "Keeper of the minutes",
                    label_msgid = "label_keeper",
                    description = "Name of the keeper of the minutes",
                    description_msgid = "help_keeper",
                    i18n_domain = "mdotProtocol"
                )
        ),
        LinesField(
            name='participiants',
            widget=LinesWidget(
                label="Participians",
                label_msgid='label_participians',
                description="Enter the name of all participians.",
                description_msgid='help_participians',
                i18n_domain='mdotProtocol',
            ),
        ),
        TextField('protocol',
            required=True,
            searchable=True,
            primary=True,
            storage = AnnotationStorage(migrate=True),
            validators = ('isTidyHtmlWithCleanup',),
            default_content_type = zconf.ATDocument.default_content_type,
            default_output_type = 'text/x-html-safe',
            allowable_content_types = zconf.ATDocument.allowed_content_types,
            widget = RichWidget(
                    label = "Protocol",
                    label_msgid = "label_protocol",
                    description = "The topics of this meeting.",
                    description_msgid = "help_protocol",
                    rows = 25,
                    i18n_domain = "mdotProtocol",
            )
        ),
        DateTimeField('next_meeting_date',
                required=True,
                searchable=False,
                languageIndependent=True,
                widget = CalendarWidget(
                    label="Next Meeting Date",
                    label_msgid = "label_next_meeting_date",
                    description= "Date of the next meeting.",
                    description_msgid = "help_next_meeting_date",
                    i18n_domain = "mdotProtocol"
                )
        ),
        StringField('next_keeper',
                searchable=True,
                widget = StringWidget(
                    label = "Next Keeper",
                    label_msgid = "label_next_keeper",
                    description = "",
                    description_msgid = "help_next_keeper",
                    i18n_domain = "mdotProtocol"
                )
        ),
    ),marshall=PrimaryFieldMarshaller(),
  )
      
finalizeATCTSchema(mdotProtocolSchema)
