from Products.Archetypes.public import listTypes
from Products.Archetypes.Extensions.utils import installTypes, install_subskin
from Products.CMFPlone.migrations.migration_util import safeEditProperty
from Products.CMFPlone.utils import getToolByName

from Products.mdotProtocol.config import *

from StringIO import StringIO

def install(self):
    out = StringIO()

    installTypes(self, out, listTypes(PRODUCT_NAME), PRODUCT_NAME)

    install_subskin(self, out, GLOBALS)
    
    # add this CT to viewable CT's in folder_contents
    siteProps = self.portal_properties.site_properties
    viewTypes = getattr(siteProps, 'typesUseViewActionInListings', None)
    if viewTypes is not None:
        viewTypes += ('ImagePlus',)
        safeEditProperty(siteProps, 'typesUseViewActionInListings', viewTypes, 'lines')
    
    # some own install-function-calls
    registerStylesheets(self, out)
    
    out.write(PRODUCT_NAME + " successfully installed \n")
    return out.getvalue()


def uninstall(self):
    out = StringIO()
    
    # remove from viewable CT's in folder_contents
    siteProps = self.portal_properties.site_properties
    viewTypes = getattr(siteProps, 'typesUseViewActionInListings', None)
    if viewTypes is not None:
        if 'ImagePlus' in viewTypes:
            viewTypes = list(viewTypes)
            del viewTypes[viewTypes.index('ImagePlus')]  # remove this CT from list
            viewTypes = tuple(viewTypes)
            safeEditProperty(siteProps, 'typesUseViewActionInListings', viewTypes, 'lines')
    
    # some own uninstall-function-calls
    unregisterStylesheets(self, out)
    
    out.write(PRODUCT_NAME + ' was uninstalled \n')
    return out.getvalue()


#============================
# some own (un-)install functions
#----------------------------

def registerStylesheets(self, out):
    """ register CSS stylesheets in portal_css """
    if STYLESHEETS is not None:
        cssTool = getToolByName(self, 'portal_css')
        for css in STYLESHEETS:
            cssTool.registerStylesheet(**css)
    
        out.write('Stylesheet(s) in portal_css registered \n')
#----------------------------

def unregisterStylesheets(self, out):
    """ unregister stylesheets in portal_css """
    if STYLESHEETS is not None:
        cssTool=getToolByName(self, 'portal_css')
        sheetnames = [ css['id'] for css in STYLESHEETS ]
        for sheetname in sheetnames:
            cssTool.unregisterResource(sheetname)
    
        out.write('Unregistered stylesheet(s) in portal_css. \n')
#----------------------------
   
