<?php
/***************************************************************************
 *                            shop_users_edit.php
 *                            -------------------
 *   Version              : 1.0.0
 *   began                : Sunday, May 16th, 2004
 *   email                : zarath@knightsofchaos.com
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   copyright (C) 2004   Zarath
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   http://www.gnu.org/copyleft/gpl.html
 *
 ***************************************************************************/

define('IN_PHPBB', true);
$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.' . $phpEx);

DEFINE('TABLE_USER_SHOPS', $table_prefix . 'user_shops');
DEFINE('TABLE_USER_SHOP_ITEMS', $table_prefix . 'user_shops_items');

//
// Start session management
//
$userdata = session_pagestart($user_ip, PAGE_INDEX);
init_userprefs($userdata);
//
// End session management
//

#
# Make sure user is logged in!
# 
if ( !$userdata['session_logged_in'] )
{
	$redirect = 'shop_users_edit.php';
	header('Location: ' . append_sid("login.$phpEx?redirect=$redirect", true));
}
#
# Register main global variable.
#
if ( isset($HTTP_GET_VARS['action']) || isset($HTTP_POST_VARS['action']) ) { $action = ( isset($HTTP_POST_VARS['action']) ) ? $HTTP_POST_VARS['action'] : $HTTP_GET_VARS['action']; }
else { $action = ''; }
#
# Check if shops are open or closed.
#
if ( !($board_config['u_shops_enabled']) )
{
	message_die(GENERAL_MESSAGE, 'The user shops are currently closed, please try back later!');
}

#
# Checks to make sure a user has a shop, if they don't... all follow actions should be invalid.
#
$sql = "SELECT *
	FROM " . TABLE_USER_SHOPS . "
	WHERE user_id = '{$userdata['user_id']}'";

if ( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, sprintf($lang['shop_error_selecting'], 'users shops'), '', __LINE__, __FILE__, $sql);
}

$sql_num_rows = $db->sql_numrows($result);

if ( $sql_num_rows == '0' && $action != 'create_shop' )
{
	$add = ( $board_config['u_shops_open_cost'] > 0 ) ? 'It will cost you ' . $board_config['u_shops_open_cost'] . ' to open a shop.' : '';

	message_die(GENERAL_MESSAGE, "You have not yet opened a shop.<br /><br />To open a shop, click <a href=\"shop_users_edit.php?action=create_shop\" class=\"nav\">here</a>.<br />" . $add);
}
#
# End main check
#

//default page
if ( empty($action) )
{
	if ( isset($HTTP_GET_VARS['edit_item']) || isset($HTTP_POST_VARS['edit_item']) ) { $edit_item = ( isset($HTTP_POST_VARS['edit_item']) ) ? intval($HTTP_POST_VARS['edit_item']) : intval($HTTP_GET_VARS['edit_item']); }
	else { $edit_item = ''; }

	$template->set_filenames(array(
		'body' => 'shop_users_config.tpl')
	);
	# Set config options...
	if ( !($row = $db->sql_fetchrow($result)) )
	{
		message_die(GENERAL_ERROR, sprintf($lang['shop_error_selecting'], 'users shops'), '', __LINE__, __FILE__, $sql);
	}

	$status_1 = ( $row['shop_status'] == 0 ) ? 'SELECTED' : '';
	$status_2 = ( $row['shop_status'] == 2 ) ? 'SELECTED' : '';
	$status_3 = ( $row['shop_status'] == 1 ) ? 'SELECTED' : '';

	if ( $row['amount_holding'] > 0 )
	{
		$template->assign_block_vars('switch_withdraw_holdings', array(
			'WITHDRAW_URL' => append_sid('shop_users_edit.' . $phpEx . '?action=withdraw_holdings')
		));
	}

	$template->assign_block_vars('switch_are_shops', array(
		'SHOP_NAME' => $row['shop_name'],
		'SHOP_TYPE' => $row['shop_type'],
		'STATUS_SELECT_1' => $status_1,
		'STATUS_SELECT_2' => $status_3,
		'STATUS_SELECT_3' => $status_2,

		'SHOP_OPENED' => create_date($board_config['default_dateformat'], $row['shop_opened'], $board_config['board_timezone']),
		'SHOP_EARNT' => $row['amount_earnt'],
		'SHOP_HOLDING' => $row['amount_holding'],
		'SHOP_ITEMS_LEFT' => $row['items_holding'],
		'SHOP_ITEMS_SOLD' => $row['items_sold']
	));

	# Begin displaying shop items
	$sql = "SELECT a.*, b.name
		FROM " . TABLE_USER_SHOP_ITEMS . " a, `phpbb_shopitems` b
		WHERE a.shop_id = '{$row['id']}'
			AND b.id = a.item_id";
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, sprintf($lang['shop_error_selecting'], 'users shop items'), '', __LINE__, __FILE__, $sql);
	}

	$sql_num_rows = $db->sql_numrows($result);

	if ( $sql_num_rows == 0 )
	{
		$template->assign_block_vars('switch_no_items', array());
	}
	else
	{
		$template->assign_block_vars('switch_are_items', array());

		for ($i = 0; $i < $sql_num_rows; $i++)
		{
			$rownum = ( $i % 2 ) ? "row1" : "row2";

			if ( !($row = $db->sql_fetchrow($result)) )
			{
				message_die(GENERAL_ERROR, sprintf($lang['shop_error_selecting'], 'users shop items'), '', __LINE__, __FILE__, $sql);
			}
			if ( $row['id'] != $edit_item )
			{
				$template->assign_block_vars('list_items', array(
					'ROW_CLASS' => $rownum,
					'ITEM_NAME' => $row['name'],
					'ITEM_NOTES' => $row['seller_notes'],
					'ITEM_COST' => $row['cost'],

					'EDIT_URL' => append_sid('shop_users_edit.' . $phpEx . '?edit_item=' . $row['id']),
					'DELETE_URL' => append_sid('shop_users_edit.' . $phpEx . '?action=change_items&sub_action=delete_item&item_id=' . $row['id'])
				));
			}
			else
			{
				$template->assign_block_vars('switch_edit_item', array(
					'ITEM_NAME' => $row['name'],
					'ITEM_NOTES' => $row['seller_notes'],
					'ITEM_COST' => $row['cost'],

					'UPDATE_URL' => append_sid('shop_users_edit.' .$phpEx . '?action=change_items&sub_action=update_item&item_id=' . $row['id'])
				));
			}
		}
	}

	# Begin displaying shop items to ADD
	# Arrange items to a variable that can be used in a IN
	$user_items = '\'' . substr(str_replace('', "', '", str_replace('', '', addslashes($userdata['user_items']))), 0, -4) . '\'';

	$sql = "SELECT *
		FROM `phpbb_shopitems`
		WHERE name IN ($user_items)";
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, sprintf($lang['shop_error_selecting'], 'users shop items'), '', __LINE__, __FILE__, $sql);
	}

	$sql_num_rows = $db->sql_numrows($result);

	if ( $sql_num_rows > 0 )
	{
		$template->assign_block_vars('switch_are_a_items', array());

		for ($i = 0; $i < $sql_num_rows; $i++)
		{
			if ( !($row = $db->sql_fetchrow($result)) )
			{
				message_die(GENERAL_ERROR, sprintf($lang['shop_error_selecting'], 'users shop items'), '', __LINE__, __FILE__, $sql);
			}
			$template->assign_block_vars('list_add_items', array(
				'ITEM_NAME' => $row['name'],
				'ITEM_ID' => $row['id']
			));
		}
	}

	if ( !empty($userdata['user_specmsg']) )
	{
		$template->assign_block_vars('switch_special_msg', array(
			'SPECIAL_MSGS' => $userdata['user_specmsg'],
			'SPECIAL_MSGS_URL' => append_sid('shop.php?clm=true'),

			'L_CLEAR' => 'Clear Messages'
		));
	} 

	$page_title = 'Edit Personal Shop';
	$shoplocation = ' -> <a href="' . append_sid('shop_users.' . $phpEx, true) . '" class="nav">User Shop List</a> -> <a href="' . append_sid('shop_users_edit.' . $phpEx) . '" class="nav">Edit Your Shop</a>';

	$template->assign_vars(array(
		'U_INVENTORY' => append_sid("shop.$phpEx?action=inventory&searchid=".$userdata['user_id']),

		'USER_POINTS' => $userdata['user_points'] . ' ' . $board_config['points_name'],

		'SHOPLOCATION' => $shoplocation,
		'L_INVENTORY' => 'Your Inventory',
		'L_ITEMS_TABLE' => 'Edit Shop Items',
		'L_SHOP_TITLE' => 'Edit Personal Shop'));

	$template->assign_block_vars('', array());
}
elseif ( $action == 'create_shop' )
{
	$sql = "SELECT *
		FROM " . TABLE_USER_SHOPS . "
		WHERE user_id = '{$userdata['user_id']}'";

	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, sprintf($lang['shop_error_selecting'], 'users shops'), '', __LINE__, __FILE__, $sql);
	}

	$sql_num_rows = $db->sql_numrows($result);

	if ( $sql_num_rows > 0 ) { message_die(GENERAL_MESSAGE, "You have already opened a shop!<br /><br />Click <a href=\"shop_users_edit.php\" class=\"nav\">here</a> to return to your shop's settings it!"); }
	else
	{
		#
		# Charge Users
		#
		if ( $board_config['u_shops_open_cost'] > 0 )
		{
			if ( $userdata['user_points'] < $board_config['u_shops_open_cost'] ) { message_die(GENERAL_MESSAGE, 'You do not have enough ' . $board_config['points_name'] . ' to open a shop. It requires at least ' . $board_config['u_shops_open_cost'] . '.'); }
			else
			{
				$sql = "UPDATE " . USERS_TABLE . "
					SET user_points = user_points - {$board_config['u_shops_open_cost']}
					WHERE user_id = '{$userdata['user_id']}'";

				if ( !($db->sql_query($sql)) )
				{
					message_die(GENERAL_ERROR, sprintf($lang['shop_error_updating'], 'users shops'), '', __LINE__, __FILE__, $sql);
				}
			}
		}

		$sql = "INSERT
			INTO " . TABLE_USER_SHOPS . "
			(user_id, username, shop_name, shop_type, shop_opened)
			VALUES('{$userdata['user_id']}', '{$userdata['username']}', '{$userdata['username']}\'s Shop', 'Unknown', '" . time() . "')";

		if ( !($db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, sprintf($lang['shop_error_inserting'], 'users shops'), '', __LINE__, __FILE__, $sql);
		}

		message_die(GENERAL_MESSAGE, "Your shop has been opened!<br /><br />Click <a href=\"shop_users_edit.php\" class=\"nav\">here</a> to begin configuring your shop!");
	}
}
elseif ( $action == 'update_config' )
{
	# Register globals for update!
	if ( isset($HTTP_GET_VARS['shop_name']) || isset($HTTP_POST_VARS['shop_name']) ) { $shop_name = ( isset($HTTP_POST_VARS['shop_name']) ) ? htmlspecialchars($HTTP_POST_VARS['shop_name']) : htmlspecialchars($HTTP_GET_VARS['shop_name']); }
	else { $shop_name = ''; }
	if ( isset($HTTP_GET_VARS['shop_type']) || isset($HTTP_POST_VARS['shop_type']) ) { $shop_type = ( isset($HTTP_POST_VARS['shop_type']) ) ? htmlspecialchars($HTTP_POST_VARS['shop_type']) : htmlspecialchars($HTTP_GET_VARS['shop_type']); }
	else { $shop_type = ''; }
	if ( isset($HTTP_GET_VARS['shop_status']) || isset($HTTP_POST_VARS['shop_status']) ) { $shop_status = ( isset($HTTP_POST_VARS['shop_status']) ) ? intval($HTTP_POST_VARS['shop_status']) : intval($HTTP_GET_VARS['shop_status']); }
	else { $shop_status = ''; }

	$shop_name = addslashes(stripslashes($shop_name));
	$shop_type = addslashes(stripslashes($shop_type));
	$shop_status = ( $shop_status > 2 || $shop_stats < 0 ) ? 1 : $shop_status;

	$sql = "UPDATE " . TABLE_USER_SHOPS . "
		SET shop_name = '$shop_name',
			shop_type = '$shop_type',
			shop_updated = '" . time() . "',
			shop_status = '$shop_status'
		WHERE user_id = '{$userdata['user_id']}'";

	if ( !($db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, sprintf($lang['shop_error_updating'], 'users'), '', __LINE__, __FILE__, $sql);
	}

	message_die(GENERAL_MESSAGE, "Your shop's settings have been successfully updated!<br /><br />Click <a href=\"shop_users_edit.php\" class=\"nav\">here</a> to return to your shop's settings.");
}
elseif ( $action == 'change_items' )
{
	if ( isset($HTTP_GET_VARS['item_id']) || isset($HTTP_POST_VARS['item_id']) ) { $item_id = ( isset($HTTP_POST_VARS['item_id']) ) ? intval($HTTP_POST_VARS['item_id']) : intval($HTTP_GET_VARS['item_id']); }
	else { $item_id = ''; }

	if ( $sub_action == 'add_item' )
	{
		if ( isset($HTTP_GET_VARS['item_cost']) || isset($HTTP_POST_VARS['item_cost']) ) { $item_cost = ( isset($HTTP_POST_VARS['item_cost']) ) ? intval($HTTP_POST_VARS['item_cost']) : intval($HTTP_GET_VARS['item_cost']); }
		else { $item_cost = ''; }
		if ( isset($HTTP_GET_VARS['item_notes']) || isset($HTTP_POST_VARS['item_notes']) ) { $item_notes = ( isset($HTTP_POST_VARS['item_notes']) ) ? htmlspecialchars($HTTP_POST_VARS['item_notes']) : htmlspecialchars($HTTP_GET_VARS['item_notes']); }
		else { $item_notes = ''; }
		$item_notes = ( empty($item_notes) ) ? 'None.' : addslashes(stripslashes($item_notes));
		if ( $item_cost < 1 ) { $item_cost = 1; }

		$user_items = '\'' . substr(str_replace('', "', '", str_replace('', '', addslashes($userdata['user_items']))), 0, -4) . '\'';

		$sql = "SELECT a.name, a.id, b.id as shop_id
			FROM `phpbb_shopitems` a, " . TABLE_USER_SHOPS . " b
			WHERE a.id = '$item_id'
				AND b.user_id = '{$userdata['user_id']}'
				AND a.name IN ($user_items)";
		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, sprintf($lang['shop_error_selecting'], 'users shop items'), '', __LINE__, __FILE__, $sql);
		}

		$sql_num_rows = $db->sql_numrows($result);

		if ( $sql_num_rows > 0 )
		{
			if ( !($row = $db->sql_fetchrow($result)) )
			{
				message_die(GENERAL_ERROR, sprintf($lang['shop_error_selecting'], 'users shop items'), '', __LINE__, __FILE__, $sql);
			}

			# 
			# If max limit is set, check amount
			#
			if ( $board_config['u_shops_max_items'] > 0 )
			{
				$sql = "SELECT *
					FROM " . TABLE_USER_SHOP_ITEMS . "
					WHERE shop_id = '{$row['shop_id']}'";

				if ( !($result = $db->sql_query($sql)) )
				{
					message_die(GENERAL_ERROR, sprintf($lang['shop_error_selecting'], 'users shop items'), '', __LINE__, __FILE__, $sql);
				}
				if ( $db->sql_numrows($result) > $board_config['u_shops_max_items'] ) { message_die(GENERAL_MESSAGE, "Your shop currently has too many items in it, you must remove some before you can add more!<br /><br />Click <a href=\"shop_users_edit.php\" class=\"nav\">here</a> to return to your shop's settings."); }
			}

			$useritems = substr_replace($userdata['user_items'], "", strpos($userdata['user_items'], "".$row['name'].""), strlen("".$row['name'].""));
			$useritems = addslashes($useritems);

			$sql = "UPDATE " . USERS_TABLE . "
				SET user_items = '$useritems'
				WHERE user_id = '{$userdata['user_id']}'";
			if ( !($db->sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, sprintf($lang['shop_error_updating'], 'users'), '', __LINE__, __FILE__, $sql);
			}

			$sql = "INSERT
				INTO " . TABLE_USER_SHOP_ITEMS . "
				(shop_id, item_id, seller_notes, cost, time_added)
				VALUES('{$row['shop_id']}', '{$row['id']}', '$item_notes', '$item_cost', '" . time() . "')";
			if ( !($db->sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, sprintf($lang['shop_error_inserting'], 'users'), '', __LINE__, __FILE__, $sql);
			}

			$sql = "UPDATE " . TABLE_USER_SHOPS . "
				SET items_holding = items_holding + 1,
					shop_updated = '" . time() . "'
				WHERE user_id = '{$userdata['user_id']}'";
			if ( !($db->sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, sprintf($lang['shop_error_deleting'], 'users shop items'), '', __LINE__, __FILE__, $sql);
			}

			message_die(GENERAL_MESSAGE, "Item has been successfully removed from your inventory and added to your shop!<br /><br />Click <a href=\"shop_users_edit.php\" class=\"nav\">here</a> to return to your shop's settings.");
		}
		else { message_die(GENERAL_MESSAGE, "You don't own that item, so you can't add it to your shop!<br /><br />Click <a href=\"shop_users_edit.php\" class=\"nav\">here</a> to return to your shop's settings."); }

	}
	elseif ( $sub_action == 'delete_item' )
	{
		$sql = "SELECT a.*, b.name
			FROM " . TABLE_USER_SHOP_ITEMS . " a, `phpbb_shopitems` b
			WHERE a.id = '$item_id'
				AND b.id = a.item_id";
		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, sprintf($lang['shop_error_inserting'], 'shop items'), '', __LINE__, __FILE__, $sql);
		}

		$sql_num_rows = $db->sql_numrows($result);

		if ( $sql_num_rows > 0 )
		{
			if ( !($row = $db->sql_fetchrow($result)) )
			{
				message_die(GENERAL_ERROR, sprintf($lang['shop_error_selecting'], 'users shop items'), '', __LINE__, __FILE__, $sql);
			}

			$sql = "DELETE
				FROM " . TABLE_USER_SHOP_ITEMS . "
				WHERE id = '$item_id'";
			if ( !($db->sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, sprintf($lang['shop_error_deleting'], 'users shop items'), '', __LINE__, __FILE__, $sql);
			}

			$useritems = addslashes($userdata['user_items'] . '' . $row['name'] . '');

			$sql = "UPDATE " . USERS_TABLE . "
				SET user_items = '$useritems'
				WHERE user_id = '{$userdata['user_id']}'";
			if ( !($db->sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, sprintf($lang['shop_error_deleting'], 'users shop items'), '', __LINE__, __FILE__, $sql);
			}

			$sql = "UPDATE " . TABLE_USER_SHOPS . "
				SET items_holding = items_holding - 1
				WHERE user_id = '{$userdata['user_id']}'";
			if ( !($db->sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, sprintf($lang['shop_error_deleting'], 'users shop items'), '', __LINE__, __FILE__, $sql);
			}

			message_die(GENERAL_MESSAGE, "The item has been removed from your shop and placed back in your inventory.<br /><br />Click <a href=\"shop_users_edit.php\" class=\"nav\">here</a> to return to your shop's settings."); 
		}
		else { message_die(GENERAL_MESSAGE, "You can't remove an item that isn't in your store!<br /><br />Click <a href=\"shop_users_edit.php\" class=\"nav\">here</a> to return to your shop's settings."); }
	}
	elseif ( $sub_action == 'update_item' )
	{
		if ( isset($HTTP_GET_VARS['item_cost']) || isset($HTTP_POST_VARS['item_cost']) ) { $item_cost = ( isset($HTTP_POST_VARS['item_cost']) ) ? intval($HTTP_POST_VARS['item_cost']) : intval($HTTP_GET_VARS['item_cost']); }
		else { $item_cost = ''; }
		if ( isset($HTTP_GET_VARS['item_notes']) || isset($HTTP_POST_VARS['item_notes']) ) { $item_notes = ( isset($HTTP_POST_VARS['item_notes']) ) ? htmlspecialchars($HTTP_POST_VARS['item_notes']) : htmlspecialchars($HTTP_GET_VARS['item_notes']); }
		else { $item_notes = ''; }
		$item_notes = ( empty($item_notes) ) ? 'None.' : addslashes(stripslashes($item_notes));
		if ( $item_cost < 1 ) { $item_cost = 1; }

		$sql = "SELECT a.*, b.name
			FROM " . TABLE_USER_SHOP_ITEMS . " a, `phpbb_shopitems` b
			WHERE a.id = '$item_id'
				AND b.id = a.item_id";
		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, sprintf($lang['shop_error_inserting'], 'shop items'), '', __LINE__, __FILE__, $sql);
		}

		$sql_num_rows = $db->sql_numrows($result);

		if ( $sql_num_rows > 0 )
		{
			$sql = "UPDATE " . TABLE_USER_SHOP_ITEMS . "
				set cost = '$item_cost',
					seller_notes = '$item_notes'
				WHERE id = '$item_id'";
			if ( !($db->sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, sprintf($lang['shop_error_inserting'], 'user shop items'), '', __LINE__, __FILE__, $sql);
			}

			message_die(GENERAL_MESSAGE, "This item has successfully been updated!<br /><br />Click <a href=\"shop_users_edit.php\" class=\"nav\">here</a> to return to your shop's settings");
		}
		else { message_die(GENERAL_MESSAGE, "You can't update an item that isn't in your store!<br /><br />Click <a href=\"shop_users_edit.php\" class=\"nav\">here</a> to return to your shop's settings."); }
	}
}
elseif ( $action == 'withdraw_holdings' )
{
	$sql = "SELECT amount_holding
		FROM " . TABLE_USER_SHOPS . "
		WHERE user_id = '{$userdata['user_id']}'";
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, sprintf($lang['shop_error_selecting'], 'user shops'), '', __LINE__, __FILE__, $sql);
	}

	if ( !($row = $db->sql_fetchrow($result)) )
	{
		message_die(GENERAL_ERROR, sprintf($lang['shop_error_selecting'], 'users shops'), '', __LINE__, __FILE__, $sql);
	}


	if ( $row['amount_holding'] < 1 ) { message_die(GENERAL_MESSAGE, "There is nothing for you to withdraw!"); }

	$sql = "UPDATE " . USERS_TABLE . "
		SET user_points = user_points + {$row['amount_holding']}
		WHERE user_id = '{$userdata['user_id']}'";
	if ( !($db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, sprintf($lang['shop_error_updating'], 'users'), '', __LINE__, __FILE__, $sql);
	}

	$sql = "UPDATE " . TABLE_USER_SHOPS . "
		SET amount_holding = '0',
			shop_updated = '" . time() . "'
		WHERE user_id = '{$userdata['user_id']}'";
	if ( !($db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, sprintf($lang['shop_error_updating'], 'user shops'), '', __LINE__, __FILE__, $sql);
	}

	message_die(GENERAL_MESSAGE, "You have successfully withdrawn the " . $row['amount_holding'] . " that your store earned.<br /><br />Click <a href=\"shop_users_edit.php\" class=\"nav\">here</a> to return to your shop's settings");
}
else { message_die(GENERAL_MESSAGE, "Invalid Action!"); }

//
// Start output of page
//
include($phpbb_root_path . 'includes/page_header.' . $phpEx);

//
// Generate the page
//
$template->pparse('body');

include($phpbb_root_path . 'includes/page_tail.' . $phpEx);

?>