<?php
/***************************************************************************
 *                              shop_users.php
 *                            -------------------
 *   Version              : 1.0.0
 *   began                : Sunday, May 16th, 2004
 *   email                : zarath@knightsofchaos.com
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   copyright (C) 2004   Zarath Technologies
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   http://www.gnu.org/copyleft/gpl.html
 *
 ***************************************************************************/

define('IN_PHPBB', true);
$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.' . $phpEx);

DEFINE('TABLE_USER_SHOPS', $table_prefix . 'user_shops');
DEFINE('TABLE_USER_SHOP_ITEMS', $table_prefix . 'user_shops_items');

//
// Start session management
//
$userdata = session_pagestart($user_ip, PAGE_INDEX);
init_userprefs($userdata);
//
// End session management
//
#
# Check if shops are open or closed.
#
if ( !($board_config['u_shops_enabled']) )
{
	message_die(GENERAL_MESSAGE, 'The user shops are currently closed, please try back later!');
}


//default page
if ( empty($_REQUEST['action']) )
{
	$template->set_filenames(array(
		'body' => 'shop_users_body.tpl')
	);

	if ( strlen($_REQUEST['search_string']) > 1 )
	{
		$search_string = addslashes(stripslashes($_REQUEST['search_string']));

		$sql = "SELECT DISTINCT a.*, b.shop_id
			FROM " . TABLE_USER_SHOPS . " a, " . TABLE_USER_SHOP_ITEMS . " b, `phpbb_shopitems` c
			WHERE ( ( (a.shop_status = 0 OR a.shop_status = 2) AND a.id = b.shop_id )
				AND ( b.item_id = c.id )
				AND ( c.name LIKE '%" . $search_string . "%' ) )
			GROUP BY b.shop_id
			ORDER BY `shop_updated` DESC";
	}
	else
	{
		$sql = "SELECT DISTINCT a.*, b.shop_id
			FROM " . TABLE_USER_SHOPS . " a, " . TABLE_USER_SHOP_ITEMS . " b
			WHERE ( (a.shop_status = 0 OR a.shop_status = 2) AND a.id = b.shop_id )
			GROUP BY b.shop_id
			ORDER BY `shop_updated` DESC";
	}

	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, sprintf($lang['shop_error_selecting'], 'users shops'), '', __LINE__, __FILE__, $sql);
	}

	$sql_num_rows = $db->sql_numrows($result);

	for ($i = 0; $i < $sql_num_rows; $i++)
	{

		if ( !($row = $db->sql_fetchrow($result)) )
		{
			message_die(GENERAL_ERROR, sprintf($lang['shop_error_selecting'], 'users shops'), '', __LINE__, __FILE__, $sql);
		}

		$rownum = ( $i % 2 ) ? "row1" : "row2";

		$template->assign_block_vars('shop_row', array(
			'ROW_CLASS' => $rownum,
			'SHOP_URL' => append_sid("shop_users_view.php?shop=" . $row['id']),
			'SHOP_NAME' => $row['shop_name'],
			'SHOP_TYPE' => $row['shop_type'],
			'SHOP_OWNER' => $row['username'])
		);
		$user_has_shop = ( $row['user_id'] == $userdata['user_id'] || $user_has_shop ) ? 1 : 0;
	}

	if ( $sql_num_rows == '0' )
	{
		$template->assign_block_vars('switch_no_shops', array());
	}
	else
	{
		$template->assign_block_vars('switch_is_shops', array());
	}

	#
	# Code to handle replacement of msg edit/create
	$user_shop_msg = ( $user_has_shop ) ? 'edit your shop' : 'open your own shop';

	$template->assign_block_vars('switch_user_shop', array(
		'USER_MSG' => $user_shop_msg,
		'URL' => append_sid('shop_users_edit.php')
	));


	if ( !empty($userdata['user_specmsg']) )
	{
		$template->assign_block_vars('switch_special_msg', array(
			'SPECIAL_MSGS' => $userdata['user_specmsg'],
			'SPECIAL_MSGS_URL' => append_sid('shop.php?clm=true'),

			'L_CLEAR' => 'Clear Messages'
		));
	} 

	$page_title = ucfirst($row['name']) . ' Information';
	$shoplocation = ' -> <a href="'.append_sid('shop_users.'.$phpEx, true).'" class="nav">User Shop List</a>';

	$template->assign_vars(array(
		'U_INVENTORY' => append_sid("shop.$phpEx?action=inventory&searchid=".$userdata['user_id']),

		'USER_POINTS' => $userdata['user_points'] . ' ' . $board_config['points_name'],

		'SHOPLOCATION' => $shoplocation,
		'L_INVENTORY' => 'Your Inventory',
		'L_SHOP_TITLE' => 'Shop List'));

	$template->assign_block_vars('', array());
}
elseif ( $_REQUEST['action'] == 'del_shop' )
{
}

//
// Start output of page
//
include($phpbb_root_path . 'includes/page_header.' . $phpEx);

//
// Generate the page
//
$template->pparse('body');

include($phpbb_root_path . 'includes/page_tail.' . $phpEx);

?>