<?php
/***************************************************************************
 *                              mod_install.php
 *                            -------------------
 *   Version              : 1.0.0
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   copyright (C) 2002/2003  IcE-RaiN/Zarath
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   http://www.gnu.org/copyleft/gpl.html
 *
 ***************************************************************************/
 
define('IN_PHPBB', true);
$phpbb_root_path='./';
include($phpbb_root_path.'extension.inc');
include($phpbb_root_path.'common.'.$phpEx);

//
// Start session management
//
$userdata = session_pagestart($user_ip, PAGE_INDEX);
init_userprefs($userdata);
//
// End session management
//

if( !$userdata['session_logged_in'] )
{
	header('Location: ' . append_sid("login.$phpEx?redirect=shop_install.$phpEx", true));
}

if( $userdata['user_level'] != ADMIN )
{
	message_die(GENERAL_MESSAGE, $lang['Not_Authorised']);
}

if( !strstr($dbms, "mysql") )
{
    if( !isset($bypass) )
    {
        $message = 'This mod has only been tested on MySQL and may only work on MySQL.<br />';
        $message .= 'Click <a href="mod_install.php?bypass=true">here</a> to install anyways.';
        message_die(GENERAL_MESSAGE, $message);
    }
}

$sql = array();

$sql[] = "CREATE TABLE `" . $table_prefix . "user_shops` (
`id` INT( 5 ) NOT NULL AUTO_INCREMENT ,
`user_id` INT( 10 ) NOT NULL ,
`username` VARCHAR( 32 ) NOT NULL ,
`shop_name` VARCHAR( 32 ) NOT NULL ,
`shop_type` VARCHAR( 32 ) NOT NULL ,
`shop_opened` INT( 30 ) NOT NULL ,
`shop_status` INT( 1 ) DEFAULT '0' NOT NULL ,
`amount_earnt` INT( 10 ) DEFAULT '0' NOT NULL ,
`amount_holding` INT( 10 ) DEFAULT '0' NOT NULL ,
`items_sold` INT( 10 ) DEFAULT '0' NOT NULL ,
`items_holding` INT( 10 ) DEFAULT '0' NOT NULL ,
`shop_updated` INT(30) DEFAULT '0' NOT NULL ,
PRIMARY KEY ( `user_id` ) ,
INDEX ( `id` ) 
);";

$sql[] = "CREATE TABLE `" . $table_prefix . "user_shops_items` (
`id` INT( 10 ) NOT NULL AUTO_INCREMENT ,
`shop_id` INT( 10 ) NOT NULL ,
`item_id` INT( 10 ) NOT NULL ,
`seller_notes` VARCHAR( 255 ) NOT NULL ,
`cost` INT( 10 ) NOT NULL ,
`time_added` MEDIUMINT( 30 ) NOT NULL ,
INDEX ( `shop_id` ) ,
PRIMARY KEY ( `id` ) 
);";


$sql[] = "INSERT INTO " . CONFIG_TABLE . " (config_name, config_value) VALUES ('u_shops_enabled', '0');";

$sql[] = "INSERT INTO " . CONFIG_TABLE . " (config_name, config_value) VALUES ('u_shops_open_cost', '0');";

$sql[] = "INSERT INTO " . CONFIG_TABLE . " (config_name, config_value) VALUES ('u_shops_tax_percent', '0');";

$sql[] = "INSERT INTO " . CONFIG_TABLE . " (config_name, config_value) VALUES ('u_shops_max_items', '100');";

$sql_count = count($sql);

echo "<html>\n";
echo "<body>\n";

for($i = 0; $i < $sql_count; $i++)
{
	echo "Running :: " . $sql[$i];
	flush();

	if ( !$db->sql_query($sql[$i]) )
	{
		$errored = true;
		$error = $db->sql_error();
		echo " -> <b>FAILED</b> ---> <u>" . $error['message'] . "</u><br /><br />\n\n";
	}
	else
	{
		echo " -> <b>COMPLETED</b><br /><br />\n\n";
	}
}

if( $errored )
{
    $message = "Some of the querys have failed, contact me so I can fix the errors.";
}
else
{
    $message = "The table have been edited successfully. You can now delete this file.";
}

echo "\n<br />\n<b>Finished!</b><br />\n";
echo $message . "<br />\n";
echo "</body>\n";
echo "</html>\n";
exit();

?>