<?php
/***************************************************************************
 *                            admin_user_shops.php
 *                            --------------------
 *   copyright            : (C) Zarath Technologies, 2004
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

define('IN_PHPBB', 1);

if( !empty($setmodules) )
{
	$file = basename(__FILE__);
	$module['Users']['User_Shops'] = $file;
	return;
}

//
// Load default header
//
$phpbb_root_path = "./../";
require($phpbb_root_path . 'extension.inc');
require('./pagestart.' . $phpEx);
include($phpbb_root_path . 'includes/functions_admin.'.$phpEx);

DEFINE('TABLE_USER_SHOPS', $table_prefix . 'user_shops');
DEFINE('TABLE_USER_SHOP_ITEMS', $table_prefix . 'user_shops_items');

#
# Register action var
#
if ( isset($HTTP_GET_VARS['action']) || isset($HTTP_POST_VARS['action']) ) { $action = ( isset($HTTP_POST_VARS['action']) ) ? htmlspecialchars($HTTP_POST_VARS['action']) : htmlspecialchars($HTTP_GET_VARS['action']); }
else { $action = ''; }
#
# Done
#

if ( empty($action) )
{
	$template->set_filenames(array(
		'body' => 'admin/user_shops_body.tpl')
	);

	# Get a list of user shops!
	$sql = "SELECT a.*, b.username
		FROM " . TABLE_USER_SHOPS . " a, " . USERS_TABLE . " as b
		WHERE b.user_id = a.user_id
		ORDER BY b.username";
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, sprintf($lang['shop_error_selecting'], 'users shops'), '', __LINE__, __FILE__, $sql);
	}

	$sql_num_rows = $db->sql_numrows($result);

	for ( $i = 0; $i < $sql_num_rows; $i++ )
	{
		if ( !($row = $db->sql_fetchrow($result)) )
		{
			message_die(GENERAL_ERROR, sprintf($lang['shop_error_selecting'], 'users shops'), '', __LINE__, __FILE__, $sql);
		}

		$sql = "SELECT *
			FROM " . TABLE_USER_SHOP_ITEMS . " 
			WHERE shop_id = '{$row['id']}'";

		if ( !($result2 = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, sprintf($lang['shop_error_selecting'], 'users shops'), '', __LINE__, __FILE__, $sql);
		}
		$count = $db->sql_numrows($result2);

		$template->assign_block_vars('list_users', array(
			'SHOP_ID' => $row['id'],
			'STRING' => $row['username']
		));


		$string = $row['shop_name'] .' [' . $count . ' items]';

		$template->assign_block_vars('list_shops', array(
			'SHOP_ID' => $row['id'],
			'STRING' => $string
		));
	}

	if ( $sql_num_rows )
	{
		$template->assign_block_vars('switch_are_shops', array());

		$sql = "SELECT *
			FROM " . TABLE_USER_SHOP_ITEMS;

		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, sprintf($lang['shop_error_selecting'], 'users shops'), '', __LINE__, __FILE__, $sql);
		}
		$total_items = $db->sql_numrows($result);

		$sql = "SELECT SUM(amount_holding) as total_amount, SUM(amount_earnt) as total_earnt
			FROM " . TABLE_USER_SHOPS;

		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, sprintf($lang['shop_error_selecting'], 'users shops'), '', __LINE__, __FILE__, $sql);
		}
		if ( !($row = $db->sql_fetchrow($result)) )
		{
			message_die(GENERAL_ERROR, sprintf($lang['shop_error_selecting'], 'users shops'), '', __LINE__, __FILE__, $sql);
		}
	}

	$shop_open = ( $board_config['u_shops_enabled'] ) ? 'SELECTED' : '';
	$shop_closed = ( $board_config['u_shops_enabled'] ) ? '' : 'SELECTED';


	$template->assign_vars(array(
		'TOTAL_SHOPS' => $sql_num_rows,
		'TOTAL_ITEMS' => $total_items,
		'TOTAL_HOLDING' => $row['total_amount'],
		'TOTAL_EARNT' => $row['total_earnt'],

		'OPEN_COST' => $board_config['u_shops_open_cost'],
		'TAX_PERCENT' => $board_config['u_shops_tax_percent'],
		'MAX_ITEMS' => $board_config['u_shops_max_items'],
		'SHOP_OPEN' => $shop_open,
		'SHOP_CLOSED' => $shop_closed,

		'S_CONFIG_ACTION' => append_sid('admin_user_shops.' . $phpEx),
		'TITLE' => 'User Shops Editor',
		'EXPLAIN' => 'In this area you can edit the user shop configuration and close user shops.')
	);
}

elseif ( $action == 'update_vars' )
{
	#
	# Register Vars
	#
	if ( isset($HTTP_GET_VARS['status']) || isset($HTTP_POST_VARS['status']) ) { $status = ( isset($HTTP_POST_VARS['status']) ) ? intval($HTTP_POST_VARS['status']) : intval($HTTP_GET_VARS['status']); }
	else { $status = 0; }
	if ( isset($HTTP_GET_VARS['tax_percent']) || isset($HTTP_POST_VARS['tax_percent']) ) { $tax_percent = ( isset($HTTP_POST_VARS['tax_percent']) ) ? intval($HTTP_POST_VARS['tax_percent']) : intval($HTTP_GET_VARS['tax_percent']); }
	else { $tax_percent = 0; }
	if ( isset($HTTP_GET_VARS['max_items']) || isset($HTTP_POST_VARS['max_items']) ) { $max_items = ( isset($HTTP_POST_VARS['max_items']) ) ? intval($HTTP_POST_VARS['max_items']) : intval($HTTP_GET_VARS['max_items']); }
	else { $max_items = 100; }
	if ( isset($HTTP_GET_VARS['open_cost']) || isset($HTTP_POST_VARS['open_cost']) ) { $open_cost = ( isset($HTTP_POST_VARS['open_cost']) ) ? intval($HTTP_POST_VARS['open_cost']) : intval($HTTP_GET_VARS['open_cost']); }
	else { $open_cost = 0; }
	#
	# Vars Registered
	#
	# Begin checks on vars
	#
	$open_cost = ( $open_cost < 0 ) ? 0 : $open_cost;
	$status = ( $status != 0 && $status != 1 ) ? 0 : $status;
	$max_items = ( $max_items < 0 ) ? 100 : $max_items;
	$tax_percent = ( $tax_percent < 0 || $tax_percent > 100 ) ? 0 : $tax_percent;

	#
	# Checks Done
	#
	# Begin SQL Query Setup
	#
	$sql = array();

	if ( $status != $board_config['u_shops_enabled'] )
	{
		$sql[] = "UPDATE " . CONFIG_TABLE . "
			SET config_value = '$status'
			WHERE config_name = 'u_shops_enabled'";
	}
	if ( $tax_percent != $board_config['u_shops_tax_percent'] )
	{
		$sql[] = "UPDATE " . CONFIG_TABLE . "
			SET config_value = '$tax_percent'
			WHERE config_name = 'u_shops_tax_percent'";
	}

	if ( $max_items != $board_config['u_shops_max_items'] )
	{
		$sql[] = "UPDATE " . CONFIG_TABLE . "
			SET config_value = '$max_items'
			WHERE config_name = 'u_shops_max_items'";
	}

	if ( $open_cost != $board_config['u_shops_open_cost'] )
	{
		$sql[] = "UPDATE " . CONFIG_TABLE . "
			SET config_value = '$open_cost'
			WHERE config_name = 'u_shops_open_cost'";
	}

	$count = count($sql);

	for ( $i = 0; $i < $count; $i++ )
	{
		if ( !($db->sql_query($sql[$i])) )
		{
			message_die(GENERAL_ERROR, sprintf($lang['shop_error_updating'], 'users shops'), '', __LINE__, __FILE__, $sql);
		}

	}

	message_die(GENERAL_MESSAGE, 'The user shops have successfully been updated!<br /><br />Please click <a href="' . append_sid('admin_user_shops.php') . '" class="nav">here</a> to return to the main user shop configuration.');
}

elseif ( $action == 'close_shop' )
{
	#
	# Register Vars
	#
	if ( isset($HTTP_GET_VARS['id']) || isset($HTTP_POST_VARS['id']) ) { $id = ( isset($HTTP_POST_VARS['id']) ) ? intval($HTTP_POST_VARS['id']) : intval($HTTP_GET_VARS['id']); }
	else { $id = -1; }
	if ( isset($HTTP_GET_VARS['items']) || isset($HTTP_POST_VARS['items']) ) { $items = ( isset($HTTP_POST_VARS['items']) ) ? intval($HTTP_POST_VARS['items']) : intval($HTTP_GET_VARS['items']); }
	else { $items = 1; }
	#
	# Vars Registered
	# 

	$sql = "SELECT *
		FROM " . TABLE_USER_SHOPS . "
		WHERE id = '$id'";
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, sprintf($lang['shop_error_selecting'], 'users shops'), '', __LINE__, __FILE__, $sql);
	}

	$sql_num_rows = $db->sql_numrows($result);

	if ( !($sql_num_rows) ) { message_die(GENERAL_MESSAGE, 'This shop does not exist!<br /><br />Please click <a href="' . append_sid('admin_user_shops.php') . '" class="nav">here</a> to return to the main user shop configuration.'); }
	else
	{
		# If set, return user items
		if ( $items )
		{
			$sql = "SELECT *
				FROM " . TABLE_USER_SHOP_ITEMS . "
				WHERE shop_id = '$id'";
			if ( !($result = $db->sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, sprintf($lang['shop_error_selecting'], 'users shops'), '', __LINE__, __FILE__, $sql);
			}

			$sql_num_rows = $db->sql_numrows($result);

			for ( $i = 0; $i < $sql_num_rows; $i++ )
			{
				if ( !($row = $db->sql_fetchrow($result)) )
				{
					message_die(GENERAL_ERROR, sprintf($lang['shop_error_selecting'], 'users shops'), '', __LINE__, __FILE__, $sql);
				}

				$append_items .= '' . $row['name'] . '';
			}

			$sql = "SELECT *
				FROM " . USERS_TABLE . "
				WHERE user_id = '{$row['user_id']}'"; 
			if ( !($result = $db->sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, sprintf($lang['shop_error_selecting'], 'users shops'), '', __LINE__, __FILE__, $sql);
			}

			$sql_num_rows = $db->sql_numrows($result);

			if ( $sql_num_rows )
			{
				if ( !($row = $db->sql_fetchrow($result)) )
				{
					message_die(GENERAL_ERROR, sprintf($lang['shop_error_selecting'], 'users shops'), '', __LINE__, __FILE__, $sql);
				}

				$new_items = addslashes($row['user_items'] . $append_items);

				$sql = "UPDATE " . USERS_TABLE . "
					SET user_items = '$new_items'
					WHERE user_id = '{$row['user_id']}'";
				if ( !($db->sql_query($sql)) )
				{
					message_die(GENERAL_ERROR, sprintf($lang['shop_error_selecting'], 'users shops'), '', __LINE__, __FILE__, $sql);
				}
			}
			$msg .= '<br />All items have successfully been returned to ' . $row['username'] . '.';
		}

		# DELETE SHOP
		$sql = "DELETE
			FROM " . TABLE_USER_SHOPS . "
			WHERE id = '$id'";
		if ( !($db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, sprintf($lang['shop_error_deleting'], 'users shops'), '', __LINE__, __FILE__, $sql);
		}

		# Delete Shop Items
		$sql = "DELETE
			FROM " . TABLE_USER_SHOP_ITEMS . "
			WHERE shop_id = '$id'";
		if ( !($db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, sprintf($lang['shop_error_deleting'], 'users shops'), '', __LINE__, __FILE__, $sql);
		}

		message_die(GENERAL_MESSAGE, 'This shop and all items in it successfully deleted.' . $msg . '<br /><br />Please click <a href="' . append_sid('admin_user_shops.php') . '" class="nav">here</a> to return to the main user shop configuration.');
	}
}

else { header("Location: admin_user_shops.php"); }

$template->pparse("body");

include('./page_footer_admin.'.$phpEx);

?>
