<?php
/***************************************************************************
 *                            shop_users_view.php
 *                            -------------------
 *   Version              : 1.0.0
 *   began                : Sunday, May 16th, 2004
 *   email                : zarath@knightsofchaos.com
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   copyright (C) 2004   Zarath
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   http://www.gnu.org/copyleft/gpl.html
 *
 ***************************************************************************/


define('IN_PHPBB', true);
$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.' . $phpEx);

DEFINE('TABLE_USER_SHOPS', $table_prefix . 'user_shops');
DEFINE('TABLE_USER_SHOP_ITEMS', $table_prefix . 'user_shops_items');


#
# Start session management
#
$userdata = session_pagestart($user_ip, PAGE_INDEX);
init_userprefs($userdata);
#
# End session management
#
#
# Register main action variable!
#
if ( isset($HTTP_GET_VARS['action']) || isset($HTTP_POST_VARS['action']) ) { $action = ( isset($HTTP_POST_VARS['action']) ) ? $HTTP_POST_VARS['action'] : $HTTP_GET_VARS['action']; }
else { $action = ''; }
#
# Check if shops are open or closed.
#
if ( !($board_config['u_shops_enabled']) )
{
	message_die(GENERAL_MESSAGE, 'The user shops are currently closed, please try back later!');
}


//start of shop list page
if ( empty($action) )
{
	if ( isset($HTTP_GET_VARS['shop']) || isset($HTTP_POST_VARS['shop']) ) { $shop = ( isset($HTTP_POST_VARS['shop']) ) ? intval($HTTP_POST_VARS['shop']) : intval($HTTP_GET_VARS['shop']); }
	else { $shop = ''; }

	$template->set_filenames(array(
		'body' => 'shop_users_view.tpl')
	);

	$sql = "SELECT *
		FROM " . TABLE_USER_SHOPS . "
		WHERE id = '$shop'
			AND shop_status != '1'";
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, sprintf($lang['shop_error_selecting'], 'users shops'), '', __LINE__, __FILE__, $sql);
	}

	if ( !($db->sql_numrows($result)) )
	{
		message_die(GENERAL_MESSAGE, "No such shop exists!!");
	}



	$sql = "SELECT b.id as items_id, c.name, c.sdesc, b.cost, b.seller_notes, a.shop_name, a.id as shop_id
		FROM " . TABLE_USER_SHOPS . " a, " . TABLE_USER_SHOP_ITEMS . " b, `phpbb_shopitems` c
		WHERE a.id = '$shop'
			AND a.shop_status != '1'
			AND b.shop_id = a.id
			AND c.id = b.item_id";
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, sprintf($lang['shop_error_selecting'], 'users shops'), '', __LINE__, __FILE__, $sql);
	}

	$sql_num_rows = $db->sql_numrows($result);

	if ( $sql_num_rows == '0' )
	{
		message_die(GENERAL_MESSAGE, 'There are currently no items to purchase from this shop!<br /><br />Click <a href="' . append_sid("shop_users.php") . '" class="nav">here</a> to return to user shop listing.');
	}

	$template->assign_block_vars('switch_main_list', array());

	for ($i = 0; $i < $sql_num_rows; $i++)
	{
		if ( !($row = $db->sql_fetchrow($result)) )
		{
			message_die(GENERAL_ERROR, sprintf($lang['shop_error_selecting'], 'users shops'), '', __LINE__, __FILE__, $sql);
		}

		$rownum = ( $i % 2 ) ? "row1" : "row2";

		$template->assign_block_vars('list_items', array(
			'ROW_CLASS' => $rownum,
			'ITEM_URL' => append_sid('shop_users_view.' . $phpEx . '?action=display_item&item=' . $row['items_id']),
			'ITEM_NAME' => $row['name'],
			'ITEM_S_DESC' => $row['sdesc'],
			'ITEM_COST' => $row['cost'],
			'ITEM_NOTES' => $row['seller_notes']
		));
	}

	$page_title = $row['shop_name'];
	$shoplocation = ' -> <a href="'.append_sid('shop_users.'.$phpEx, true).'" class="nav">User Shop List</a> -> <a href="' . append_sid('shop_users_view.' . $phpEx . '?shop=' . $row['shop_id'], true) . '" class="nav">' . $row['shop_name'] . '</a>';

	if ( !empty($userdata['user_specmsg']) )
	{
		$template->assign_block_vars('switch_special_msg', array(
			'SPECIAL_MSGS' => $userdata['user_specmsg'],
			'SPECIAL_MSGS_URL' => append_sid('shop.php?clm=true'),

			'L_CLEAR' => 'Clear Messages'
		));
	}

	$template->assign_vars(array(
		'U_INVENTORY' => append_sid("shop.$phpEx?action=inventory&searchid=".$userdata['user_id']),
		'USER_POINTS' => $userdata['user_points'] . ' ' . $board_config['points_name'],
		'L_INVENTORY' => 'Your Inventory',

		'SHOPLOCATION' => $shoplocation,
		'L_SHOP_TITLE' => $row['shop_name'] . ' Inventory'
	));
	$template->assign_block_vars('', array());
}

//start of item info page
elseif ( $action == "display_item" ) 
{
	if ( isset($HTTP_GET_VARS['item']) || isset($HTTP_POST_VARS['item']) ) { $item = ( isset($HTTP_POST_VARS['item']) ) ? intval($HTTP_POST_VARS['item']) : intval($HTTP_GET_VARS['item']); }
	else { $item = ''; }

	$template->set_filenames(array(
		'body' => 'shop_users_view.tpl')
	);

	$sql = "SELECT a.user_id, a.username, a.shop_name, a.shop_status, c.name, c.sdesc, c.ldesc, b.shop_id, b.cost, b.seller_notes
		FROM " . TABLE_USER_SHOPS . " a, " . TABLE_USER_SHOP_ITEMS . " b, `phpbb_shopitems` c
		WHERE a.id = b.shop_id
			AND a.shop_status <> 1
			AND b.id = '$item'
			AND c.id = b.item_id";
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, sprintf($lang['shop_error_selecting'], 'users shops'), '', __LINE__, __FILE__, $sql);
	}

	$sql_num_rows = $db->sql_numrows($result);

	if ( $sql_num_rows == '0' )
	{
		message_die(GENERAL_MESSAGE, "No such item exists in an open store!");
	}

	if ( !($row = $db->sql_fetchrow($result)) )
	{
		message_die(GENERAL_ERROR, sprintf($lang['shop_error_selecting'], 'users shops'), '', __LINE__, __FILE__, $sql);
	}

	if (file_exists('shop/images/' . $row['name'] . '.jpg')) { $item_image = $row['name'] . '.jpg'; }
	elseif (file_exists('shop/images/' . $row['name'] . '.gif')) { $item_image = $row['name'] . '.gif'; }

	$amount_owned = ( substr_count($userdata['user_items'], '' . $row['name'] . '') > 0 ) ? substr_count($userdata['user_items'], '' . $row['name'] . '') : '0';

	$template->assign_block_vars('switch_item_info', array(
		'ROW_CLASS' => $rownum,
		'ITEM_URL' => append_sid('shop_users_view.'.$phpEx.'?action=buy_item&item=' . $item),
		'ITEM_IMAGE' => $item_image,
		'ITEM_NAME' => $row['name'],
		'ITEM_L_DESC' => $row['ldesc'],
		'ITEM_COST' => $row['cost'],
		'ITEM_NOTES' => $row['seller_notes'],
		'ITEM_OWNED' => $amount_owned
	));
	
	$page_title = ucfirst($row['name']) . ' Information';
	$shoplocation = ' -> <a href="'.append_sid('shop_users.'.$phpEx, true).'" class="nav">User Shop List</a> -> <a href="' . append_sid('shop_users_view.' . $phpEx . '?shop=' . $row['shop_id'], true) . '" class="nav">' . $row['shop_name'] . '</a> -> <a href="' . append_sid('shop_users_view.' . $phpEx . '?action=display_item&item=' . $item, true) . '" class="nav">' . ucfirst($row['name']).' Information</a>';

	if ( !empty($userdata['user_specmsg']) )
	{
		$template->assign_block_vars('switch_special_msg', array(
			'SPECIAL_MSGS' => $userdata['user_specmsg'],
			'SPECIAL_MSGS_URL' => append_sid('shop.php?clm=true'),

			'L_CLEAR' => 'Clear Messages'
		));
	}

	$template->assign_vars(array(
		'U_INVENTORY' => append_sid("shop.$phpEx?action=inventory&searchid=".$userdata['user_id']),
		'USER_POINTS' => $userdata['user_points'] . ' ' . $board_config['points_name'],
		'L_INVENTORY' => 'Your Inventory',

		'SHOPLOCATION' => $shoplocation,
		'L_TABLE_TITLE' => 'Item Display'
	));
	$template->assign_block_vars('', array());

}

#Start buy item script
elseif ( $action == "buy_item" )
{
	if ( isset($HTTP_GET_VARS['item']) || isset($HTTP_POST_VARS['item']) ) { $item = ( isset($HTTP_POST_VARS['item']) ) ? intval($HTTP_POST_VARS['item']) : intval($HTTP_GET_VARS['item']); }
	else { $item = ''; }

	if ( !$userdata['session_logged_in'] )
	{
		$redirect = 'shop_users_view.'.$phpEx.'&action=buy_item&item=' . $item;
		header('Location: ' . append_sid("login.$phpEx?redirect=$redirect", true));
	}
	
	# Make sure item is still in user's shop!
	$sql = "SELECT a.user_id, a.shop_status, a.username, a.shop_name, a.id, b.cost, c.name
		FROM " . TABLE_USER_SHOPS . " a, " . TABLE_USER_SHOP_ITEMS . " b, `phpbb_shopitems` c
		WHERE a.id = b.shop_id
			AND c.id = b.item_id
			AND b.id = '$item'";
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, sprintf($lang['shop_error_selecting'], 'users/user shops/user shop items'), '', __LINE__, __FILE__, $sql);
	}

	$sql_num_rows = $db->sql_numrows($result);

	if ( !($sql_num_rows) )
	{
		message_die(GENERAL_MESSAGE, "No such item exists in any user owned shops!<br /><br />Click <a href=\"" . append_sid("shop_users.php") . "\" class=\"nav\">here</a> to return to main shop listing.");
	}
	if ( !($row = $db->sql_fetchrow($result)) )
	{
		message_die(GENERAL_ERROR, sprintf($lang['shop_error_selecting'], 'users/user shops/user shop items'), '', __LINE__, __FILE__, $sql);
	}

	#
	# Check if shop is closed for editting!
	if ( $row['shop_status'] == '2' )
	{
		message_die(GENERAL_MESSAGE, 'This shop is currently closed for restocking.<br /><br />Click <a href="' . append_sid("shop_users_view.php?shop=" . $row['id']) . '" class="nav">here</a> to return to the shop\'s inventory.<br /><br />Click <a href="' . append_sid("shop_users.php") . '" class="nav">here</a> to return to user shop listing.');
	}
	if ( $row['shop_status'] == '1' )
	{
		message_die(GENERAL_MESSAGE, 'This shop is currently closed.<br /><br />Click <a href="' . append_sid("shop_users.php") . '" class="nav">here</a> to return to user shop listing.');
	}

	#
	# Check currency & if has item
	if ( $board_config['multibuys'] == "off" ) 
	{
		if ( substr_count($userdata['user_items'],"" . $row['name'] . "") > 0 )
		{
			message_die(GENERAL_MESSAGE, "You cannot purchase an item you already own!");
		}
	}

	#Specific code for a special version of the shop, won't affect all shops due to the previous check!
	$item_limit = ( empty($board_config['shop_invlimit']) ) ? 0 : $board_config['shop_invlimit'];

	if ( (substr_count($userdata['user_items'],"") >= $item_limit) && ($item_limit != 0) )
	{
		message_die(GENERAL_MESSAGE, "Your inventory is already full, you cannot purchase more items!");
	}

	if ( $userdata['user_points'] < $row['cost'] )
	{
		message_die(GENERAL_MESSAGE, "You do not have enough to purchase this item!");
	}
	# End of check for currency and is has item
	#
	#start of table updates
	$useritems = addslashes($userdata['user_items']."" . $row['name'] . "");

	# Code to update purchaser's new currency & items
	$sql = "UPDATE " . USERS_TABLE . "
		SET user_points = user_points - {$row['cost']},
			user_items = '$useritems'
		WHERE user_id = '{$userdata['user_id']}'";
	if ( !($db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, sprintf($lang['shop_error_updating'], 'users'), '', __LINE__, __FILE__, $sql);
	}

	# Code to remove the item from the shop
	$sql = "DELETE
		FROM " . TABLE_USER_SHOP_ITEMS . "
		WHERE id = '$item'";
	if ( !($db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, sprintf($lang['shop_error_deleting'], 'users shops items'), '', __LINE__, __FILE__, $sql);
	}

	# Check if $cost needs to be set back, if tax is set
	if ( $board_config['u_shops_tax_percent'] > 0 )
	{
		$cost = $row['cost'] - ($row['cost'] / 100 * $row['u_shops_tax_percent']);
	}
	else
	{
		$cost = $row['cost'];
	}
	# Code to update left items, items sold, holding amount, amount earnt!
	$sql = "UPDATE " . TABLE_USER_SHOPS . "
		set items_sold = items_sold + 1, 
			items_holding = items_holding - 1,
			amount_holding = amount_holding + $cost,
			amount_earnt = amount_earnt + $cost
		WHERE user_id = '{$row['user_id']}'";
	if ( !($db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, sprintf($lang['shop_error_updating'], 'users shops'), '', __LINE__, __FILE__, $sql);
	}

	#end of table updates
	#

	$page_title = "Buy ".$row['name'];

	message_die(GENERAL_MESSAGE, 'You have successfully purchased ' . $row['name'] . ' for ' . $row['cost'] . ' from ' . $row['shop_name'] . ' owned by ' . $row['username'] . '.<br /><br />Click <a href="' . append_sid("shop_users_view.php?shop=" . $row['id']) . '" class="nav">here to return to ' . $row['shop_name'] . '.<br /><br />Click <a href="' . append_sid("shop_users.php") . '" class="nav">here</a> to return to the user shop index.');
}

else 
{
	message_die(GENERAL_MESSAGE, 'This is not a valid command!');
}

//
// Start output of page
//
include($phpbb_root_path . 'includes/page_header.' . $phpEx);

//
// Generate the page
//
$template->pparse('body');

include($phpbb_root_path . 'includes/page_tail.' . $phpEx);

?>