<?php
/***************************************************************************
*                            $RCSfile: nivisec_install.php,v $
*                            -------------------
*   copyright            : (C) 2003 Nivisec.com
*   email                : support@nivisec.com
*
*   $Id: nivisec_install.php,v 1.3 2003/09/03 02:52:46 nivisec Exp $
*
*
***************************************************************************/

/***************************************************************************
*
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
*
***************************************************************************/
if (!defined('IN_PHPBB')) define('IN_PHPBB', TRUE);
define('PHPBB_VERSION_USED', '2.0.5');
define('REQUIRED_PHP', '4.0.1');
define('MOD_VERSION', '1.2.1');
define('MOD_NAME', 'Color Groups');
$error_msg = '';
$info_msg = '';

$phpbb_compatibility = array(
'2.0.17' => true,
'2.0.16' => true,
'2.0.15' => true,
'2.0.14' => true,
'2.0.13' => true,
'2.0.6' => true,
'2.0.5' => true,
'2.0.4' => true,
'2.0.3' => false,
);

$mode_list = array(
'New Install' => 'nivisec_schema/install.sql',
'Update 1.1.0 -> 1.2.0' => 'nivisec_schema/update_110x120.sql'
);

/******************************************************************************************
/** Check for a mode specified
/*****************************************************************************************/
if (!isset($HTTP_GET_VARS['mode']) && !isset($HTTP_GET_VARS['submit']))
{
	print_header();
	print_version_check();
	print_compatbility_check();
	print_modes_select();
	print_footer();
}
else
{
	print_header();
	
	$sql_queue_list = $mode_list[$HTTP_GET_VARS['mode']];
	
	/******************************************************************************************
	/** Look for phpBB root path.
	/*****************************************************************************************/
	if (file_exists('./config.php')) $phpbb_root_path = './';
	elseif (file_exists('../config.php')) $phpbb_root_path = '../';
	else $error_msg .= 'Can not find the phpbb root path!  Make sure this file is in your phpBB directory.<br>';
	$info_msg .= 'Found phpbb root path at '.$phpbb_root_path.'.<br>';
	
	/******************************************************************************************
	/** Read the correct SQL queue list
	/*****************************************************************************************/
	$info_msg .= 'Using sql queue list file '.$sql_queue_list.'.<br>';
	if ($fp = @fopen($sql_queue_list, "r"))
	{
		$coments_pattern = "/##(.)*\n/";
		$seperator = ";";
		$file_data = @fread($fp, filesize($sql_queue_list));
		fclose($fp);
		
		//Get rid of any comments
		$file_data = preg_replace($coments_pattern, '', $file_data);
		
		//Explode it
		$sql_queue = explode($seperator, $file_data);
		//Remove blank entries
		for ($i=0; $i < count($sql_queue); $i++)
		{
			$sql_queue[$i] = trim($sql_queue[$i]);
			if ($sql_queue[$i] == '') unset($sql_queue[$i]);
		}
	}
	else $error_msg .= 'Can not open '.$sql_queue_list.'.  It is needed to continue!<br>';
	
	/******************************************************************************************
	/** Check php version
	/*****************************************************************************************/
	$info_msg .= 'Found php version '.phpversion().'.<br>';
	//Check php version
	if (phpversion() < REQUIRED_PHP) $error_msg .= 'php version '.REQUIRED_PHP.' or greater is required for this hack.';
	
	if (empty($error_msg))
	{
		/******************************************************************************************
		/** Includes
		/*****************************************************************************************/
		include($phpbb_root_path.'extension.inc');
		include($phpbb_root_path.'config.'.$phpEx);
		include($phpbb_root_path.'includes/constants.'.$phpEx);
		include($phpbb_root_path.'includes/db.'.$phpEx);
		
		/******************************************************************************************
		/** Get phpBB version
		/*****************************************************************************************/
		$sql = 'SELECT config_value FROM ' . CONFIG_TABLE . "
		WHERE config_name = 'version'";
		$result = $db->sql_query($sql);
		$vrow = $db->sql_fetchrow($result);
		$phpbb_version = '2'.$vrow['config_value'];
		print_compatbility_check($phpbb_version);
		print '<br><br>';
		$info_msg .= 'Found phpbb version '.$phpbb_version.'.<br>';
		//if ($phpbb_version != PHPBB_VERSION_USED) $info_msg .= '<font color="red">Warning:</font> This hack was designed on phpbb version '.PHPBB_VERSION_USED.'.  It may or may not work for your version of phpbb!<br>';
		
		print '<span class="gen">'.$info_msg.'</span><br><br>';
		
		/******************************************************************************************
		/** Process the SQL queue
		/*****************************************************************************************/
		for($i=0; $i < count($sql_queue); $i++)
		{
			$sql = str_replace('phpbb_', $table_prefix, $sql_queue[$i]);
			if (!$db->sql_query($sql))
			{
				$error = $db->sql_error();
				$error_m = $error['message'];
				$error_info = (substr_count($error_m, 'Duplicate') || substr_count($error_m, 'already exists')) ? '<br><b>Analysis:</b><span class="gen">This is considered a duplicate entry and can be ignored as a failure because the needed information is already inserted.</span>' : '';
				echo "[<font color=\"red\">FAILED</font>] <span class=\"gensmall\">:: $sql</span><br />
		<b>Reason:</b><span class=\"gen\">$error_m</span>
		$error_info<br /><br />";
			}
			else
			{
				print '[<font color="green">OK</font>] <span class="gensmall">:: ' . $sql . '</span><br /><br />';
			}
		}
		print '<br /><span class="maintitle">Please delete this file ('.basename($HTTP_SERVER_VARS['PHP_SELF']).') and nivisec_schema/*.* for security reasons!</span>';
	}
	/******************************************************************************************
	/** Print the error message if it exists.
	/*****************************************************************************************/
	else
	{
		print '<span class="gen"><font color="red">'.$error_msg."</font></span>";
	}
	print_footer();
}

function print_header()
{
	echo '<html><head><title>SQL Install</title><style type="text/css">
<!--
body {
	background-color: #E5E5E5;
	scrollbar-face-color: #DEE3E7;
	scrollbar-highlight-color: #FFFFFF;
	scrollbar-shadow-color: #DEE3E7;
	scrollbar-3dlight-color: #D1D7DC;
	scrollbar-arrow-color:  #006699;
	scrollbar-track-color: #EFEFEF;
	scrollbar-darkshadow-color: #98AAB1;
}
font,th,td,p { font-family: Verdana, Arial, Helvetica, sans-serif }
a:link,a:active,a:visited { color : #006699; }
a:hover		{ text-decoration: underline; color : #DD6900; }
hr	{ height: 0px; border: solid #D1D7DC 0px; border-top-width: 1px;}
.bodyline	{ background-color: #FFFFFF; border: 1px #98AAB1 solid; }
.forumline	{ background-color: #FFFFFF; border: 2px #006699 solid; }

td.row1	{ background-color: #EFEFEF; }
td.row2	{ background-color: #DEE3E7; }
td.row3	{ background-color: #D1D7DC; }
td.cat,td.catHead,td.catSides,td.catLeft,td.catRight,td.catBottom {
			background-image: url(templates/subSilver/images/cellpic1.gif);
			background-color:#D1D7DC; border: #FFFFFF; border-style: solid; height: 28px;
}
td.cat,td.catHead,td.catBottom {
	height: 29px;
	border-width: 0px 0px 0px 0px;
}
th.thHead,th.thSides,th.thTop,th.thLeft,th.thRight,th.thBottom,th.thCornerL,th.thCornerR {
	font-weight: bold; border: #FFFFFF; border-style: solid; height: 28px;
}
td.row3Right,td.spaceRow {
	background-color: #D1D7DC; border: #FFFFFF; border-style: solid;
}

th.thHead,td.catHead { font-size: 12px; border-width: 1px 1px 0px 1px; }
th.thSides,td.catSides,td.spaceRow	 { border-width: 0px 1px 0px 1px; }
th.thRight,td.catRight,td.row3Right	 { border-width: 0px 1px 0px 0px; }
th.thLeft,td.catLeft	  { border-width: 0px 0px 0px 1px; }
th.thBottom,td.catBottom  { border-width: 0px 1px 1px 1px; }
th.thTop	 { border-width: 1px 0px 0px 0px; }
th.thCornerL { border-width: 1px 0px 0px 1px; }
th.thCornerR { border-width: 1px 1px 0px 0px; }
.maintitle	{
	font-weight: bold; font-size: 22px; font-family: "Trebuchet MS",Verdana, Arial, Helvetica, sans-serif;
	text-decoration: none; line-height : 120%; color : #000000;
}
.gen { font-size : 12px; }
.genmed { font-size : 11px; }
.gensmall { font-size : 10px; }
.gen,.genmed,.gensmall { color : #000000; }
a.gen,a.genmed,a.gensmall { color: #006699; text-decoration: none; }
a.gen:hover,a.genmed:hover,a.gensmall:hover	{ color: #DD6900; text-decoration: underline; }
.cattitle		{ font-weight: bold; font-size: 12px ; letter-spacing: 1px; color : #006699}
a.cattitle		{ text-decoration: none; color : #006699; }
a.cattitle:hover{ text-decoration: underline; }
.copyright		{ font-size: 10px; font-family: Verdana, Arial, Helvetica, sans-serif; color: #444444; letter-spacing: -1px;}
a.copyright		{ color: #444444; text-decoration: none;}
a.copyright:hover { color: #000000; text-decoration: underline;}
-->
</style></head><body>
<table width="100%" cellspacing="0" cellpadding="10" border="0" align="center">
<tr><td class="bodyline"><table width="100%" cellspacing="0" cellpadding="0" border="0"><tr> 
<td><a href="http://www.nivisec.com"><img src="http://www.nivisec.com/images/phpbb/random_logo.php" border="0" vspace="1" /></a></td>
<td align="center" width="100%" valign="middle"><span class="maintitle">'.MOD_NAME.'<br>Database Table Install</span></td></tr></table><br />';
}

function print_footer()
{
	echo '</table><br><div align="center"><span class="copyright">
Powered by <a href="http://www.phpbb.com/" target="_phpbb" class="copyright">phpBB</a> &copy; 2001, 2002 phpBB Group<br />
Table Install by <a href="http://www.nivisec.com" target="_nivisec" class="copyright">Nivisec.com</a></span></div>
</td></tr></table></body></html>';	
}

function print_modes_select()
{
	global $mode_list;
	
	echo '
	<form action="'.basename(__FILE__).'" method="get" name="choose_form">
	<center><span class="gen">Choose an option:&nbsp;&nbsp;
	<select name="mode">';
	foreach($mode_list as $name => $file)
	{
		echo '
		<option>'.$name.'</option>';
	}
	echo '
	</select><br /><input type="submit" name="submit" value="Submit"></form>';
}

function print_version_check()
{
	// Taken From and Modified //
	
	/***************************************************************************
	*                            $-RCSfile: nivisec_version_check.php,v -$
	*                            -------------------
	*   copyright            : (C) 2002-2003 Nivisec.com
	*   email                : support@nivisec.com
	*
	*   $-Id: nivisec_version_check.php,v 1.1.1.1 2003/07/25 03:37:40 nivisec Exp -$
	*
	*
	***************************************************************************/
	
	// Make notice of this (c) that covers this section only //
	// Since I own the Copyright, I can of course modify and re-distribute it as I am doing here //
	
	/***************************************************************************
	*
	*   This section IS NOT FREE SOFTWARE.  You may not modify it and re-distribute
	*   it in any way.  It is not covered under the GPL by my own wish!  This is done
	*   for security purposes.
	*
	*   Billy Sauls, of Nivisec.com, retains 100% of the copyright to this section.
	*
	***************************************************************************/
	define('MOD_CODE', 24);
	
	print '<span class="gen">You are installing version '. MOD_VERSION.'.<br>Checking version data at Nivisec.com...';
	$check_fp = @fopen('http://www.nivisec.com/check_version.php?code=' . MOD_CODE, "r");
	list($mod_version, $checker_version) = explode(":", @fread($check_fp, 4096));
	@fclose($fp);
	print 'Done.<br><br>';
	if ($mod_version > MOD_VERSION)
	{
		print 'A newer version ('.$mod_version.') was found to be released and you should probably install it instead.  <a href="http://www.nivisec.com/phpbb.php?l=p">Click here</a> to visit the project download page.</span>';
	}
	elseif ($mod_version == MOD_VERSION)
	{
		print 'You have the latest release ('.$mod_version.'), please proceed with the install.  <a href="http://www.nivisec.com/phpbb.php?l=p">Click here</a> to visit Nivisec.com to view additonal phpBB modifications you may like.</span>';
	}
	else
	{
		print 'Version info was not available or there was an error.  <a href="http://www.nivisec.com/phpbb.php?l=p">Click here</a> to manually check to see if you have the latest version.</span>';
	}
	print '<br><br>';
}

function print_compatbility_check($user_version = '')
{
	global $phpbb_compatibility;
	
	$version_work_list = '';
	$version_not_work_list = '';
	
	foreach ($phpbb_compatibility as $ver => $work)
	{
		if ($work)
		{
			$version_work_list .= ($version_work_list != '') ? ', ' : '';
			$version_work_list .= $ver;
		}
		else
		{
			$version_not_work_list .= ($version_not_work_list != '') ? ', ' : '';
			$version_not_work_list .= $ver;
		}		
	}
	
	if (empty($version_not_work_list))
	{
		$version_not_work_list = 'None listed.';
	}
	
	if (empty($user_version))
	{
		printf ('<span class="gen"><font color="green">Found to work</font> on phpBB version(s) %s.</span><br>', $version_work_list);
		printf ('<span class="gen"><font color="red">Found to not work</font> on phpBB version(s) %s.</span><br>', $version_not_work_list);		
	}
	else 
	{
		if (preg_match("/$user_version/", $version_work_list))
		{
			print '<span class="gen">Your phpBB version is <font color="green">found to work</font> with this mod.</span><br>';			
		}
		elseif (preg_match("/$user_version/", $version_not_work_list))
		{
			print '<span class="gen">Your phpBB version is <font color="red">found to NOT work</font> with this mod.  Please update your phpBB version.</span><br>';			
		}
		else 
		{
			print '<span class="gen">The working status of your phpBB version with this mod is unknown.  <u>It may or may not work correctly.</u>  If it is higher than '.PHPBB_VERSION_USED .' it will probably work, but no guarantees.</span><br>';			
		}	
	}	
}
?>