function initEvents() {
	document.onmousemove = drag;
	document.onmouseup = stop;
	document.getElementById("innerMap").onmousedown = start;
	document.getElementById("innerMap").onmouseup = stop;
}

var dragObj = null;
var xpos = 0;
var ypos = 0;

function start(e) {
	if(dragObj != null) return;
	
	xpos = e.clientX;
	ypos = e.clientY;
	
	dragObj = document.getElementById("innerMap");	
}

function drag(e) {
	if(dragObj == null) return;

	
	var dir = getDirection(e);
	
	switch(dir) {
		case "l":
			console.log("go to the left");
			document.getElementById("innerMap").style.left = ($("#innerMap").position().left - 2) + "px";
			break;
		case "r":
			console.log("go to the right");
			document.getElementById("innerMap").style.left = ($("#innerMap").position().left + 2) + "px";
			break;
		case "t":
			console.log("go to the top");
			document.getElementById("innerMap").style.top = ($("#innerMap").position().top - 2) + "px";
			break;
		case "b":
			console.log("go to the bottom");
			document.getElementById("innerMap").style.top = ($("#innerMap").position().top + 2) + "px";
			break;
		default:
			return;
	}
	
	xpos = e.clientX;
	ypos = e.clientY;
	
}

function stop() {
	dragObj = null;
}

function getDirection(e) {

	var dir = "no";

	if(e.clientX > xpos) dir = "r";
	else if(e.clientX < xpos) dir = "l";
	else if(e.clientY > ypos) dir = "b";
	else if(e.clientY < ypos) dir = "t";

	return dir;
}