<html>
<head>
<title>Example of HTMLArea 3.0</title>

<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />

<script type="text/javascript">
  _editor_url = "./htmlarea/";
  _editor_lang = "en";
</script>


<script type="text/javascript" src="htmlarea/htmlarea.js"></script>
<script type="text/javascript" src="htmlarea/dialog.js"></script>

<script type="text/javascript">

      HTMLArea.loadPlugin("TableOperations");
      HTMLArea.loadPlugin("SpellChecker");
      HTMLArea.loadPlugin("FullPage");
      HTMLArea.loadPlugin("CSS");
      HTMLArea.loadPlugin("ContextMenu");
</script>

<style type="text/css">
html, body {
  font-family: Verdana,sans-serif;
  background-color: #fea;
  color: #000;
}
a:link, a:visited { color: #00f; }
a:hover { color: #048; }
a:active { color: #f00; }

textarea { background-color: #fff; border: 1px solid 00f; }
</style>

<script type="text/javascript">
var editor = null;
function initEditor() {

  // create an editor for the "text" textbox
  editor = new HTMLArea("text");

  // register the FullPage plugin
  editor.registerPlugin(FullPage);

  // register the SpellChecker plugin
  editor.registerPlugin(TableOperations);

  // register the SpellChecker plugin
  // editor.registerPlugin(SpellChecker);

  // register the CSS plugin
  editor.registerPlugin(CSS, {
    combos : [
      { label: "Syntax:",
                   // menu text       // CSS class
        options: { "None"           : "",
                   "Code" : "code",
                   "String" : "string",
                   "Comment" : "comment",
                   "Variable name" : "variable-name",
                   "Type" : "type",
                   "Reference" : "reference",
                   "Preprocessor" : "preprocessor",
                   "Keyword" : "keyword",
                   "Function name" : "function-name",
                   "Html tag" : "html-tag",
                   "Html italic" : "html-helper-italic",
                   "Warning" : "warning",
                   "Html bold" : "html-helper-bold"
                 },
        context: "pre"
      },
      { label: "Info:",
        options: { "None"           : "",
                   "Quote"          : "quote",
                   "Highlight"      : "highlight",
                   "Deprecated"     : "deprecated"
                 }
      }
    ]
  });

  // add a contextual menu
  editor.registerPlugin("ContextMenu");

  // load the stylesheet used by our CSS plugin configuration
  editor.config.pageStyle = "@import url(custom.css);";



  setTimeout(function() {
    editor.generate();
  }, 500);
  return false;
}

function insertHTML() {
  var html = prompt("Enter some HTML code here");
  if (html) {
    editor.insertHTML(html);
  }
}
function highlight() {
  editor.surroundHTML('<span style="background-color: yellow">', '</span>');
}
</script>

</head>

<!-- use <body onload="HTMLArea.replaceAll()" if you don't care about
     customizing the editor.  It's the easiest way! :) -->
<body onload="initEditor()">

<form action="newsscript.admin.php" method="post" id="edit" name="edit">

<table>
<tr>
<td width="91">
<a>Author:</a>
</td>
<td width="411">
<input name="name" type="text" id="AUTOHR" value="{name}" maxlength="50">
</td>
</tr>

<tr>
<td colspan="2">
<textarea id="text" name="text" style="width:100%" rows="24" cols="80">{text}</textarea>
</td>
</tr>
</table>

<input type="submit" name="submit" value="   Abschicken  " />
<input type="button" name="ins"  value="  insert html  " onclick="return insertHTML();" />
<input type="button" name="hil"  value="  highlight text  " onclick="return highlight();" />
<input type="hidden" name="task" value="save" />
<input type="hidden" name="typ"  value="{typ}" />
<input type="hidden" name="id"   value="{id}" />

<!-- <a href="javascript:mySubmit()">submit</a> -->

<script type="text/javascript">
function mySubmit() {
// document.edit.save.value = "yes";
document.edit.onsubmit(); // workaround browser bugs.
document.edit.submit();
};
</script>

</form>

</body>
</html>
