(function($) {
    $.fn.extend({
        jContextMenu: function(items, options) {
			var defaults={
				hoverClass: "ui-context-hover",
				expendClass: "ui-context-expendable",
				iconClass: "ui-context-icon",
				iconSelfClass: "ui-icon",
				menuClass: "ui-contextmenu",
				menuItemClass: "ui-contextmenu-entry",
				openOn: "rclick",
				show: "pop"
			};
			/** Optionen fr openOn:
				"rclick" -> rechtsclick,
				"lclick" -> linksclick,
				"hover" -> jQuery onMouseEnter
			**/
			/** Optionen fr show / hide
				"pop" -> wird per display: none/block gezeigt,
				Zahlenwert -> wird in diesem zeitraum (millisekunden) geblendet
				Funktion (DOM) -> wird aufgerufen (DOM ist das Contextmenu)
			**/
			options=$.extend(defaults, options);
			var menu=document.createElement("div");
			var nested_menus=appendMenuTo(items, menu);
			var menu_wrapper_object={
				dom: menu,
				hide: function() {
					for (var i=0;i<nested_menus.length;i++) {
						if (nested_menus[i].toString()=="x-menu-object") {
							nested_menus[i].hide();
						} else {
							nested_menus[i].style.display="none";
						}
					}
				},
				toString: function() {
					return "x-menu-object";
				}
			};
			menu.style.display="none";
			$(menu).addClass(options.menuClass);
			document.body.appendChild(menu);
            $(this).each(function() {
				var openFunc, hideFunc;
				var menuable_object=this;
				$(menuable_object).unbind("click").unbind("rightclick").unbind("hover");
				var parent=$(menuable_object).parent();
				var oF=function(e) {
					var p={};
					if (parent.hasClass(options.menuClass)) {
						var obj=$(menuable_object).get()[0];
						var obj2=parent.get()[0];
						p.Y=obj2.offsetTop+obj.offsetTop;
						p.X=obj2.offsetLeft+obj2.offsetWidth;
					} else {
						p=mousePos(e);
					}
					menu.style.marginTop=p.Y;
					menu.style.marginLeft=p.X;
					if ($(parent).hasClass(options.menuClass)==false) $("."+options.menuClass).css("display", "none")
				}
				if (typeof options.show=="integer") {
					openFunc=function() {
						$(menu).fadeIn(options.show);
					}
				} else if (typeof options.show=="function" || typeof options.show=="object") {
					openFunc=function() {
						try {
							options.show(menu);
						} catch (E) {}
					}
				} else {
					openFunc=function() {
						menu.style.display="block";
					}
				}
				if (typeof options.hide=="integer") {
					hideFunc=function() {
						$("."+options.menuClass).fadeOut(options.hide);
					}
				} else if (typeof options.hide=="function" || typeof options.hide=="object") {
					hideFunc=function() {
						try {
							options.hide(menu);
						} catch (E) {}
					}
				} else {
					hideFunc=function() {
						$("."+options.menuClass).css("display", "none");
					}
				}
				switch (options.openOn) {
					case "rclick":
						$(this).mousedown(function(event) {
							event.stopPropagation();
							$(this).mouseup(function(event) {
								$(this).unbind("mouseup");
								event.stopPropagation();
								if (event.which==3) {
									oF(event);
									openFunc();
								}
								window.setTimeout(function(){
									$("*:not(."+options.menuClass+")").click(function(event) {
										$("*:not(."+options.menuClass+"):not(."+options.menuItemClass+")").unbind("click");
										hideFunc();
										return false;
									});
								}, 200);
								return false;
							});
							return false;					
						});
					break;
					case "lclick":
						$(this).mousedown(function(event) {
							$(this).mouseup(function() {
								$(this).unbind("mouseup");
								if (event.which==1) {
									oF(event);
									openFunc();
								}
								return false;
							});
							return false;
						});
					break;
					case "hover":
						$(this).mouseenter(function(event) {
							oF(event);
							openFunc();
						});
					break;
				}
				$(menuable_object).add($("."+options.menuClass)).bind("contextmenu", function(){ return false; });
			});
			return menu_wrapper_object;
			function appendMenuTo(items, menu) {
				var tags=new Array();
				var expands=new Array();
				var expand_m=new Array();
				var hide=function() {
					for (var i=0;i<expands.length;i++) {
						expand_m[i].hide();
					}
				};
				for (key in items) {
					var item=items[key];
					var current_tag=document.createElement("a");
					var _current_tag=$(current_tag);
					_current_tag.addClass(options.menuItemClass);
					if (item.icon) {
						_current_tag.addClass(options.iconClass);
						var icon_span=document.createElement("span");
						$(icon_span).addClass(options.iconSelfClass).html("&nbsp;");
						icon_span.style.background="url("+item.icon+") top left no-repeat";
						current_tag.appendChild(icon_span);
					}
					if (item.hover) {
						_current_tag.mouseenter(item.hover);
					}
					_current_tag.hover(function() {
						$(this).addClass(options.hoverClass);
					},function() {
						$(this).removeClass(options.hoverClass);
					});
					if (item.click) {
						_current_tag.click(item.click);
					}
					menu.appendChild(current_tag);
					tags.push(current_tag);
					_current_tag.append(key);
					if (item.expand) {
						// untermen
						_current_tag.addClass(options.expendClass);
						var o2=clone(options);
						o2.openOn="hover";
						expand_m.push(_current_tag.jContextMenu(item.expand, o2));
						expands.push(current_tag);
					}
				}
				for (var i=0;i<tags.length;i++) {
					var cur_tag=tags[i];
					for (var n=0;n<expands.length;n++) {
						if (cur_tag==expands[n]) continue;
						$(cur_tag).mouseenter(function() {
							hide();
						});
					}
				}
				expand_m.push(menu);
				return expand_m;
			}
			function mousePos(e) {
				var d={}, x, y;
				if (self.innerHeight) {
					d.pageYOffset=self.pageYOffset;
					d.pageXOffset=self.pageXOffset;
					d.innerHeight=self.innerHeight;
					d.innerWidth=self.innerWidth;
				} else if (document.documentElement && document.documentElement.clientHeight) {
					d.pageYOffset=document.documentElement.scrollTop;
					d.pageXOffset=document.documentElement.scrollLeft;
					d.innerHeight=document.documentElement.clientHeight;
					d.innerWidth=document.documentElement.clientWidth;
				} else if (document.body) {
					d.pageYOffset=document.body.scrollTop;
					d.pageXOffset=document.body.scrollLeft;
					d.innerHeight=document.body.clientHeight;
					d.innerWidth=document.body.clientWidth;
				}
				(e.pageX) ? x=e.pageX : x=e.clientX+d.scrollLeft;
				(e.pageY) ? y=e.pageY : y=e.clientY+d.scrollTop;
				return {X: x, Y: y};
			}
			function clone(obj){
				var c={};
				for (key in obj) {
					if (typeof obj.key == 'object') {
						eval("c."+key+"=clone(obj.key);");
					} else {
						eval("c."+key+"=obj.key");
					}
				}
				return c;
			}
        }
    });
})(jQuery);