/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;

public class Clipport_LanguageFile_Editor {
    private LFile file;
    private JFrame frame;
    private String orig_filename;
    private static boolean changes = false;
    private final JTabbedPane t_pane = new JTabbedPane(1);
    private final JPanel p3 = new JPanel();
    public static Clipport_LanguageFile_Editor instance;

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ignore) {
            // empty catch block
        }
        if (args.length != 0) {
            Clipport_LanguageFile_Editor app = new Clipport_LanguageFile_Editor(args[0]);
            app.display();
        } else {
            JFileChooser fc = new JFileChooser();
            int f = fc.showOpenDialog(null);
            if (f == 0) {
                Clipport_LanguageFile_Editor app = new Clipport_LanguageFile_Editor(fc.getSelectedFile().getPath());
                app.display();
            } else {
                System.exit(-1);
            }
        }
    }

    public Clipport_LanguageFile_Editor(String file) {
        this.file = FileLoader.load(file);
        this.orig_filename = file.substring(file.lastIndexOf("\\") + 1);
        instance = this;
    }

    public void display() {
        this.frame = new JFrame(this.orig_filename);
        JScrollPane[] ps = this.createScreens();
        this.t_pane.add("Deutsch", ps[0]);
        this.t_pane.add("Englisch", ps[1]);
        JButton saveBT = new JButton("Speichern");
        saveBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Clipport_LanguageFile_Editor.this.file.save();
                JOptionPane.showMessageDialog(null, Clipport_LanguageFile_Editor.this.orig_filename + " erfolgreich gespeichert", "Gespeichert", 1);
            }
        });
        this.p3.setLayout(new BoxLayout(this.p3, 1));
        this.p3.add(saveBT);
        JButton addBT = new JButton("hinzuf\u00fcgen");
        addBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String name = JOptionPane.showInputDialog(null, (Object)"Name des Feldes:");
                if (name != null) {
                    Clipport_LanguageFile_Editor.this.file.add(new Item(name, "", ""));
                    Clipport_LanguageFile_Editor.changed();
                    Clipport_LanguageFile_Editor.this.revalidate();
                }
            }
        });
        this.p3.add(addBT);
        this.t_pane.add("Optionen", this.p3);
        this.frame.add(this.t_pane);
        this.frame.setSize(700, 500);
        this.frame.setLocationRelativeTo(null);
        this.frame.addWindowListener(new editorCloseOperation());
        this.frame.setDefaultCloseOperation(0);
        this.frame.setJMenuBar(new MenuBar().getMain());
        this.frame.add((Component)new JLabel("Copyright 2010 by Tobias Marstaller and www.clipport.com"), "South");
        this.frame.setVisible(true);
    }

    public static void changed() {
        changes = true;
    }

    public static void fileSaved() {
        changes = false;
    }

    public int closeConfirm() {
        if (changes) {
            int s = JOptionPane.showConfirmDialog(null, "\u00c4nderungen in " + this.orig_filename + " speichern?", "Speichern?", 1);
            if (s == 0) {
                return 0;
            }
            return s;
        }
        return -1;
    }

    public void closeCurrent() {
        int s = this.closeConfirm();
        if (s != 2) {
            if (s == 0) {
                this.file.save();
            }
            this.frame.setVisible(false);
            changes = false;
        }
    }

    public void save() {
        this.file.save();
    }

    private JScrollPane[] createScreens() {
        JScrollPane[] ps = new JScrollPane[2];
        JPanel p1 = new editor(this.file, 0).getPanel();
        JPanel p2 = new editor(this.file, 1).getPanel();
        JScrollPane jsp1 = new JScrollPane(p1);
        JScrollPane jsp2 = new JScrollPane(p2);
        jsp1.setHorizontalScrollBarPolicy(32);
        jsp1.setVerticalScrollBarPolicy(22);
        jsp2.setHorizontalScrollBarPolicy(32);
        jsp2.setVerticalScrollBarPolicy(22);
        ps[0] = jsp1;
        ps[1] = jsp2;
        return ps;
    }

    public void revalidate() {
        this.t_pane.removeAll();
        JScrollPane[] n = this.createScreens();
        this.t_pane.add("Deutsch", n[0]);
        this.t_pane.add("Englisch", n[1]);
        this.t_pane.add("Optionen", this.p3);
        System.gc();
    }

    class editorCloseOperation
    implements WindowListener {
        editorCloseOperation() {
        }

        @Override
        public void windowOpened(WindowEvent parm1) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            int s = Clipport_LanguageFile_Editor.this.closeConfirm();
            if (s == 0) {
                Clipport_LanguageFile_Editor.this.file.save();
                System.exit(-1);
            } else if (s != 2) {
                System.exit(-1);
            }
        }

        @Override
        public void windowClosed(WindowEvent e) {
        }

        @Override
        public void windowIconified(WindowEvent parm1) {
        }

        @Override
        public void windowDeiconified(WindowEvent parm1) {
        }

        @Override
        public void windowActivated(WindowEvent parm1) {
        }

        @Override
        public void windowDeactivated(WindowEvent parm1) {
        }
    }
}

