<?php
/*
 * JSONBuilder Class
 * Copyright by Tobias Marstaller 
 *
 */
interface JSONItem {
	public function add($key, $value);
	public function remove($key=null);
	public function render();
}
class JSONObject implements JSONItem {
	private $obj;
	public function __construct() {
		$this->obj=array();
		$this->keys=array();
	}
	public function add($key, $value) {
		$this->obj[$key]=$value;
	}
	public function remove($key=null) {
		if ($key!=null) {
			unset($this->obj[$key]);
		} else unset($this->obj[count($this->obj)-1]);
	}
	public function render() {
		echo "{";
		$i=0;
		$j=count($this->obj);
		foreach ($this->obj as $key=>$object) {
			$this->renderKey($key);
			if (gettype($object)=="array") {
				$this->renderArray($object);
			} else if (gettype($object)=="string") {
				echo '"'.$object.'"';
			} else if ($object instanceof JSONItem) {
				$object->render();
			} else echo $object;
			$i++;
			if ($i!=$j) echo ",";
		}
		echo "}";
	}
	
	public static function renderKey($key) {	
		if (gettype($key)=="string") {
			echo '"'.$key.'"';
		} else echo $key;
		echo ":";
	}
	public static function renderArray($ar) {
		$ar=new JSONArray($ar);
		$ar->render();
	}
}
class JSONArray implements JSONItem {
	private $ar;
	public function __construct($ar=null) {
		if ($ar==null) {
			$this->ar=array();
		} else $this->ar=$ar;
	}
	public function add($key, $value=null) {
		$ar=func_get_args();
		if (count($ar)==1) {
			$this->ar[]=$key;
		} else {
			$this->ar[]=$value;
		}
	}
	public function remove($key=null) {
		if ($key!=null) {
			unset($this->ar[$key]);
		} else unset($this->ar[count($this->ar)-1]);
	}
	public function render() {
		echo "[";
		$i=0;
		$j=count($this->ar);
		foreach ($this->ar as $value) {
			if ($value instanceof JSONItem) {
				$value->render();
			} elseif (gettype($value)=="array") {
				JSONObject::renderArray($value);
			} elseif (gettype($value)=="string") {
				echo '"'.$value.'"';
			} else echo $value;
			$i++;
			if ($i!=$j) echo ",";
		}
		echo "]";
	}
}
?>