<?php

	error_reporting(E_ALL);
	header('Content-Type: text/html; charset=UTF8');

	class AES_Handler
	{

		/*
		*
		*	AES_Handler::encrypt()
		*
		*	This function encrypts the text $text with the AES-key $key;
		*	It returns the encryptet text - commonly known as cipher text.
		*
		*/

		public static function encrypt($text, $key)
		{
			$td = mcrypt_module_open(MCRYPT_RIJNDAEL_256, '', MCRYPT_MODE_ECB, '');
			$iv = mcrypt_create_iv(mcrypt_enc_get_iv_size($td), MCRYPT_DEV_RANDOM);
			$ks = mcrypt_enc_get_key_size($td);
			$key = substr($key, 0, $ks);
			mcrypt_generic_init($td, $key, $iv);
			$encrypted = mcrypt_generic($td, $text);
			mcrypt_generic_deinit($td);
			mcrypt_module_close($td);
			return trim($encrypted);
		}

		/*
		*
		*	AES_Handler::decrypt()
		*
		*	This function decryptas the cypher $text with the AES-key $key;
		*	It returns the decrypted text.
		*
		*/

		public static function decrypt($text, $key)
		{
			$td = mcrypt_module_open(MCRYPT_RIJNDAEL_256, '', MCRYPT_MODE_ECB, '');
			$iv = mcrypt_create_iv(mcrypt_enc_get_iv_size($td), MCRYPT_DEV_RANDOM);
			$ks = mcrypt_enc_get_key_size($td);
			$key = substr($key, 0, $ks);
			mcrypt_generic_init($td, $key, $iv);
			$decrypted = mdecrypt_generic($td, $text);
			mcrypt_generic_deinit($td);
			mcrypt_module_close($td);
			return trim($decrypted);
		}

		/*
		*
		*	AES_Handler::get_random_key()
		*
		*	This function returns a random key for the AES-encryption.
		*
		*/

		public static function get_random_key()
		{
			$back = '';
			for($i = 0; $i < 32; $i++)
				$back .= dechex(rand(0, 15));
			return $back;
		}
	}

	class RSA_Handler
	{

		/*
		*
		*	RSA_Handler::get_random_prime()
		*
		*	This function is important for the calculation of the keys.
		*	It returns a random prime number of one of those files in './data/'
		*
		*/

		public static function get_random_prime()
		{
			$primefiles = glob('./primes/primes*.txt');
			$filename = $primefiles[array_rand($primefiles)];
			$primes = file($filename, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
			return $primes[array_rand($primes)];
		}

		/*
		*
		*	RSA_Handler::euklid()
		*
		*	This function is important for the calculation of the keys.
		*	It returns the GCD for the two numbers $a and $b.
		*	$s and $t are important variables for calculating the private key.
		*
		*/

		public static function euklid($a, $b, &$s = '0', &$t = '0')
		{
			if($a == '0' || $b == '0') return '1';

			$s = '1';
			$t = '0';
			$u = '0';
			$v = '1';

			if(bccomp($a, $b) == -1)
			{
				$m = $b;
				$n = $a;
			}else
			{
				$m = $a;
				$n = $b;
			}

			do
			{
				$q = bcdiv($m, $n, 0);
				$r = $m - bcmul($n, $q);
				$m = $n;
				$n = $r;
				$u_ = bcsub($s, bcmul($q, $u));
				$v_ = bcsub($t, bcmul($q, $v));
				$s = $u;
				$t = $v;
				$u = $u_;
				$v = $v_;
			}while(bccomp($n, '0') != 0);

			return $m;
		}

		/*
		*
		*	RSA_Handler::get_random_key()
		*
		*	This function returns an array for the RSA-encryption.
		*	This array contains the numbers N, D and E.
		*
		*/

		public static function get_random_key()
		{
			$p = RSA_Handler::get_random_prime();
			$q = RSA_Handler::get_random_prime();
			$n = bcmul($p, $q);
			$phi_n = bcmul(bcsub($p, '1'), bcsub($q, '1'));
			$s = '0';
			$t = '0';

			do
				$e = (string)rand(1, 1000000);
			while(bccomp(RSA_Handler::euklid($e, $phi_n, $s, $t), '1') != 0);

			while(bccomp($t, 0) == -1)
				$t = bcadd($t, $phi_n);
			$d = bcmod($t, $phi_n);

			return array('n' => $n, 'd' => $d, 'e' => $e);
		}

		/*
		*
		*	RSA_Handler::encrypt()
		*
		*	This function encrypts the text $m with the public RSA-keys $e and $n;
		*	It returns the encryptet text - commonly known as cipher text.
		*
		*/

		public static function encrypt($m, $e, $n)
		{
			$coded = '';
			$len = strlen($m);
			for($i = 0; $i < $len; $i++)
				$coded .= bcpowmod((string)ord($m[$i]), $e, $n)." ";
			return trim($coded);
		}

		/*
		*
		*	RSA_Handler::decrypt()
		*
		*	This function decryptas the cypher $c with the private RSA-keys $d and $n;
		*	It returns the decrypted text.
		*
		*/

		public static function decrypt($c, $d, $n)
		{
			$c = explode(' ', $c);
			$result = '';
			$len = count($c);
			for($i = 0; $i < $len; $i++)
				$result .= chr(bcpowmod((string)$c[$i], $d, $n));
			return trim($result);
		}
	}

	$key_RSA = RSA_Handler::get_random_key();
	$key_AES = AES_Handler::get_random_key();
	$text = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
	$encrypted_RSA = RSA_Handler::encrypt($text, $key_RSA['e'], $key_RSA['n']);
	$decrypted_RSA = RSA_Handler::decrypt($encrypted_RSA, $key_RSA['d'], $key_RSA['n']);
	$encrypted_AES = AES_Handler::encrypt($text, $key_AES);
	$decrypted_AES = AES_Handler::decrypt($encrypted_AES, $key_AES);

?><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="de">
  <head>
    <title>RSA-Implementation &amp; AES-Encryption for PHP - Dominik Dopplinger</title>
    <meta name="language" content="en,english" />
    <meta http-equiv="content-type" content="text/html; charset=UTF-8" />
  </head>
  <body>
    <h1>RSA-Implementation &amp; AES-Encryption for PHP - Dominik Dopplinger</h1>
      <p>This is an example-script for an implementation of RSA and AES in PHP. RSA is the most important algorithm for public key encryption. AES (Rijndael) is the one for private key encryption.</p>
      <p>Both examples (RSA and AES) encrypt the text <em>'0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz'</em>. Afterwards the encrypted text is decrypted.</p>
      <p>Feel free to use, share, sell, etc. this script. I - Dominik Dopplinger - allow you, to do everything with this script - and there are no limitations. I do that, because I want the programmer in this world to protect their programs against hackers. Commonly used functions - e.g. MD5 - are not good enough for encrypting passwords or other important data. So please use and share this knowledge and this script to make the web a safer place for important data.</p>
      <h2>RSA (Example)</h2>
        <h3>Calculated public key</h3>
	  <ul>
	    <li><strong>N: </strong><?php echo $key_RSA['n']; ?></li>
	    <li><strong>E: </strong><?php echo $key_RSA['e']; ?></li>
	  </ul>
        <h3>Calculated private key</h3>
	  <ul>
	    <li><strong>N: </strong><?php echo $key_RSA['n']; ?></li>
	    <li><strong>D: </strong><?php echo $key_RSA['d']; ?></li>
	  </ul>
	<h3>Encrypted text</h3>
	  <p><?php echo $encrypted_RSA; ?></p>
	<h3>Decrypted text</h3>
	  <p><?php echo $decrypted_RSA; ?></p>
      <h2>AES (Example)</h2>
        <h3>Calculated key</h3>
	  <p><?php echo $key_AES; ?></p>
	<h3>Encrypted text</h3>
	  <p><?php echo $encrypted_AES; ?></p>
	<h3>Decrypted text</h3>
	  <p><?php echo $decrypted_AES; ?></p>
  </body>
</html>