<?php
ini_set('display_errors', 1);
require_once './Dir.php';
require_once './Dir/File.php';
require_once './Dir/DirOutOfScopeException.php';
require_once './Dir/DirNotReadableException.php';
define('DIR_ROOT', '/home/jojo/public_html/Dir');   // root-folder from which to start reading.
                                                    // access to folders above will be forbidden
                                                    // Note: without trailing slash
                                    

function getCtrlFiles(Dir $dir) {
    $ctrls = array();
    $dir = $dir->ls();
    foreach ($dir->getFiles() as $file) {
        if ($file->getExtension() == "ctrl") {
            $ctrls[] = $file;
        }
    }
    $subdirs = $dir->getSubdirs();
    if (!empty($subdirs)) {
        foreach ($subdirs as $subdir) {
            $res = getCtrlFiles($subdir);
            foreach ($res as $file) {
                $ctrls[] = $file;
            }
        }
    }
    return $ctrls;
}

echo '<pre>';
$readDir = 'test';             // Folder to read (without slashes)
$dir = new Dir($readDir);

foreach (getCtrlFiles($dir) as $file) {
    echo $file->getPathname() . "<br />";
}

