function initialise()
{
	document.getElementById("game").removeChild(document.getElementById("game").getElementsByTagName("noscript")[0]);
	fadeoutMessage(0);
}

function fadeoutMessage(num)
{
	num += 16;
	if(num > 255)
		num = 255;

	var hex = "" + ((num < 16)?"0":"") + num.toString(16);
	document.getElementById("game").getElementsByTagName("p")[0].style.color = "#" + hex + hex + hex;
	if(num != 255)
		window.setTimeout("fadeoutMessage(" + num + ");", 40);
	else
	{
		document.getElementById("game").removeChild(document.getElementById("game").getElementsByTagName("p")[0]);

		var table = document.createElement('table');
		table.id = "table";

		var tr = new Array();
		tr[0] = document.createElement('tr');
		tr[1] = document.createElement('tr');
		tr[2] = document.createElement('tr');

		var td = new Array();
		td[0] = document.createElement('td');
		td[1] = document.createElement('td');
		td[2] = document.createElement('td');
		td[3] = document.createElement('td');
		td[4] = document.createElement('td');
		td[5] = document.createElement('td');
		td[6] = document.createElement('td');
		td[7] = document.createElement('td');
		td[8] = document.createElement('td');

		tr[0].appendChild(td[0]);
		tr[0].appendChild(td[1]);
		tr[0].appendChild(td[2]);
		tr[1].appendChild(td[3]);
		tr[1].appendChild(td[4]);
		tr[1].appendChild(td[5]);
		tr[2].appendChild(td[6]);
		tr[2].appendChild(td[7]);
		tr[2].appendChild(td[8]);

		table.appendChild(tr[0]);
		table.appendChild(tr[1]);
		table.appendChild(tr[2]);

		document.getElementById("game").appendChild(table);

		window.setTimeout("fadeinBox(255, 0);", 500);
	}
}

function fadeinBox(num, size)
{
	num -= 6;
	if(num < 0)
		num = 0;
	size += 7;
	if(size > 300)
		size = 300;

	var hex = "" + ((num < 16)?"0":"") + num.toString(16);
	document.getElementById("table").style.border = "2px solid #" + hex + hex + hex;
	document.getElementById("table").style.width = size + "px";
	document.getElementById("table").style.height = size + "px";
	if(num != 0)
		window.setTimeout("fadeinBox(" + num + ", " + size + ");", 20);
	else
		window.setTimeout("fadeinTable(271);", 500);   
}

function fadeinTable(num)
{
	num -= 16;
	if(num < 0)
		num = 0;

	var hex = "" + ((num < 16)?"0":"") + num.toString(16).toUpperCase();

	var td = document.getElementById("table").getElementsByTagName("td");

	td[0].style.borderBottom = "2px solid #" + hex + hex + hex;
	td[0].style.borderRight  = "2px solid #" + hex + hex + hex;
	td[0].style.borderLeft   = "2px solid #000000";
	td[0].style.borderTop    = "2px solid #000000";

	td[1].style.borderBottom = "2px solid #" + hex + hex + hex;
	td[1].style.borderRight  = "2px solid #" + hex + hex + hex;
	td[1].style.borderLeft   = "2px solid #" + hex + hex + hex;
	td[1].style.borderTop    = "2px solid #000000";

	td[2].style.borderBottom = "2px solid #" + hex + hex + hex;
	td[2].style.borderRight  = "2px solid #000000";
	td[2].style.borderLeft   = "2px solid #" + hex + hex + hex;
	td[2].style.borderTop    = "2px solid #000000";

	td[3].style.borderBottom = "2px solid #" + hex + hex + hex;
	td[3].style.borderRight  = "2px solid #" + hex + hex + hex;
	td[3].style.borderLeft   = "2px solid #000000";
	td[3].style.borderTop    = "2px solid #" + hex + hex + hex;

	td[4].style.borderBottom = "2px solid #" + hex + hex + hex;
	td[4].style.borderRight  = "2px solid #" + hex + hex + hex;
	td[4].style.borderLeft   = "2px solid #" + hex + hex + hex;
	td[4].style.borderTop    = "2px solid #" + hex + hex + hex;

	td[5].style.borderBottom = "2px solid #" + hex + hex + hex;
	td[5].style.borderRight  = "2px solid #000000";
	td[5].style.borderLeft   = "2px solid #" + hex + hex + hex;
	td[5].style.borderTop    = "2px solid #" + hex + hex + hex;

	td[6].style.borderBottom = "2px solid #000000";
	td[6].style.borderRight  = "2px solid #" + hex + hex + hex;
	td[6].style.borderLeft   = "2px solid #000000";
	td[6].style.borderTop    = "2px solid #" + hex + hex + hex;

	td[7].style.borderBottom = "2px solid #000000";
	td[7].style.borderRight  = "2px solid #" + hex + hex + hex;
	td[7].style.borderLeft   = "2px solid #" + hex + hex + hex;
	td[7].style.borderTop    = "2px solid #" + hex + hex + hex;

	td[8].style.borderBottom = "2px solid #000000";
	td[8].style.borderRight  = "2px solid #000000";
	td[8].style.borderLeft   = "2px solid #" + hex + hex + hex;
	td[8].style.borderTop    = "2px solid #" + hex + hex + hex;

	if(num != 0)
		window.setTimeout("fadeinTable(" + num + ");", 40);
	else
		setInteraction();
}

function setInteraction()
{
	var td = document.getElementById("table").getElementsByTagName("td");

	td[0].onclick = function() { click(0); };
	td[1].onclick = function() { click(2); };
	td[2].onclick = function() { click(2); };
	td[3].onclick = function() { click(3); };
	td[4].onclick = function() { click(4); };
	td[5].onclick = function() { click(5); };
	td[6].onclick = function() { click(6); };
	td[7].onclick = function() { click(7); };
	td[8].onclick = function() { click(8); };

	td[0].onmouseover = function() { mouseover(0) };
	td[0].onmouseout  = function() { mouseout (0) };
	td[1].onmouseover = function() { mouseover(1) };
	td[1].onmouseout  = function() { mouseout (1) };
	td[2].onmouseover = function() { mouseover(2) };
	td[2].onmouseout  = function() { mouseout (2) };
	td[3].onmouseover = function() { mouseover(3) };
	td[3].onmouseout  = function() { mouseout (3) };
	td[4].onmouseover = function() { mouseover(4) };
	td[4].onmouseout  = function() { mouseout (4) };
	td[5].onmouseover = function() { mouseover(5) };
	td[5].onmouseout  = function() { mouseout (5) };
	td[6].onmouseover = function() { mouseover(6) };
	td[6].onmouseout  = function() { mouseout (6) };
	td[7].onmouseover = function() { mouseover(7) };
	td[7].onmouseout  = function() { mouseout (7) };
	td[8].onmouseover = function() { mouseover(8) };
	td[8].onmouseout  = function() { mouseout (8) };
}

function click(num)
{
	alert(num);
}

function mouseover(num)
{
	document.getElementById("table").getElementsByTagName("td")[num].style.backgroundColor = "#000000";
}

function mouseout(num)
{
	document.getElementById("table").getElementsByTagName("td")[num].style.backgroundColor = "#FFFFFF";
}