<?php
class dbhandler
{
    // DBHandler Version 3.0
    // All rights recieved
    protected $mydb;
    protected $myhost;
    protected $myuser;
    protected $mypw;
    protected $mybase=null;
    private $rlog="";
    public $logfile;
    protected function rlogfile($log) {
        if ($this->logfile) {
            $this->rlog.="\n".$log;
        }
    }
    protected function backtick($sql) {
        $sql=str_replace("`", "", $sql);
        if (strpos($sql, ",")) {
            $sql=explode(",", $sql);
            foreach ($sql as $key=>$val) {
                $val=explode(".", $val);
                foreach ($val as $k=>$value) {
                    $value=trim($value);
                    $val[$k]="`".$value."`";
                }
                $sql[$key]=implode(".", $val);
            }
            $sql=implode(",", $sql);
            return $sql;
        } else {
            $sql="`".$sql."`";
            return $sql;
        }
    }
    function __construct($log=false) {
        $this->logfile=$log;
        $this->rlogfile("New instance of DB-Handler, ".time().".");
    }
    function __deconstruct() {
        @$db->close();
    }
    function logfile($saveto=null) {
        if (gettype($saveto)!="NULL") {
            $fp=fopen($saveto, "w+");
            fwrite($fp, $this->rlog);
            fclose($fp);
        } else {
            return $this->rlog;
        }
    }
    function data($host, $user, $pw, $base=null) {
        if ($base!=null) {
            if (@$this->mydb=new mysqli($host, $user, $pw, $base)) {
                $this->rlogfile("Sucessfully connected to ".$host.".".$base." with user ".$user.".");
                return true;
            } else {
                $this->error=$this->mydb->error;
                $this->rlogfile("Faild to connect to ".$host.".".$base." with user ".$user.". Reason".$this->mydb->error);
                return false;
            }
        } else {
            if (@$this->mydb=new mysqli($host, $user, $pw)) {
                $this->rlogfile("Sucessfully connected to ".$host." with user ".$user.".");
                return true;
            } else {
                $this->error=$this->mydb->error;
                $this->rlogfile("Faild to connect to ".$host." with user ".$user.". Reason".$this->mydb->error);
                return false;
            }
        }
    }
    function connect() {
        @$this->mydb->close();
        if ($this->mybase!=null) {
            if (@$this->mydb=new mysqli($this->myhost, $this->myuser, $this->mypw, $this->mybase)) {
                $this->rlogfile("Sucessfully connected to ".$host.".".$base." with user ".$user.".");
                return true;
            } else {
                $this->error=$this->mydb->error;
                $this->rlogfile("Faild to connect to ".$this->myhost.".".$this->mybase." with user ".$this->myuser.". Reason".$this->mydb->error);
                return false;
            }
        } else {
            if (@$this->mydb=new mysqli($this->myhost, $this->myuser, $this->mypw)) {
                $this->rlogfile("Sucessfully connected to ".$host." with user ".$user.".");
                return true;
            } else {
                $this->error=$this->mydb->error;
                return false;
            }
        }
    }
    function cahnge($base, $auto=false, $host=null, $user=null, $pw=null) {
        @$this->mydb->close();
        $this->mybase=$base;
        if ($host!=null) { $this->myhost=$host; }
        if ($user!=null) { $this->myuser=$user; }
        if ($pw!=null) { $this->mypw=$pw; }
        if ($auto) { $this->connect(); }
    }
    function table($name, $columns, $primary=null) {
        $name=$this->backtick($name);
        $sql="CREATE TALBE ".$table." (";
        foreach ($columns as $cname=>$data) {
            $cname=$this->backtick($name);
            $sql.=$name." ".$data["type"]."( ".$data["length"]." ) NOT NULL ,";
        }
        $sql=substr($sql, 0, strlen($sql)-1);
        if ($primary!=null) {
            $sql.=", PRIMARY KEY (".$this->backtick($primary).")";
        }
        $sql.=")";
        if (@$this->mydb->query($sql)) {
            $this->rlogfile("Sucessfully created new Table ".$name." with ".$columns." columns.");
            return true;
        } else {
            $this->error=$this->mydb->error;
            $this->rlogfile("Faild to create new Table ".$name." with ".$columns." columns. Reason: ".$this->mydb->error);
            return false;
        }
    }
    function query($query, $returns=false, $type=null) {
        if (@$resultat=$this->mydb->query($query)) {
            $this->rlogfile("Calling \"".stripslashes($query)."\" to ".$this->host."...");
            if ($returns) {
                if ($type==0 || $type=="object") {
                    if (@$returner=$resultat->fetch_object()) {
                        $this->rlogfile("--->Returning object");
                        return $returner;
                    } else {
                        $this->error=$this->mydb->error;
                        $this->rlogfile("--->faild to fetch object. Reason: ".$this->mydb->error);
                        return false;
                    }
                } elseif ($type==1 || $type=="array") {
                    if (@$returner=$resultat->fetch_array()) {
                        $this->rlogfile("--->Returning array[".$count($returner)."]");
                        return $returner;
                    } else {
                        $this->error=$this->mydb->error;
                        $this->rlogfile("--->faild to fetch array. Reason: ".$this->mydb->error);
                        return false;
                    }
                } elseif ($type==2 || $type=="all" || $type==null) {
                    $this->rlogfile("--->Returning full getback");
                    return $resultat;
                }
            }
        } else {
            $this->error=$this->mydb->error;
            $this->rlogfile("Faild to send query \"".$query."\" to ".$this->myhost.". Reason: ".$this->mydb->error);
            return false;
        }
    }
    function insert($table, $data) {
        if (gettype($data)=="Array") {
            @$sql="INSERT INTO ".$this->backtick($table)." ".$this->mydb->sql_build_array("INSERT", $data);
        } elseif (gettype($datatype)=="sql") {
            @$sql="INSERT INTO ".$this->backtick($table)." ".$data;
        }
        if (@$this->mydb->query($sql)) {
            $this->rlogfile("Inserting data into ".$table.".");
            return true;
        } else {
            $this->error=$this->mydb->error;
            $this->rlogfile("faild to insert data into ".$table.". Reason: ".$this->mydb->error);
            return false;
        }
    }
    function select($what, $from, $type=1, $where=null, $order=null, $limit=null) {
        $what=$this->backtick($what);
        $from=$this->backtick($from);
        $sql="SELECT ".$what." FROM ".$from;
        if (gettype($where)=="Array") {
            $sql.=" WHERE";
            foreach ($where as $clmn=>$value) {
                     $sql.=$this->backtick($clmn)."='".$value."',";
            }
            $sql=substr($sql, 0, strlen($sql)-4);
        } elseif (gettype($where)=="String") {
            $sql.=" ".$where;
        }
        if ($order!=null) { $sql.=" ORDER BY ".$order; }
        if ($limit!=null) { $sql.=" LIMIT ".$limit; }
        if (@$resultat=$this->mydb->query($sql)) {
            $this->rlogfile("Selecting data from ".$from."...");
            if ($type==0 || $type=="object") {
                if (@$returner=$resultat->fetch_object()) {
                    $this->rlogfile("--->Returning object");
                    return $returner;
                } else {
                    $this->error=$this->mydb->error;
                    $this->rlogfile("--->faild to fetch object. Reason: ".$this->mydb->error);
                    return false;
                }
            } elseif ($type==1 || $type=="array") {
                if (@$returner=$resultat->fetch_array()) {
                    $this->rlogfile("--->Returning array[".$count($returner)."]");
                    return $returner;
                } else {
                    $this->error=$this->mydb->error;
                    $this->rlogfile("--->faild to fetch array. Reason: ".$this->mydb->error);
                    return false;
                }
            } elseif ($type==2 || $type=="all") {
                $this->rlogfile("--->Returning full getback");
                return $resultat;
            }
        } else {
            @$this->error=$this->mydb->error;
            $this->rlogfile("Faild to select data from ".$from.". Reason: ".$this->mydb->error);
            return false;
        }
    }
    function last ($table, $what, $by="ID", $type=1) {
        $table=$this->backtick($table);
        $sql="SELECT ".$this->backtick($what)." FROM ".$table." t1 WHERE t1.".$by." = ( SELECT MAX(t2.".$by.") FROM ".$table." t2 )";
        if (@$resultat=$this->mydb->query($sql)) {
            $this->rlogfile("Selecting last items from ".$table."...");
            if ($type==0 || $type=="object") {
                if (@$returner=$resultat->fetch_object()) {
                    $this->rlogfile("--->Returning object");
                    return $returner;
                } else {
                    $this->rlogfile("--->faild to fetch object. Reason: ".$this->mydb->error);
                    $this->error=$this->mydb->error;
                    return false;
                }
            } elseif ($type==1 || $type=="array") {
                if (@$returner=$resultat->fetch_array()) {
                    $this->rlogfile("--->Returning array[".$count($returner)."]");
                    return $returner;
                } else {
                    $this->error=$this->mydb->error;
                    $this->rlogfile("--->faild to fetch array. Reason: ".$this->mydb->error);
                    return false;
                }
            }
        } else {
            @$this->error=$this->mydb->error;
            $this->rlogfile("Faild to select last item from ".$from.". Reason: ".$this->mydb->error);
            return false;
        }
    }
    function update($table, $set, $where=null, $limit=null) {
        $table=$this->backtick($table);;
        $sql="UPDATE ".$table;
        foreach ($set as $colmn=>$nvalue) {
            $colmn=backtick($colmn);
            $sql.=" SET ".$colmn."='".$nvalue."' AND";
        }
        $sql=substr($sql, 0, strlen($sql)-4);
        if (gettype($where)=="Array") {
            $sql.=" WHERE";
            foreach ($where as $clmn=>$value) {
                     $sql.=$this->backtick($clmn)."='".$value."' AND";
            }
            $sql=substr($sql, 0, strlen($sql)-4);
        } elseif (gettype($where)=="String") {
            $sql.=" ".$where;
        }
        if ($limit!=null) { $sql.=" LIMIT ".$limit; }
        if (@$this->mydb->query($sql)) {
            $this->rlogfile("Sucessfully updated ".$table.".");
            return true;
        } else {
            $this->error=$this->mydb->error;
            $this->rlogfile("Faild to update ".$table.". Reason:".$this->mydb->error);
            return false;
        }
    }
    function alter($table, $add) {
        $sql="ALTER TABLE ".$this->backtick($table)." ".$add;
        if (@$this->mydb->query($sql)) {
            return true;
        } else {
            $this->error=$this->mydb->error;
            return false;
        }
    }
    function delete($table, $field=null) {
        if ($field!=null) {
            $sql="ALTER TABLE ".$this->backtick($table)." DROP ".$this->backtick($field);
        } else {
            $sql="DROP TABLE ".$this->backtick($table);
        }
        if (@$this->mydb->query($sql)) {
            $this->rlogfile("Sucessfully deleted ".$table.".".$field.".");
            return true;
        } else {
            $this->error=$this->mydb->error;
            $this->rlogfile("Faild to delete ".$table.".".$filed.".");
            return false;
        }
    }
    function add($table, $fname, $types) {
        $sql="ALTER TABLE ".$this->backtick($table)." ADD ".$this->backtick($types[0])." ( ".$types[1]." ) NOT NULL";
        if (@$this->mydb->query($sql)) {
            $this->rlogfile("Sucessfully added ".$fname." to ".$table.".");
            return true;
        } else {
            $this->error=$this->mydb->error;
            $this->rlogfile("Faild to add ".$fname." to ".$table."(".$types[0].", ".$types[1]."). Reason:".$this->mydb->error);
            return false;
        }
    }
    function primary($table, $key, $add=true) {
        $tolog;
        if ($add) {
            $sql="ALTER TABLE ".$this->backtick($table)." ADD PRIMARY KEY (".$this->backtick($key).")";
            $tolog=1;
        } elseif (!$add) {
            $sql="ALTER TABLE ".$this->backtick($table)." DROP PRIMARY KEY";
            $tolog=2;
        }
        if (@$this->mydb->query($sql)) {
            if ($tolog==1) {
                $this->rlogfile("Sucessfully added key ".$key." to ".$table.".");
            } else {
                $this->rlogfile("Sucessfully droped key from ".$table.".");
            }
            return true;
        } else {
            $this->error=$this->mydb->error;
            if ($tolog==1) {
                $this->rlogfile("Faild to add ".$key." to ".$table.". Reason:".$this->mydb->error);
            } else {
                $this->rlogfile("Faild to delete key from ".$table.". Reason:".$this->mydb->error);
            }
            return false;
        }
    }
    function truncate($table) {
        $sql="TRUNCATE ".$this->backtick($table);
        if (@$this->mydb->query($sql)) {
            $this->rlogfile ("Sucessfully truncated ".$table.".");
            return true;
        } else {
            $this->error=$this->mydb->error;
            $this->rlogfile ("Faild to truncate ".$table.". Reasion:".$this->mydb->error);
            return false;
        }
    }
    function close() {
        if (@$this->mydb->close()) {
            $this->rlogfile("Connection closed");
            return true;
        } else {
            $this->error=$this->mydb->error;
            $this->rlogfile("Couldnt closeconnection. Reason:".$this->mydb->error);
            return false;
        }
    }
    function backup($table, $saveto) {
        if (file_exists($saveto)) {
            $this->rlogfile("Starting Backup for ".$table."...");
            @$query=file($saveto);
            if (@$query[0]) {
                $this->rlogfile("--->SQL-Query inread");
                if ($this->query("TRUNCATE ".$this->backtick($table))) {
                    $this->rlogfile("--->Truncate done");
                    if ($this->query(base64_decode($query))) {
                        $this->rlogfile("--->Sucessfully written data.");
                        return true;
                    } else {
                        $this->error=$this->mydb->error;
                        $this->rlogfile("--->### Faild to write data, table keeps being cleared. Reason:".$this->mydb->error);
                        return false;
                    }
                } else {
                    $this->error=$this->mydb->error;
                    $this->rlogfile("--->Couldnt truncate table. Reason:".$this->mydb->error);
                    return false;
                }
            } else {
                $this->error="Unable to read resource ".$saveto." (".$_SERVER["PHP_SELF"]."->dbhandler line 358)";
                $this->rlogfile("Unable to read resource ".$saveto." (".$_SERVER["PHP_SELF"]."->dbhandler line 358)");
                return false;
            }
        } else {
            $this->rlogfile("Creating Backup for ".$table."...");
            if ($res=$this->select("*", $table, 1)) {
                $this->rlogfile("--->Read on field");
                if ($clmns=mysql_num_fields($res)) {
                    $this->rlogfile("--->Counted fields in table");
                    $columns=array();
                    for ($i=0;$i=$clmns;$i++) {
                        $columns[$i]=mysql_field_name($res, $i);
                    }
                    $save_sql="INSERT INTO ".$this->backtick($table)." (";
                    foreach ($columns as $column_name) {
                        $save_sql.=$column_name.", ";
                    }
                    $save_sql=substr($save_sql, 0, strlen($save_sql)-1).") VALUES ";
                    $res=$this->select("*",$this->backtick($table),2);
                    if ($cur_sql=$res->fetch_array()) {
                        $this->rlogfile("--->Creating SQL-Syntax");
                        $save_sql="(";
                        foreach ($cur_sql as $value) {
                            $save_sql.="'".$value."',";
                        }
                        $save_sql=substr($save_sql, 0, (strlen($save_sql)-1)).")";
                        while ($cur_sql=$res->fetch_array()) {
                            $save_sql=", (";
                            foreach ($cur_sql as $value) {
                                $save_sql.="'".$value."',";
                            }
                            $save_sql=substr($save_sql, 0, strlen($save_sql)-1).")";
                        }
                    } else {
                        $this->error=$this->mydb->error;
                        $this->rlogfile("Could not buld SQL-Syntax. Reason:".$this->mydb->error);
                        return false;
                    }
                    if (@$fp=fopen($saveto, "w+")) {
                        $this->rlogfile("--->Opening file \"".$saveto."\" to write SQL");
                        if (@fwrite($fp, base64_encode($save_sql))) {
                            $this->rlogfile("--->Sucessfully wrote SQL into file.");
                            $this->rlogfile("### Backup finished and saved");
                            return true;
                        } else {
                            $this->error="Couldnt save SQL to ".$saveto." (".$_SERVER["PHP_SELF"]."->dbhandler line 417)";
                            $this->rlogfile("Couldnt save Query to ".$saveto." (".$_SERVER["PHP_SELF"]."->dbhandler line 417)");
                            return false;
                        }
                        @fclose($fp);
                    } else {
                        $this->error="Couldnt create new file ".$saveto." (".$_SERVER["PHP_SELF"]."->dbhandler line 415)";
                        $this->rlogfile("Couldnt create new file ".$saveto." (".$_SERVER["PHP_SELF"]."->dbhandler line 415)");
                        return false;
                    }
                } else {
                    $this->error="Couldnt read names of columns for table ".$table." (".$_SERVER["PHP_SELF"]."->dbhandler line 395)";
                    $this->rlogfile("Couldnt read names of columns for table ".$table." (".$_SERVER["PHP_SELF"]."->dbhandler line 395)");
                }
            } else {
                $this->error=$this->mydb->error;
            }
        }
    }
}
?>
