<?php
/***************************************************************************
 *   awForumPanel                                                          *
 *                                                                         *
 *   Copyright (C) 2006 Artur Wiebe                                        *
 *   wibix@gmx.de                                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
require_once("../../maincore.php");
require_once(BASEDIR."subheader.php");
require_once(BASEDIR."side_left.php");

require_once("common.php");

define("AWF_DEBUG", false);
$per_page = 20;

if(!isset($_POST['stext']) || !isset($_POST['swhere'])
	|| !isset($_POST['stype'])) {
	fallback("search.php");
}
/*
if(strlen($_POST['stext']) < 3) {
	fallback("search.php");
}
*/


if(isset($_POST['rowstart']) && isNum($_POST['rowstart'])) {
	$rowstart = $_POST['rowstart'];
} else {
	$rowstart = 0;
}
if(isset($_POST['next'])) {
	$rowstart += $per_page;
} elseif(isset($_POST['prev'])) {
	$rowstart -= $per_page;
	if($rowstart < 0) {
		$rowstart = 0;
	}
}


$linkage = "0";

function create_stext($field)
{
	global $linkage;

	$stext = trim(stripinput($_POST['stext']));

	$linkage = stripinput($_POST['linkage']);

	if($linkage=="0") {
		$stext = "$field LIKE '%$stext%'";
	} else {
		$splitted = preg_split("/\s+/", $stext);
		foreach($splitted as $id => $data) {
			$splitted[$id] = "$field LIKE '%$data%'";
		}

		if($linkage=="AND") {
			$linkage = " AND ";
		} else {
			$linkage = " OR ";
		}

		$stext = "(".implode($linkage, $splitted).")";
		echo "<pre>\n";
		echo "</pre>\n";
	}

	$linkage = trim($linkage);

	if(iSUPERADMIN && AWF_DEBUG) {
		echo "<p>STEXT: <code>$stext</code>";
		echo "<p>linkage: ".$linkage;
	}
	return $stext;
}


function create_users(&$users, $field, $field2="")
{
	$all = array();
	foreach($users as $id) {
		$all[] = "$field='$id'";
	}
	if(!empty($field2)) {
		foreach($users as $id) {
			$all[] = "$field2='$id'";
		}
	}
	return "(".implode(" OR ", $all).")";//FIXME ??? ()
}




//
$where_forums = array();
$swhere = array();
foreach($_POST['swhere'] as $forum) {
	if($forum=="0") {
		$swhere[] = 0;
		break;
	}

	$forum += 0;
	$where_forums[] = "f.forum_id='$forum'";

	$swhere[] = $forum;
}
if(count($where_forums)) {
	$where_query = " AND (".implode(" OR ", $where_forums).")";
} else {
	$where_query = "";
}
if(iSUPERADMIN && AWF_DEBUG) {
	echo "<p>WQ: $where_query";
}


// only from this user
$where_from_user = "";
$suser = trim(stripinput($_POST['suser']));
$users = array();
if(!empty($suser)) {
	$query_id = dbquery("SELECT user_id"
		." FROM ".DB_PREFIX."users"
		." WHERE user_name LIKE '%$suser%'");
	if(dbrows($query_id)) {
		while($data = dbarray($query_id)) {
			$users[] = $data['user_id'];
		}
	} else {
		$users[] = 0;//FIXME
	}
}


// days
$where_days = "";
if(isset($_POST['days']) && isNum($_POST['days']) && $_POST['days']!=0) {
	$days = time() - ($_POST['days'] * 60*60*24);	// in secs
	$sdays = $_POST['days'];
} else {
	$sdays = 0;
	unset($days);
}

//
switch($_POST['stype']) {
case "title":
	$stype = "title";

	if(count($users)) {
		$where_from_user .= "AND "
			.create_users($users, "t.thread_author");
//		$where_from_user = "AND t.thread_author='$userid'";
	}
	if(isset($days)) {
		$where_days = "AND t.thread_lastpost >= '$days'";
	}
	$where_stext = create_stext("t.thread_subject");
	break;

case "body":
	$stype = "body";

	if(count($users)) {
		$where_from_user .= "AND "
			.create_users($users, "p.post_author");
	}
	if(isset($days)) {
		$where_days = "AND p.post_datestamp >= '$days'";
	}
	$where_stext = create_stext("p.post_message");
	break;
default:
	$stype = "both";

	if(count($users)) {
		$where_from_user .= "AND "
			.create_users($users, "p.post_author",
				"t.thread_author");
	}
	if(isset($days)) {
		$where_days = "AND (t.thread_lastpost >= '$days'
			OR p.post_datestamp >= '$days')";
	}
	$where_stext = "(".create_stext("t.thread_subject")
		." OR ".create_stext("p.post_message").")";
	break;
}

/*
 * GUI
 */
opentable($locale['AWF150']);
echo $awf_menu;

if(iSUPERADMIN && AWF_DEBUG) {
	echo "<p>LIKE: <code>$where_stext</code>";
}


// sort dir
if(isset($_POST['ssort_dir']) && isset($locale['AWF120'][$_POST['ssort_dir']])){
	$ssort_dir = $_POST['ssort_dir'];
} else {
	$ssort_dir = "DESC";
}


/*
 * FINAL MYSQL STRING
 */
$query = "SELECT t.thread_subject, t.thread_id, t.forum_id, t.thread_lastpost,"
	." f.forum_name, fu.user_name, t.thread_lastuser, thread_locked,"
	." COUNT(p.post_id) as count_posts, thread_views,fg.group_id,fg.auth_read"
	." FROM ".DB_PREFIX."forums AS f"
	." LEFT OUTER JOIN ".DB_PREFIX."threads AS t USING(forum_id)\n"
	." LEFT OUTER JOIN ".DB_PREFIX."users fu ON t.thread_lastuser=fu.user_id\n"
	." LEFT OUTER JOIN ".DB_PREFIX."posts AS p ON p.thread_id=t.thread_id"
	." LEFT OUTER JOIN ".DB_PREFIX."extboard_groups AS fg ON fg.forum_id=f.forum_id AND fg.auth_read='1'"
	." WHERE (".forum_groupaccess('f.forum_access')." OR ".forum_groupaccess('fg.group_id').") AND f.forum_cat!='0'"
	." $where_from_user\n"
	." $where_days\n"
	." $where_query AND $where_stext\n"
	." GROUP BY t.thread_id"
	." ORDER BY t.thread_lastpost $ssort_dir";

// count all matches
$rows = dbrows(dbquery($query));

if(iSUPERADMIN && AWF_DEBUG) {
	echo "<p>Q:<pre style='overflow:auto;'>"
		.phpentities($query)."</pre>\n"
		."<p>";
}

$query_id = dbquery($query." LIMIT $rowstart, $per_page");

if(iSUPERADMIN && AWF_DEBUG) {
	echo "<hr>\n";
}


/*
 * CREATE HIDDEN SEARCH FORM
 */
$search_hiddens = "
<input type='hidden' name='stext' value='$stext'>
<input type='hidden' name='linkage' value='$linkage'>
<input type='hidden' name='stype' value='$stype'>
<input type='hidden' name='suser' value='$suser'>
<input type='hidden' name='sdays' value='$sdays'>
<input type='hidden' name='ssort_dir' value='$ssort_dir'>
";
foreach($swhere as $fid) {
	$search_hiddens .= "<input type='hidden' name='swhere[]'"
		." value='$fid'>\n";
}
echo "<form method='post' action='search.php'>
$search_hiddens
<input type='submit' class='button' value='".$locale['AWF153']."'>
</form>
\n";


/*
 * QUIERY OUTPUT
 */
echo "<p>$rows ".$locale['AWF152']."<br>";
if(dbrows($query_id)) {
	echo "<table cellspacing='1' width='100%' class='tbl-border'>
<thead>
<tr>
	<th class='tbl2' width='1%' align='left'></td>
	<th class='tbl2' align='left'>".$locale['AWF005']."</td>
	<th class='tbl2' width='1%'>".$locale['AWF157']."</td>
	<th class='tbl2' width='1%'>".$locale['AWF151']."</td>
	<th width='1%' class='tbl2' style='white-space:nowrap'>"
		.$locale['AWF007']."</td>
</tr>
</thead>
<tbody>\n";
echo "<!-- END TABLE HEADER //-->";
$count = 1;
while($data = dbarray($query_id)) {
	$tbl = "tbl".(1 + ++$count%2);
	$img = THEME."forum/";
	$viewed = viewed_thread($data['thread_id'],$data['thread_lastpost'],$data['forum_id']);
	if($data['thread_locked']) {
		$img .= "folderlock.gif";
	} else if(iMEMBER && $viewed && $data['thread_lastuser']!=$userdata['user_id']) {
		$img .= "foldernew.gif";
	} else {
		$img .= "folder.gif";
	}
echo "<!-- START TABLE CONTENT //-->";
	echo "<tr>
	<td class='tbl2'><img src='$img' alt=''></td>
	<td class='$tbl'><a href='".FORUM."viewthread.php?thread_id=".$data['thread_id']."' title='".$data['thread_subject']."'>".trimlink($data['thread_subject'], 30)."</a><br>".$data['forum_name']."</td>
	<td align='center' class='$tbl'>".$data['thread_views']."</td>
	<td align='center' class='$tbl'>".$data['count_posts']."</td>
	<td align='center' class='$tbl' style='white-space:nowrap'><a href='".BASEDIR."profile.php?lookup=".$data['thread_lastuser']."'>".$data['user_name']."</a><br>".showdate("forumdate", $data['thread_lastpost'])."</td>
</tr>\n";
echo "<!-- ENDE TABLE CONTENT //-->";
	$tbl = ($tbl=="tbl2" ? "tbl1" : "tbl2");
}@mysql_free_result($query_id);@clearstatcache();

echo "</tbody>
</table>\n";
echo "<!-- ENDE TABLE //-->";
}


if($rows > $per_page) {
	echo "<form method='post' action='search_results.php'>
<input type='hidden' name='rowstart' value='$rowstart'>
$search_hiddens
<div style='text-align:right;'>
<b>".$locale['AWF156'].":</b>\n";
	if($rowstart) {
		echo "<input type='submit' class='button' name='prev'"
			." value='".$locale['AWF154']."'>\n";
	}
	if($rows > $per_page) {
		$cur_page = intval($rowstart/$per_page+1);
		$all_pages = intval($rows/$per_page+1);
		echo " $cur_page/$all_pages ";
	}
	if(($rowstart+$per_page)<$rows) {
		echo "<input type='submit' class='button' name='next'"
			." value='".$locale['AWF155']."'>\n";
	}
	echo "</div>
</form>\n";
}

closetable();

require_once(BASEDIR."side_right.php");
require_once(BASEDIR."footer.php");

// File is correctly working (tested by silvermoon) \\
?>
