<?php
/**
 Main UBB Parser file

 This file holds the eamBBParser class, the main class of the eamBBParser project.
 Main UBB Parser Class, the core of the eamBBParser package.

 @author Erik Bakker <erik@eamelink.nl>
 @copyright 2005, Erik Bakker <erik@eamelink.nl>
 @license http://www.gnu.org/copyleft/lesser.html
 ---------------------------------------------------
This File is modify for BS-Fusion - Keep it Simple
http://www.bs-fusion.de ;
---------------------------------------------------
**/

class ubbParser
{
    /**
    * Storage for BB code
    * @access private
    */
    var $UBB;
    
    /**
    * Storage for outgoing HTML
    * @access private
    */
    var $HTML;
    
    
    /**
    * Array holding tags & text
    *  
    * An array, like this -> 
    * Array ( 
    *        [0] => Hello, this is 
    *        [1] => [b] 
    *        [2] => bold 
    *        [3] => [/b] 
    *        [4] => , cool huh?! 
    *          )
    * @access private
    */
    var $parseArray; 
    
    /**
    * Aliasses, like * for lishort
    *
    * @todo Check if this works as it should
    * @access private
    */
    var $aliassen;
    
    /**
    * The current quote level, to make sure nested quotes are replaced by ...
    *
    * @access private
    */
    var $quote_level;
    
    /**
    * How deep are we; e.g. How many open tags?
    *
    * @access private
    */
    var $level;
    
    /**
    * Amount of tags already parsed
    *
    * @access private
    */    
    var $tags_counted;
    
    /**
    * Maximum allowed number of tags
    *
    * When having trouble with users trying to get down the server by using tons of tags, lower this limit. Open nd closing tags will count towards max.
    * @var int Maximum number of tags to be parsed.
    * 
    */
    var $max_tags;

    /**
    * Allow HTML in code
    * 
    * Whether or not to allow HTMl code. Default is false. When set to false, [html] tag won't do anything.
    * @var boolean
    */
    var $allow_html;   
    
    /**
    * Accept html by default
    * 
    * When set to true, html will be accepted. When set to false, only html within [html] tags will be accepted. This setting only has effect when $allow_html is set to true.
    * @var boolean
    */
    var $standard_html;
     
    // We want to enclose all nice in paragraphs
    /**
    * Enable paragraph mode
    * 
    * When set to true, the parser will try to use &lt;p&gt; tags around text, and remove unnecessary br's. <strong>This is an experimental feature! Please let me know if you find strange behaviour!</strong>
    * @var boolean
    */
    var $paragraph_mode;
    
    /**
    * Keep track of open paragraphs
    * @access private
    */
    var $paragraph_open;
    
    /**
    * Tags that do not need to be encapsulated in paragraphs
    * @access private
    */
    var $paragraphless_tags;
    
    /**
    * Keep track of current paragraph-required-status
    * 
    * When we're in a tag that does not need to be encapsulate in a paragraph, this var will be false, otherwise true. Works only when in paragraph mode.
    * @access private
    */
    var $paragraph_required;

    // It's possible with the ubboff tag to switch processing off.
    /**
    * Keep track of ubb status
    *
    * When we're in a [ubboff] block, this will be false. Otherwise true.
    * @access private
    */
    var $ubb_mode;   
    var $plugindir;
    var $ubbcode_allowed = array('b','u','i','color','size','img','url','mail','center','small','iurl','code','quote');
    
    var $ubbcode_noquote = array('img','code','quote','geshi','googlevideo','youtube','clipfish','myvideo','flash');
    
    var $ubb_auto_url = 'on';
    
    /**
    * returns Version of eamBB
    * @return string
    */      
    function getVersion()
    {
        return "0.9.5";   
    }
    /**
    * eamBBParser constructor
    */
    
    function locale($locvar) {
	global $locale;
	$local[$locvar] = isset($locale[$locvar]) ? $locale[$locvar] : "n/a";
	return $local[$locvar];
	}
	
	function fsettings($setvar) {
	global $extboard_settings;
	$set=isset($extboard_settings[$setvar]) ? $extboard_settings[$setvar] : true;
	return $set;
	}
	
	function ubbParser($plugindir = 'plugins/')
    {
        $this->parser();
        
        $this->plugindir = $plugindir;
    }
	
    function parser()
    {
        // Initialize the parseArray0
        $this->parseArray = array();
        // Define aliasses
        $this->aliassen = array(
            '*' => 'lishort',
            'ulist' => 'list'
        );
        // Define preParsePatterns
        $this->preParsePattern = array(
            '!(^|[ \n\r\t])(((ftp://)|(http://)|(https://))(([a-z0-9_-]+)(:([a-z0-9_\-]+([a-z0-9_\-]+\@)?))?\@)?(www\.)?([a-z0-9_-]|\.)+(\.[a-z]{2,4})(\:[0-9]+)?(/[^/: \n\r]*)*)!i',
            '!(^|[ \n\r\t])([a-z_-][a-z0-9\._-]*@[a-z0-9_-]+(\.[a-z0-9_-]+)+)!i'
        );
        // Define preParseReplacements
        if ($this->ubb_auto_url=='on') {
        $this->preParseReplacement = array(
            '\1[url]\2[/url]',
            '\1[mail]\2[/mail]'
        );
        } else {
		$this->preParseReplacement = array(
            '\1\2',
            '\1\2'
        );	
		}
        // set level (level = # of opened tags)
        $this->level = 0;
        // set quote_level
        $this->quote_level = 0;
        
        // Set max tags
        $this->tags_counted = 0;
        $this->max_tags = 300;
        
        // We don't want standard html 
        $this->allow_html = false;
        $this->standard_html = false;
      
        // We do want nice paragraphs
        $this->paragraph_mode = true;
        $this->paragraph_open = false;
        $this->paragraphless_tags = array('quote');
        $this->paragraph_required = true;
        
        // Whether or not to parse ubb code
        $this->ubb_mode = true;
    }
    /**
    * Transform BB code to HTML code.
    *
    * This method takes a text with BB code and transforms it to HTML.
    * @param string $ubb BB code to be transformed
    * @return string HTML
    * @example examples.php
    */    
    function getHTML($ubb)
    {
        if(strlen($ubb) == 0){ return null; }
        
        $this->UBB = str_replace(array("\r\n", "\n"), "\n", $ubb);    
        
        // preparsing, auto linkification, html on/off and stuff                
        $this->preParse();
       
        // Create the parsearray with the buildarray function, pretty nice ;)
        $this->tags_counted = 0;
        $this->parseArray = $this->buildArray($this->UBB);
             
        // Get output
        $this->HTML = str_replace('[br]',"", $this->parseArray());
        
        
        return $this->HTML;
    }
    /**
    * Preparses content, for auto-linkification
    *
    * @access private
    */
    function preParse()
    {
           
        // Do autolinkification                                                                                                                                   
        $this->UBB = preg_replace($this->preParsePattern, $this->preParseReplacement, $this->UBB);                                                                              
        
    }
    
    /**
    * Breaks the inputted BB code into an array of text and tags
    *
    * @access private
    */
    function buildArray($string)
    {
        
        if(strlen($string) == 0) // Empty or no string
            return false;
        
        foreach($this->ubbcode_noquote as $ub) {
		$s = array("&quot;[".$ub,"&#39;[".$ub,"'[".$ub,"\"[".$ub);   
        $r = array("&quot;&#91;".$ub,"&#39;&#91;".$ub,"&#39;&#91;".$ub,"&quot;&#91;".$ub);    
		$string = str_replace($s,$r,$string);   
        }
		$se_array = array("&#92;[","&#92]","['","']","[ "," ]","[&quot;","&quot;]","[&#39;","&#39;]","]]","[[",")]","(&quot;[","]&quot;,","]&quot;)","]&quot;]","]&quot;}","(&#39;[","]&#39;,","]&#39;)","]&#39;]","]&#39;}","!]","]","%]","&]","(]","=]","?]","`]","]","]","^]","]","*]","#]","~]","-]","_]",":]",";]",",]",".]","]","{]","}]","]","]","@]","|]","<]",">]","]","]","]","]","]","]","[0","[1","[2","[3","[4","[5","[6","[7","[8","[9","[!","[","[$","[%","[&","[(","[)","[=","[}","[{","[","[`","[?","[+","[*","[~","[-","[_","[:","[;","[,","[.","[#","[","[","[","[","[@","[^","[","[|","[<","[>","[\"","\\]","[\\","\"]","[]");
        $re_array = array("&#92;&#91;","&#92;&#93;","&#91;&#39;","&#39;&#93;","&#91;&nbsp;","&nbsp;&#93;","&#91;&quot;","&quot;&#93;","&#91;&#39;","&#39;&#93;","&#91;&#91;","&#93;&#93;",")&#93;","(&quot;&#91;","&#93;&quot;,","&#93;&quot;)","&#93;&quot;&#93;","&#93;&quot;}","(&#39;&#91;","&#93;&#39;,","&#93;&#39;)","&#93;&#39;&#93;","&#93;&#39;}","!&#93;","&#93;","%&#93;","&&#93;","(&#93;","=&#93;","?&#93;","`&#93;","&#93;","&#93;","^&#93;","&#93;","*&#93;","#&#93;","~&#93;","-&#93;","_&#93;",":&#93;",";&#93;",",&#93;",".&#93;","&#93;","{&#93;","}&#93;","&#93;","&#93;","@&#93;","|&#93;","&lt;&#93;","&gt;&#93;","&uuml;&#93;","&Uuml;&#93;","&ouml;&#93;","&Ouml;&#93;","&auml;&#93;","&Auml;&#93;","&#91;0","&#91;1","&#91;2","&#91;3","&#91;4","&#91;5","&#91;6","&#91;7","&#91;8","&#91;9","&#91;!","&#91;","&#91;$","&#91;%","&#91;&","&#91;(","&#91;)","&#91;=","&#91;}","&#91;{","&#91;","&#91;`","&#91;?","&#91;+","&#91;*","&#91;~","&#91;-","&#91;_","&#91;:","&#91;;","&#91;,","&#91;.","&#91;#","&#91;","&#91;","&#91;","&#91;","&#91;@","&#91;^","&#91;","&#91;|","&#91;<","&#91;>","&#91;\"","\\&#93;","&#91;\\","\"&#93;","&#91;&#93;");
        
        $string = str_replace($se_array,$re_array,$string);
		$opensign = strpos($string, '[');
        $nextopensign = strpos($string, '[', $opensign+1);
        $closesign = strpos($string, ']',$opensign);
        // if there are no more opensigns, or closesigns, or if the closesign is on position 0        
        if($opensign === false || $closesign == false)
            return Array($string);
        
        // Check max tags limit
        if($this->tags_counted >= $this->max_tags){
            return Array('<b style="color:red">[max # of tags reached, quitting splitting procedure]</strong>' . $string);
        }
        
        // Nothing's been found yet ;)                    
        $found = false;
        
        while(!$found){
            
            if($closesign > $opensign && $closesign < $nextopensign){ // Parfait
                $found = true;

            } elseif($closesign > $opensign) { // Maar er komt er nog een opensign
                $opensign = $nextopensign;           
            } else { // Close is na open!
                
                while($closesign < $opensign){
                    $closesign = strpos($string, ']', $closesign + 1);
                }
            }
      
            $nextopensign = strpos($string, '[', $opensign + 1);
            if($nextopensign === false){ // No more opensigns, stop looping
                $found = true;
            }
                
        }
        
        $tag = substr($string, $opensign, $closesign - $opensign + 1);
        $pretext = substr($string, 0, $opensign);    
      
        $current = Array($tag);
        
        // Only non [br] tags must count toward max tag limit.
        if($tag != '[br]'){               
            $this->tags_counted++;
        }
        
        
        
        if(!empty($pretext))
            array_unshift($current, $pretext);
        
        $rec_arr = $this->buildArray(substr($string, $closesign + 1));
        if(!is_array($rec_arr)) { $rec_arr = Array($rec_arr); }
        return array_merge($current, $rec_arr);
    }
    /**
    * Process array
    *
    * Walks through the array until one of the stoppers is found. When encountering an 'open' tag, which is not in $forbidden, open corresponding ubb_ function.
    * @access private
    */
    function parseArray($stoppers = array(), $forbidden = array())
    {

        if(!is_array($this->parseArray)){ // Well, nothing to parse
            return null;
        }
        $text = '';
        $forbidden_aantal_open = 0;
         while($entry = array_shift($this->parseArray)){
            if(in_array($entry, $stoppers) || in_array(strtolower($entry),$stoppers)){
                if($forbidden_aantal_open == 0){
                    $this->level--;
                    return $text;
                } else {
                    $forbidden_aantal_open--;
                    return $text;
                    
                }
            } 
			else {

                $tag = $this->getTag(strtolower($entry));
                
                if($tag && in_array($tag, $forbidden)){
                    if($tag != 'br'){
                        $forbidden_aantal_open++;
                    } else {
                        $entry = "\n";
                    }
                }
                
                
                if($this->ubb_mode && substr($entry, 0, 1) == '[' && substr(strtolower($entry), strlen($entry) - 1, 1) == ']' && substr($entry, 1, 1) != '/' && (method_exists($this, 'ubb_'.$tag) || (isset($this->aliassen[$tag]) && method_exists($this, 'ubb_'.$this->aliassen[$tag]))) && !in_array($tag, $forbidden) && !isset($forbidden['all']) && in_array($tag,$this->ubbcode_allowed)) {
                    $functionname = 'ubb_'.$tag;
                    if(!method_exists($this, $functionname))
                        $functionname = 'ubb_'.$this->aliassen[$tag];
                    

                    $arguments = $this->getArguments(strtolower($entry));
                    
                    if($this->paragraph_mode){
                        // Add paragraphs if necessary
                        
                        $paragraph_setting_modified = false;
                        if(!$this->paragraph_open && !in_array($tag, $this->paragraphless_tags) && $this->level == 0){  // Only encaps when level = 0, we don't want paragraphs inside lists or stuff
                            $this->paragraph_open = true;
                        } elseif(in_array($tag, $this->paragraphless_tags)){
                            // We're in some tag that doesn't need to be <p> enclosed, like a heading or a table.
                            if($this->paragraph_required){
                                $paragraph_setting_modified = true;
                                $this->paragraph_required = false; 
                            }
                            if($this->paragraph_open && $this->level == 0){
                                
                                $text .= "\n\n";
                                $this->paragraph_open = false;
                            }
                        }
                    }
                    
                    $this->level++;
                    $newtext = $this->$functionname($arguments);
                    
                    // Reset paragraph_required.
                    if($this->paragraph_mode && $paragraph_setting_modified)
                        $this->paragraph_required = true;
                        
                    $text .= $newtext;
                    
                    
                } else {

                    if($this->paragraph_mode && $entry == '[br]'){

                        $shift = array_shift($this->parseArray);
                        if($shift == '[br]'){
                           
                            $secondshift = array_shift($this->parseArray);                                
                            while($secondshift == '[br]'){
                                $secondshift = array_shift($this->parseArray);    
                                $text .= "<br 2/>\n";
                            }
                            array_unshift($this->parseArray, $secondshift);                        
                            
                            $shift = array_shift($this->parseArray);
                            
                            if($this->paragraph_required && !in_array($this->getTag($shift), $this->paragraphless_tags)){
                                if($this->paragraph_open){
                                    if($this->level == 0){
                                        // Close old one, and open new one
                                        $entry = "\n\n";
                                        $this->paragraph_open = true;
                                    }
                                } else {
                                    if($this->level == 0){
                                        $entry = "";
                                        $this->paragraph_open = true;
                                    }
                                    
                                }

                            } else {
                                $entry = null;
                            }

                        // We have found 1 [br], so normally we'd put it back
                        // But if next thing is a paragraphless tag (say, table) or end of document,
                        // We can skip the [br], since there will be a </p> anyway.
                        } elseif (in_array($this->getTag(strtolower($shift)), $this->paragraphless_tags)){ 

                             $entry = null;
                        } else {

                            
                        }
                        array_unshift($this->parseArray, strtolower($shift));    
                    }
                        
                    
                    // Add paragraphs if necessary
                    if($this->paragraph_mode && !$this->paragraph_open && $this->paragraph_required && $this->level == 0){
                        $text .= '<p>';
                        $this->paragraph_open = true;
                    }
                   
                    $text .= $entry;
                    
                }
            }
        } // End of BIG while!
        

        if($this->paragraph_open){ // No need for a level check, should be zero anyway.
            $this->paragraph_open = false;
          }
        
        return $text;
        
    }
    /**
    * return name of a tag
    *
    * When supplied with a full tag ([b] or [img w=5 h=10]), return tag name
    * @return string
    * @param string $fullTag The full tag to get the tagname from
    * @access private
    */
    function getTag($fullTag)
    {
        if(substr($fullTag, 0, 1) == '[' && substr($fullTag, strlen($fullTag) - 1, 1) == ']'){
            return strtok($fullTag, '[ =]');
        } else {
            return false;
        }
    }
    /**
    * return arguments of a tag in array-form
    *
    * When supplied with a full tag ([h=5] or [img=blah.gif w=5 h=10]), return array with argument/value as key/value pairs
    * @return array
    * @param string $fullTag The full tag to get the arguments from
    * @access private
    */
    function getArguments($fullTag)
    {
        
        $argument_array = Array();
        $tag = substr($fullTag, 1, strlen($fullTag) - 2);
        $argList = explode(' ',$tag);
        $i = 0;
        foreach($argList as $entry){
            $split = explode('=',$entry);
            if(count($split) >= 2){
                $key = array_shift($split);
                $value = implode('=', $split);
            } else {
                if($i != 0){ // Do not key = val if key = tagname. Dan gewoon geen args.
                    $key = $entry;
                    $value = $entry;
                }
            }
            if(isset($value)){
                if(strstr(strtolower($value), 'javascript:')){
                    $value = 'disabled';
                }
                if(strstr(strtolower($value), '(')){
                    $value = 'disabled';
                }
                
                $argument_array[$key] = $value;
            }
            
        }
        return $argument_array; 
    }
               
     
    function ubb_b(){
        return '<strong>' . $this->parseArray(array('[/b]'), array('b')) . '</strong>';
    }
 
    function ubb_small(){
        return '<small>' . $this->parseArray(array('[/small]'), array('small')) . '</small>';
    }
    function ubb_sub(){
        return '<sub>'. $this->parseArray(array('[/sub]'), array('sub', 'sup')) . '</sub>';
    }
    function ubb_sup(){
        return '<sup>' . $this->parseArray(array('[/sup]'), array('sub', 'sup')) . '</sup>';
    }
    function ubb_i(){
        return '<em>' . $this->parseArray(array('[/i]'), array('i')) . '</em>';
    }
    function ubb_s(){
        return '<s>' . $this->parseArray(array('[/s]'), array('s')) . '</s>';         
    }
    function ubb_u(){
        return '<u>'. $this->parseArray(array('[/u]'), array('u')). '</u>';
    }
    function ubb_center(){
        return '<center>'. $this->parseArray(array('[/center]'), array('center')). '</center>';
    }
    function ubb_url($arguments = array()){
        $content = $this->parseArray(array('[/url]'), array());        
        if(isset($arguments['url'])){
        	   $href = trim($arguments['url']);                   
        } else {
            $href = trim($content);
        }
        // Now, filter the javascript
        if(strtolower(substr(trim($href),0,10)) == 'javascript'){
            $href = '';
        }
        
        $href= str_replace(array("&lt;","&gt;"),array("<",">"),$href);
        $href = strip_tags(rawurldecode($href))==$href ? $href : "";
        if (strip_tags($content)==$content)
    	$content = strlen($content) > 40 ? substr($content,0,35)."...".substr($content,-8) : $content;
        if ($href!='') {
        $text = '<a target="new" href="'.$href.'">'.$content.'</a>';
        }
        else {$text = $content;}
        return $text;  
    }
    
    function ubb_iurl($arguments = array()){
        $content = $this->parseArray(array('[/iurl]'), array());        
        if(isset($arguments['url'])){
        	   $href = trim($arguments['iurl']);                   
        } else {
            $href = trim($content);
        }
        // Now, filter the javascript
        if(strtolower(substr(trim($href),0,10)) == 'javascript'){
            $href = '';
        }
        
        $href= str_replace(array("&lt;","&gt;"),array("<",">"),$href);
        $href = strip_tags(rawurldecode($href))==$href ? $href : "";
    	if (strip_tags($content)==$content)
    	$content = strlen($content) > 40 ? substr($content,0,35)."...".substr($content,-8) : $content;
        if ($href!='') {
        $text = '<a target="_self" href="'.$href.'">'.$content.'</a>';
        }
        else {$text = '';}
        return $text;  
    }
    
    // QUOTE UBB
    function ubb_quote($args = array()){
    	global $locale;
        if($this->quote_level == 0){        
            $this->quote_level = 1;
            $content = $this->parseArray(array('[/quote]'));
            $this->quote_level = 0;
        } else {
            $this->quote_level++;
            $delcontent = $this->parseArray(array('[/quote]'));
            $this->quote_level--;
            $content = "";
        }
       	if ($content!="") {
       	$e = count(explode("\n",$content));	
		if ($e<=30) {$height="auto;";} else {$height="400px;";}	
        if(isset($args['quote'])){
            $text = '<table class="tbl-border" cellpadding="0" cellspacing="1"><tr><td class="tbl2"><strong>Quote-'.$args['quote'].'</strong></td></tr><tr><td class="tbl1"><div style="width:450px;max-width:450px;height:'.$height.'max-height:400px;overflow:auto;" />'.$content.'</div></td></tr></table>';
        } else {
            $text = '<table class="tbl-border" cellpadding="0" cellspacing="1"><tr><td class="tbl2"><strong>Quote</strong></td></tr><tr><td class="tbl1"><div style="width:450px;max-width:450px;height:'.$height.'max-height:400px;overflow:auto;" />'.$content.'</div></td></tr></table>';
        }
        } else {
	//	$text = (isset($delcontent)) && $delcontent!='' ? '<i><strong>Zitat '.(isset($args['quote']) ? "von ".$args['quote']."<br />" : "").'</strong>'.$delcontent.'</i>' : "";	
		$text = (isset($delcontent)) && $delcontent!='' ? '<i>'.$delcontent.'</i>' : "";
		}
        return $text;  
    }
    
    // Code-UBB 
    function ubb_code($args = array()) {
        $content = $this->parseArray(array('[/code]'), array('quote','geshi','code','php'));
		$content = parsesmileys($content,true);
		$e = count(explode("\n",$content));
		if ($e<=30) {$height="auto;";} else {$height="400px;";}	
		
        if(isset($args['code'])){
            $text = '<table class="tbl-border" cellpadding="0" cellspacing="1"><tr><td class="tbl2"><strong>'.strtoupper($args['code']).'-Code:</strong></td></tr><tr><td class="tbl1"><div style="width:450px;max-width:450px;height:'.$height.'px; max-height:400px;overflow:auto;" />'.$content.'</div></td></tr></table>';
        } else {
            $text = '<table class="tbl-border" cellpadding="0" cellspacing="1"><tr><td class="tbl2" style="background-image:url(\''.IMAGES.'/code2.png\');" /><strong>Code</strong></td></tr><tr><td class="tbl1"><div style="width:450px;max-width:450px;height:'.$height.'px; max-height:400px;overflow:auto;" />'.$content.'</div></td></tr></table>';
        }
        return $text;  
    }

	
	
    // Geshi-UBB
    function ubb_geshi($args = array()) {
		$glang = "text";
    	$content = $this->parseArray(array('[/geshi]'),array('quote','geshi','code'));
    	$content = parsesmileys($content,true);
    	$e = count(explode("\n",$content));
		if ($e<=30) {$height="auto;";} else {$height="400px;";}	

    	if(isset($args['geshi'])){
            switch($args['geshi']) {
				case "css":
				$glang = "css";
				break;
				case "html4strict":
				$glang = "html4strict";
				break;
				case "ini":
				$glang = "ini";
				break;
				case "javascript":
				$glang = "javascript";
				break;
				case "mysql":
				$glang = "mysql";
				break;
				case "php":
				$glang = "php";
				break;
				case "php-brief":
				$glang = "php-brief";
				break;
				case "sql":
				$glang = "sql";
				break;
				case "text":
				$glang = "text";
				break;
				default:
				$glang = "text";
				break;
			}
		}	

		
		if ($e<=200) {
			if (!@include_once($this->plugindir. "geshi.php")) {
             return '<table class="tbl-border" cellpadding="0" cellspacing="1"><tr><td class="tbl2"><strong>'.strtoupper($glang).'-Code:</strong></td></tr><tr><td class="tbl1"><div style="width:500px;max-width:500px;height:'.$height.'max-height:400px;overflow:auto;">'.$content.'</div></td></tr></table>';
             exit;
                }      
                $search = array("\\", "&quot;", "&#39;", "&#92;", "&quot;", "&#39;", "&lt;", "&gt;","&#91;","&#93;", "&amp;","",);
                $replace = array("\\\\", "\"", "'", "\\", "\"", "\'", "<", ">","[","]", "&","");
                $content = trim(str_replace($search,$replace, $content));      
                $geshi = &new GeSHi($content, $glang);
                $geshi -> header_type=GESHI_HEADER_NONE;
                $geshi -> set_overall_style('font-family:Verdana, Tahoma; font-size:10px;');
                $geshi -> set_overall_style('color: #000066; border: 0px solid #d0d0d0; background-color: #ffffff;', true);
                $geshi -> enable_line_numbers(GESHI_NO_LINE_NUMBERS);
               
                $jj=0;$aj=1;$sl="";$ai=10;$ll="";
                for($jj=1;$jj<=$e;$jj++) {
                if ($jj==$ai)  {$aj++;$ai=$aj*10; $sl="<strong>".$jj."</strong>";}
                else {$sl=$jj; }
                $ll.= $sl.($jj<$e ? "\n" : "");
                }
               
        return "<table class='tbl-border' cellpadding='0' cellspacing='1'><tr><td class='tbl2'><strong>Code: ".$geshi->get_language_name()."</strong></td>\n</tr><tr><td class='tbl1' valign='top'><div style='width:500px;height:".$height."max-height:400px;white-space:nowrap;overflow:auto;background-color:#ffffff;padding:0px;'><table cellspacing='0' width='100%' cellpadding='3' style='border: 0px solid #d0d0d0;'><tr><td valign='top' style='background-color:#d0d0d0;text-align:right;width:15px;' align='right'>".nl2br($ll)."</td><td valign='top' style='background-color:#ffffff;'>".$geshi->parse_code()."</td></tr></table></div></td>\n</tr></table>";
        exit;
        } else {
            return '<table class="tbl-border" cellpadding="0" cellspacing="1"><tr><td class="tbl2"><strong>'.strtoupper($glang).'-Code:</strong></td></tr><tr><td class="tbl1"><div style="width:450px;max-width:450px;height:'.$height.'max-height:400px;overflow:auto;" />'.$content.'</div></td></tr></table>';
             exit;
        }
    }
    
    
    
    function ubb_list($arguments){
       $content = $this->parseArray(array('[/list]', '[/ulist]'));
        if(!isset($arguments['list'])){
            $text = '<ul>'.$content.'</ul>';
        } else {
            $text = '<ol type="'.$arguments['list'].'">'.$content.'</ol>';
        }
        return $text;  
    }
    
    function ubb_li(){
    	$content = $this->parseArray(array('[/li]'));
        return '<li>'.$content.'</li>';
    }
    
      
    function ubb_ubboff(){
        $this->ubb_mode = false;
        $content = $this->parseArray(array('[/ubboff]'), array());
        $this->ubb_mode = true;
        
        return $content;
    }
    
    function ubb_mail($parameters)
    {
        $html = '';
        
        $mailto = array_shift($this->parseArray);
        $endtag = array_shift($this->parseArray);
        if($endtag == '[/mail]'){
            if(isset($parameters['mail'])){
                $html .= '<a href="mailto:'. $parameters['mail'] . '">'.$mailto.'</a>';
            } else {
                $html .= '<a href="mailto:'. $mailto . '">'.$mailto.'</a>';
            }
        } else {
            if(isset($parameters['mail'])){
                $html .= '<a href="mailto:'. $parameters['mail'] . '">'.$parameters['mail'].'</a>';
            }
            array_unshift($this->parseArray, $endtag);
            array_unshift($this->parseArray, $mailto);
            
            
        }
        return $html;
    }
    
    // Image
    function ubb_img($arguments)
    {
        if(isset($arguments['w'])){
            if((int) $arguments['w']){ // Int to eliminate scripting
                $awidth = 'width="'.((int)$arguments['w']).'" ';
            }else{
                $awidth = '';
            }
        } else {
            $awidth = '';
        }

        if(isset($arguments['h'])) {
            if((int) $arguments['h']){ // Int to eliminate scripting
                $aheight = 'height="'.((int)$arguments['h']).'" ';
            }else{
                $aheight = '';
            }
        } else {
            $aheight = '';
        }
        if(isset($arguments['alt']) && preg_match("/^[0-9A-Za-z-_\.\s]{3,100}+$/i",$arguments['alt'])){
        $alttext = ' alt="'.($arguments['alt']).'" title="'.($arguments['alt']).'"';
        } else {
        $alttext = ' alt="" title=""';
        }
        $maxwidth = 468;
        $maxheight = 400;
        $content = $this->parseArray(array('[/img]'), array());
        $name = md5($content);
        if (function_exists("fsockopen")) {
        $url_p = @parse_url($content);
		$host = $url_p['host'];
		$port = isset($url_p['port']) ? $url_p['port'] : 80;
		$fp = @fsockopen($url_p['host'], $port, $errno, $errstr, 5);
		if(!$fp) return false;
		@fputs($fp, 'GET '.$url_p['path'].' HTTP/1.1'.chr(10));
		@fputs($fp, 'HOST: '.$url_p['host'].chr(10));
		@fputs($fp, 'Connection: close'.chr(10).chr(10));
		$response = @fgets($fp,300);
		$dcontent = @fread($fp,300);
		$dcontent = preg_replace("#(.*?)text/plain(.*?)$#is","$2",$dcontent);
		@fclose ($fp);
		$img_gr = trim(str_replace(array(strstr($dcontent,"Connection"),"Content-Length:"),"",strstr($dcontent,"Content")));
		} else {
		$response = "200";
		$img_gr=0;
		$dyn_w ="";$dyn_h="";
		$test_start="";$text_end="";
		}
		
		if(preg_match("#200#",$response)) {
        $data = @getimagesize($content);
		if($data!==false) {
			$width = $data[0];
			$height = $data[1];
			if ($awidth!="" && $arguments['w']<$width) $width=$arguments['w'];
			if ($aheight!="" && $arguments['h']<$height) $height=$arguments['h'];
			$minwidth = $maxwidth;
			$newteiler = $width/$maxwidth;
			$minheight = $height/$newteiler;
			if($width <= $maxwidth && $height<=$maxheight) {
				$text = '<img src="'.$content.'" height="'.$height.'" width="'.$width.'" style="border:0px"'.$alttext.'>';
			} else {
				$text = '<div><a id="thumb1" href="'.$content.'" title="Click for fullsize" class="highslide" onclick="return hs.expand(this)"><img src="'.$content.'" style="border:0px; width:'.$minwidth.'px;height:'.$minheight.'px;"'.$alttext.'></a></div>';
			}
		} else {
		if ($img_gr>50000) {
		$dyn_w = 'width:'.$maxwidth.'px;';
		} else {
		$dyn_w = 'max-height:'.$maxheight.'px;';
		}
			$text = $text_start.'<img name="'.$name.'" src="'.$content.'" style="border:0px; max-width:468px;'.$dyn_w.'">'.$text_end;
		    }
        return $text;
        }
    }
    
    // Spoiler by ZOC
    function ubb_spoiler() {
	$content = $this->parseArray(array('[/spoiler]'), array());	
	$text = '<script type="text/javascript" src="'.INCLUDES.'"forum.js"></script><div><div id="pre-spoiler"><input name="button" type="button" style="width:50px;font-size:9px;margin:0px;padding:0px;" onClick="spoil(this);" value="Spoiler >"></div><div><div id="spoiler" class="textbox" style="display:none;padding:3px;border: 1px dashed;border-color:silver;margin:1px;">'.$content.'</div></div></div>';
	return $text;
	}
	
    // Size
    function ubb_size($args=array()) {
	$content = $this->parseArray(array('[/size]'), array());	

	if (isset($args['size'])) {
		if (is_numeric($args['size'])) {
			$size =  $args['size']<=48 ? $args['size']."px" : "12px"; 
		} else {
			$size = preg_match("/^[a-z_-]{4,10}$/",$args['size']) ? $args['size'] : "12px;";
		}
	$text = '<span style="font-size:'.$size.';">'.$content.'</span>';
	} else {
	$text = $content;	
	}
	return $text;
	}
	
    // color
    function ubb_color($args=array()) {
	$content = $this->parseArray(array('[/color]'));	
	
	if (isset($args['color'])) {
	$color = preg_match("/^[0-9a-z#]{3,10}$/",$args['color']) ? $args['color'] : "#000000;";
	$text = '<span style="color:'.$color.';">'.$content.'</span>';
	} else {
		$text = $content;
	}
	return $text;
	}
	
	// googlevideo
    function ubb_googlevideo() {
    	
	$content = $this->parseArray(array('[/googlevideo]'),array('clipfish','flash','youtube','myvideo','br','all' => 'all'));	
	if ($this->fsettings('ubb_video')) {
	$url = parse_url($content);$path="";
	$is_google = isset($url['scheme']) && $url['scheme']=="http" && isset($url['host']) && eregi("video.google",$url['host']) ? true : false;
	if ($is_google) {
	$path = str_replace("http://".$url['host']."/","",$content);	
	$path = str_replace(array("videoplay","googleplayer.swf","?","docid="),"",$path);
	} else {
	$path = is_numeric($content) ? $content : "";	
	}
	if ($path!='' && is_numeric($path)) {
	$text = '<embed id="VideoPlayback" src="http://video.google.de/googleplayer.swf?docid='.$path.'" style="width:400px;height:326px" allowFullScreen="true" allowScriptAccess="always" type="application/x-shockwave-flash"> </embed>';
	}else {
		$text = $content;
	}
	} else {
		$text = $content;
	}
	return $text;
	}
	
    // clipfishvideo
    function ubb_clipfish() {
	$content = $this->parseArray(array('[/clipfish]'));	
	if ($this->fsettings('ubb_video')) {
	$url = parse_url($content);$path="";
	$is_clipfish = isset($url['scheme']) && $url['scheme']=="http" && isset($url['host']) && eregi("clipfish",$url['host']) ? true : false;
	if ($is_clipfish) {
	$text = '<object type=\'application/x-shockwave-flash\' id=\'VideoPlayback\' width=\'400\' height=\'326\' data=\''.$content.'\'><param name=movie value=\''.$content.'\'><param name=\'wmode\' value=\'transparent\'><param name=\'quality\' value=\'high\'><param name=\'bgcolor\' value=\'#999999\'></object>';	
	}  else {
		$text = $content;
	}
	}
	 else {
		$text = $content;
	}
	return $text;
	}
	
	// youtube
    function ubb_youtube() {
   	$content = $this->parseArray(array('[/youtube]'));	
   	if ($this->fsettings('ubb_video')) {
	$url = parse_url($content);$path="";
	$is_youtube = isset($url['scheme']) && $url['scheme']=="http" && isset($url['host']) && eregi("youtube",$url['host']) ? true : false;
	if ($is_youtube) {
	$content = str_replace(array("watch?v=","v="),"v/",$content);	
	$text = '<object width="400" height="326"><param name="movie" value="'.$content.'"></param><embed src="'.$content.'" type="application/x-shockwave-flash" width="400" height="326"></embed></object>';
	} else {
		$text = $content;
	}
	} else {
		$text = $content;
	}
	return $text;
	}
	
	// youtube
    function ubb_myvideo() {
   	$content = $this->parseArray(array('[/myvideo]'));	
   	if ($this->fsettings('ubb_video')) {
	$url = parse_url($content);$path="";
	$is_myvideo = isset($url['scheme']) && $url['scheme']=="http" && isset($url['host']) && eregi("myvideo",$url['host']) ? true : false;
	if ($is_myvideo) {
	$content = str_replace("watch","movie",$content);	
	$text = '<object type=\'application/x-shockwave-flash\' id=\'VideoPlayback\' width=\'400\' height=\'326\' data=\''.$content.'\'><param name=movie value=\''.$content.'\'></object>';
	} else {
		$text = $content;
	}
	} else {
		$text = $content;
	}
	return $text;
	}

	
    function ubb_colorize()
    {
        $string = $this->parseArray(array('[/colorize]'), array());
        $returnstring = "";
        for($i = 0; $i < strlen($string); $i++){
            $r = rand(0,255);
            $g = rand(0,255);
            $b = rand(0,255);
            
            $r = dechex($r);
                if(strlen($r) < 2)
                    $r = "0".$r;
            
            $g = dechex($g);
                if(strlen($g) < 2)
                    $g = "0".$g;
            $b = dechex($b);
                if(strlen($b) < 2)
                    $b = "0".$b;
            
            $returnstring.= '<font color="#'.$r.$g.$b.'">'.substr($string, $i, 1).'</font>';
        }   
    
    return $returnstring;
    
    }
    
    function ubb_flash($arguments) {
    $width = '320';$height='240';	
	if(isset($arguments['width']) && is_numeric($arguments['width'])) {
		$width = $arguments['width'];
	} 
	if(isset($arguments['height']) && is_numeric($arguments['height'])) {
		$height = $arguments['height'];
	}
	$content = $this->parseArray(array('[/flash]'));
	$fvideo = preg_match("/^[-0-9A-Z_:\/\.]{10,100}\.([a-z]){3,3}$/i",$content) ? $content : '';
	if ($fvideo) {
	$text = '<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" codebase="http://active.macromedia.com/flash6/cabs/swflash.cab#version=6,0,0,0\' id="'.$content.'" width="'.$width.'" height="'.$height.'"><param name=movie value="'.$content.'"><param name="quality" value="high"><param name="bgcolor" value="#ffffff"><embed src="'.$content.'" quality="high" bgcolor="#ffffff" width="'.$width.'" height="'.$height.'" type="application/x-shockwave-flash" pluginspage="http://www.macromedia.com/go/getflashplayer"></embed></object>';
	return $text;
	} else {
	return $content;	
	}
	
	}
	
    
	function ubb_rainbow()
    {
        $string = $this->parseArray(array('[/rainbow]'), array());
        
        
        if(!@include_once($this->plugindir. "rainbow.php")){
             return '<strong>Rainbow plugin could not be loaded!</strong>';
        }
        
        $r = new rainbowMaker();
        
        return $r->rainBow($string);
    }
	   
}
?>       