<?php
/**
 * pd Similar Threads (PHP-Fusion)
 * show similar forum threads
 * @author: pirdani <http://www.pirdani.de> <kontakt@pirdani.de>
 * @version 0.1.0
 * 
 * Release under the terms & conditions of v3 or higher
 * of the GNU General Public License. For details refer 
 * to the included gpl.txt file or visit http://gnu.org
 *
 */
 
# locale
if (file_exists(INFUSIONS."pd_similar_threads/locale/".$settings['locale'].".php")) {
	include INFUSIONS."pd_similar_threads/locale/".$settings['locale'].".php";
} else {
	include INFUSIONS."pd_similar_threads/locale/German.php";
}
 
# include config file
include(INFUSIONS."pd_similar_threads/config.inc.php");
 
function pd_getSimilarThreads($tid, $title=FALSE, $cnt=0, $start=0, $order=TRUE, $pagenav=TRUE, $showlink=FALSE) {
  global $min_words_cnt, $min_words_len, $replace_words_array, $alternative_words_array, $locale;
  if(!(isset($tid) && isNum($tid))) redirect(BASEDIR."index.php");
  if($title==FALSE) {
    # sql query
    $query = dbquery("SELECT thread_subject FROM ".DB_PREFIX."threads AS t
                      INNER JOIN ".DB_PREFIX."forums AS f USING(forum_id)
                      LEFT OUTER JOIN ".DB_PREFIX."extboard_groups fg ON f.forum_id=fg.forum_id AND fg.auth_read='1'"
    ." WHERE (".forum_groupaccess('f.forum_access')."  OR ".forum_groupaccess('fg.group_id').") AND t.thread_id=".$tid." GROUP BY f.forum_id");
    if(!dbrows($query)) redirect(BASEDIR."index.php");
    $tdata = dbarray($query);
    $title = $tdata['thread_subject'];
  }  
  # create arrays
    # replace words
    $old_words = array();
    $new_words = array();
    foreach($replace_words_array as $value) {
  	  array_push($old_words, $value['old']);
  	  array_push($new_words, $value['new']);
    }
    # alternative words
    $alternative_old = array();
    $alternative_new = array();
    foreach($alternative_words_array as $value) {
    array_push($alternative_old, $value['word']);
  	array_push($alternative_new, $value['alternative']);
    }
  # all in lower caps
  $thread_title = " ".(strtolower($title))." ";
  # replace words from old_words with words from new_words
  $thread_title = str_replace($old_words, $new_words, $thread_title);
  # create words array
  $all_words = explode(" ", $thread_title);
  # remove duplicate words
  $all_words = array_unique($all_words);
  # at $min_words_cnt words in the array,
  # remove words with under $min_words_len caps 
  $small_words = array();
  if(count($all_words)>$min_words_cnt) foreach($all_words as $value) if(strlen($value)<$min_words_len) array_push($small_words, "|".$value."|");
  $thread_title = "| |";
  foreach ($all_words as $value) $thread_title .= $value."| |";
  $thread_title = str_replace($small_words, "", $thread_title);
  $thread_title = str_replace("|", " ", $thread_title);
  # create array
  $similar_words = explode(" ", $thread_title);
  # remove duplicate words
  $similar_words = array_unique($similar_words);
  # sort array
  sort($similar_words);
  # create where-query
  $where_query = "";
  for($i=0; $i<count($similar_words); $i++) {
  	if($similar_words[$i]!="") {
		  $arr_key=array_search($similar_words[$i], $alternative_old);
		  if(isNum($arr_key)) {
  			$where_query .= "(t.thread_subject LIKE '%".str_replace("|", "%' OR  t.thread_subject LIKE '%", $alternative_new[$arr_key])."%') AND ";
		  } else {
  			$where_query .= "t.thread_subject LIKE '%".$similar_words[$i]."%' AND ";
		  }
	  }			
  }
  if ($where_query!="") {
  # remove the last logic operation
  $where_query = substr($where_query, 0, -5);
  $similar_threads=0;
  if ($where_query) {
  # sql query for count
  $query_cnt = dbquery("SELECT thread_subject, thread_lastuser, thread_views, forum_name,"
  	." fu.user_id, MAX(p.post_id) as last_id, thread_lastpost,"
  	." COUNT(p.post_id) as count_posts, f.forum_id, t.thread_id,"
  	." fu.user_name AS last_user, thread_locked,fg.group_id"
  	." FROM ".DB_PREFIX."forums AS f"
  	." INNER JOIN ".DB_PREFIX."threads AS t USING(forum_id)"
  	." INNER JOIN ".DB_PREFIX."posts AS p USING(thread_id)"
  	." LEFT OUTER JOIN ".DB_PREFIX."users AS fu ON t.thread_lastuser=fu.user_id"
  	." LEFT OUTER JOIN ".DB_PREFIX."extboard_groups fg ON f.forum_id=fg.forum_id AND fg.auth_read='1'"
    ." WHERE (".$where_query.") AND (".forum_groupaccess('f.forum_access')." OR ".forum_groupaccess('fg.group_id').") AND t.thread_id<>'".$tid."'"
    ." GROUP BY t.thread_id;");
  $similar_threads = dbrows($query_cnt);
  # sql query for list threads
  if($cnt!=0 AND $similar_threads>$cnt) { 
    $query = dbquery("SELECT thread_subject, thread_lastuser, thread_views, forum_name,"
    	." fu.user_id, MAX(p.post_id) as last_id, thread_lastpost,"
    	." COUNT(p.post_id) as count_posts, f.forum_id, t.thread_id,"
	    ." fu.user_name AS last_user, thread_locked,fg.group_id"
    	." FROM ".DB_PREFIX."forums AS f"
    	." INNER JOIN ".DB_PREFIX."threads AS t USING(forum_id)"
    	." INNER JOIN ".DB_PREFIX."posts AS p USING(thread_id)"
    	." LEFT JOIN ".DB_PREFIX."users AS fu ON t.thread_lastuser=fu.user_id"
    	." LEFT OUTER JOIN ".DB_PREFIX."extboard_groups fg ON f.forum_id=fg.forum_id AND fg.auth_read='1'"
	    ." WHERE (".$where_query.") AND (".forum_groupaccess('f.forum_access')."  OR ".forum_groupaccess('fg.group_id').")"
		." AND t.thread_id<>'".$tid."'"
    	." GROUP BY t.thread_id"
    	.($order==FALSE ? " ORDER BY rand()"
    	." LIMIT ".$start.",".$cnt : " ORDER BY t.thread_lastpost DESC"
    	." LIMIT ".$start.",".$cnt));
  } else {
    $query = $query_cnt;
  }
	if(dbrows($query)>0) {
		opentable($locale['PDST201']." &quot;".$title."&quot;&nbsp;[".$similar_threads."]");
			echo "<table cellspacing='1' width='100%' class='tbl-border'>
							<thead>
								<tr>
									<th class='tbl2' align='left'>".$locale['PDST202']."</th>
									<th class='tbl2' align='center' width='1%' style='white-space:nowrap'>".$locale['PDST203']."</th>
									<th class='tbl2' align='center' width='1%' style='white-space:nowrap'>".$locale['PDST204']."</th>
								</tr>
							</thead>
							<tbody>\n";
			$count=0;
			while($sdata = dbarray($query)) {
				$tbl = "tbl".(($count++ % 2)+1);
				echo "<tr>
								<td class='$tbl'><a href='".FORUM."viewthread.php?forum_id=".$sdata['forum_id']."&amp;thread_id=".$sdata['thread_id']."' title='".$sdata['thread_subject']."'>".trimlink($sdata['thread_subject'], 70)."</a><br>".$sdata['forum_name']."</td>
								<td align='center' class='$tbl' style='white-space:nowrap'><b>".($sdata['count_posts']-1)."</b><br><small>".$sdata['thread_views']." ".($sdata['thread_views']==1 ? $locale['PDST206'] : $locale['PDST207'])."</small></td>
								<td class='$tbl' align='center' style='white-space:nowrap'>".showdate("forumdate", $sdata['thread_lastpost'])."<br><a href='".BASEDIR."profile.php?lookup=".$sdata['thread_lastuser']."'>".$sdata['last_user']."</a></td>
							</tr>\n";
			}
      if($showlink==TRUE && $similar_threads>$cnt) {
        $tbl = "tbl".(($count++ % 2)+1);
				echo "<tr>
							<td class='$tbl' align='right' valign='middle' colspan='3'><a href='".INFUSIONS."pd_similar_threads/list.php?tid=".$tid."'>".$locale['PDST205']." &quot;".$title."&quot;</a></td>
							</tr>\n";
      }
			echo "</tbody></table>";
		if($pagenav==TRUE && $similar_threads>$cnt) {
		  echo "<div align='center' style='margin-top:5px;'>\n".makePageNav($start,$cnt,$similar_threads,3,INFUSIONS."pd_similar_threads/list.php?tid=".$tid."&amp;")."\n</div>\n";
		}
		closetable();
	}
	}
	}
}
 
?>