<!-- // Michael Estigoy -->
<!-- // michael@estigoy.net -->

<!-- // this implementation inspired by the following: -->
<!-- // http://the-stickman.com/web-development/javascript/upload-multiple-files-with-a-single-file-element/ -->
<!-- // and http://www.petefreitag.com/item/587.cfm -->

<!-- // tested on IE7, IE8, Safari 3.1.1 Win, Opera 9.5 Win, Firefox 2.0.0.14 Win and Firefox 3.0 Win -->

<!-- // I just wanted a plain javascript implementation of a multiple file upload that was functionally -->
<!-- // compatibile across different browsers -->

<!-- // delete button image - use your own gif or jpg file if you want -->
var delete_btn = 'images/cross.gif';

<!-- //no need to modify below here, unless you want to make the file_list more presentable -->

<!-- // start counting at zer0 -->
var upload_number = 0;
function addFileInput(obj,max) {

		<!-- // get the original file input element -->
		var orig_element = document.getElementById('file');

		<!-- // and get the original elements parentNode -->
 		var pNode = orig_element.parentNode;

		<!-- // now hide the orignal element by pushing it off to the side, out of view -->
		orig_element.style.position = 'absolute';
		orig_element.style.left = '-1000px';
<!-- // change the originals attributes and give it a name ('file[]' is used to name files in the $_FILES array) -->
		orig_element.name = 'attach[]';
		orig_element.id = '';
		<!-- // increment the upload number -->
		upload_number++;
		<!-- // create a new input element, give it the same attributes as the original (see HTML form below), including the onchange event -->
		var new_element = document.createElement( 'input' );
		new_element.type = 'file';
		new_element.setAttribute('id', 'file');
		new_element.setAttribute('class', 'textbox');
		new_element.onchange = function() {
			addFileInput(this,max);
			};

		<!-- // insert the new element into the DOM before the old element-->
 		pNode.insertBefore(new_element, orig_element);

		<!-- // get the full path of the added file -->
		var path = obj.value;

		<!-- // now just get the filename only to display in the list -->
		var filename = path.substring(path.lastIndexOf('\\')+1)

		<!-- // Now add the filename to the file list-->
		var new_row = document.createElement( 'div' );
		new_row.setAttribute('id', upload_number);

		<!-- // create the delete button -->
		var new_row_button = document.createElement( 'img' );
		new_row_button.src = delete_btn;
		new_row_button.align = 'absmiddle';
		new_row_button.alt = 'remove '+filename+' from list';
		new_row_button.title = 'remove '+filename+' from list';

		<!-- // reference the object -->
		new_row.element = obj;

		<!-- // Delete function for button -->
		new_row_button.onclick = function(){

			<!-- // Remove this row from the list-->
			this.parentNode.parentNode.removeChild( this.parentNode );

			<!-- // Remove element from form-->
			this.parentNode.element.parentNode.removeChild( this.parentNode.element );

			<!-- // decrement the upload number -->
			upload_number--;

			<!-- // re-enable the input if upload_number is less than max-->
			if (upload_number < max){
				document.getElementById("file").disabled = false;
				}
			<!-- // hide the file_div if user removed all files from list -->
			if ( upload_number < 1 ){
				document.getElementById("file_div").style.visibility = "hidden";
				}
			return false;
		};

		<!-- // style the file_list - you may want to customize this part -->
		<!-- // create a new row with the filename -->
		new_row.innerHTML = '<span style="padding: 10px;">'+filename+'</span>';
		
		<!-- // add the button you defined at the beginning of this script to the end of the new row -->
		new_row.appendChild( new_row_button );
		
		<!-- // add the new row to the file list div -->
		document.getElementById("file_list").appendChild(new_row);

		<!-- // disable the file input if max number of files have been added -->
		if (upload_number >= max){
			document.getElementById("file").disabled = true;
			}

		<!-- // show the file div and submit button if files added -->
		if ( upload_number >= 1 ){
			document.getElementById("file_div").style.visibility = "visible";
			}

	};