<%@ Import Namespace="System.Xml" %>

<script language="VB" runat="server">

'Relative file path to XML data
Dim strXmlFilePath as String = Server.MapPath("quiz.xml")

Dim xDoc as XmlDocument = New XmlDocument()
Dim intTotalQuestion as Integer
Dim intQuestionNo as Integer = 1
Dim intScore as Integer = 0
Dim arrAnswerHistory as new ArrayList()

Sub Page_Load(src as Object, e as EventArgs)

	'Load xml data
	xDoc.Load(strXmlFilePath)

	'Start a new quiz?
	If Not Page.IsPostBack Then

		'Yes! Count total question
		intTotalQuestion = xDoc.SelectNodes("/quiz/mchoice").Count

		'Record start time
		ViewState("StartTime") = DateTime.Now

		ShowQuestion(intQuestionNo)
	End If
End Sub


Sub btnSubmit_Click(src as Object, e as EventArgs)

	'Retrieve essential variables from state bag
	intTotalQuestion = ViewState("TotalQuestion")
	intQuestionNo = ViewState("QuestionNo")
	intScore = ViewState("Score")
	arrAnswerHistory = ViewState("AnswerHistory")

	'Correct answer?
	If rblAnswer.SelectedItem.Value = ViewState("CorrectAnswer") Then
		intScore += 1
		arrAnswerHistory.Add(0)
	Else
		arrAnswerHistory.Add(rblAnswer.SelectedItem.Value)
	End If

	'End of quiz?
	If intQuestionNo=intTotalQuestion Then

		'Yes! Show the result...
		QuizScreen.Visible = False
		ResultScreen.Visible = True

		'Render result screen
		ShowResult()

	Else

		'Not yet! Show another question...
		QuizScreen.Visible = True
		ResultScreen.Visible = False
		intQuestionNo += 1
	
		'Render next question
		ShowQuestion(intQuestionNo)
	End If
End Sub


Sub ShowQuestion(intQuestionNo as Integer)
	Dim xNodeList as XmlNodeList
	Dim xNodeAttr as Object
	Dim strXPath as String
	Dim i as Integer
	Dim tsTimeSpent as TimeSpan

	strXPath = "/quiz/mchoice[" & intQuestionNo.ToString() & "]"

	'Extract question
	lblQuestion.Text = intQuestionNo.ToString() & ". " & xDoc.SelectSingleNode(strXPath & "/question").InnerXml

	'Extract answers
	xNodeList = xDoc.SelectNodes(strXPath & "/answer")

	'Clear previous listitems
	rblAnswer.Items.Clear
	
	For i = 0 to xNodeList.Count-1

		'Add item to radiobuttonlist
		rblAnswer.Items.Add(new ListItem(xNodeList.Item(i).InnerText, i+1))

		'Extract correct answer
		xNodeAttr = xNodeList.Item(i).Attributes.ItemOf("correct")
		If not xNodeAttr is Nothing Then
			If xNodeAttr.Value = "yes" Then
				ViewState("CorrectAnswer") = i+1
			End If
		End If
	Next

	'Output Total Question
	lblTotalQuestion.Text = intTotalQuestion

	'Output Time Spent
	tsTimeSpent = DateTime.Now.Subtract(ViewState("StartTime"))
	lblTimeSpent.Text = tsTimeSpent.Minutes.ToString() & ":" & tsTimeSpent.Seconds.ToString()

	'Store essential data to viewstate
	ViewState("TotalQuestion") = intTotalQuestion
	ViewState("Score") = intScore
	ViewState("QuestionNo") = intQuestionNo
	ViewState("AnswerHistory") = arrAnswerHistory

End Sub

Sub ShowResult()
	Dim strResult as String
	Dim intCompetency as Integer
	Dim i as Integer
	Dim strXPath as String
	Dim tsTimeSpent as TimeSpan
	
	tsTimeSpent = DateTime.Now.Subtract(ViewState("StartTime"))

	strResult  = "<center>"
	strResult += "<h3>Quiz Result</h3>"
	strResult += "<p>Points: " & intScore.ToString() & " of " & intTotalQuestion.ToString()
	strResult += "<p>Your Competency: " & Int(intScore/intTotalQuestion*100).ToString() & "%"
	strResult += "<p>Time Spent: " & tsTimeSpent.Minutes.ToString() & ":" & tsTimeSpent.Seconds.ToString()
	strResult += "</center>"

	strResult += "<h3>Quiz Breakdown:</h3>"
	For i = 1 to intTotalQuestion
		strXPath = "/quiz/mchoice[" & i.ToString() & "]"
		strResult += "<b>" & i.ToString() & ". " & xDoc.SelectNodes(strXPath & "/question").Item(0).InnerXml & "</b><br>"
		If arrAnswerHistory.Item(i-1)=0 Then
			strResult += "<font color=""green""><b>Correct</b></font><br><br>"
		Else
			strResult += "<b>You answered:</b> " & xDoc.SelectNodes(strXPath & "/answer[" & arrAnswerHistory.Item(i-1).ToString() & "]").Item(0).InnerXml & "<br>"
			strResult += "<font color=""red""><b>Incorrect</b></font><br><br>"
		End If
	Next

	lblResult.Text = strResult
End Sub

</script>
<html>
<head>
<title>Australian Geography Quiz</title>
</head>

<style>
body {
  font-size: 10pt;
  font-family: verdana,helvetica,arial,sans-serif;
  color:#000000;
  background-color:#eeeedd;
}

tr.heading {
  background-color:#900B08;
}

.button {
	border: 1px solid #000000;
	background-color: #ffffff;
}

</style>

<body>
<span id="QuizScreen" runat="server">
<form runat="server">
<table width="100%" border="0" cellpadding="2" cellspacing="0">
  <tr class="heading">
    <td width="50%"><font color="white"><b>Australian Geography Quiz</b></font></td>
	<td width="50%" align="right"><font color="white"><b>www.codeproject.com</b></font></td>
  </tr>
  <tr>
    <td colspan="2">
	  <b><asp:label id="lblQuestion" runat="server" /></b><br>
      <asp:radiobuttonlist
	     id="rblAnswer"
		 RepeatDirection="vertical"
		 TextAlign="right"
		 RepeatLayout="table"
		 runat="server" /><br>
	  <asp:requiredfieldvalidator
		 ControlToValidate="rblAnswer"
		 ErrorMessage="Please pick an answer!"
		 runat="server" /><br>
      <asp:button id="btnSubmit" class="button" text="  Next  " onClick="btnSubmit_Click" runat="server" />
	</td>
  </tr>
  <tr class="heading">
    <td width="50%"><font color="white"><b>Total <asp:label id="lblTotalQuestion" runat="server" /> questions</b></font></td>
	<td width="50%" align="right"><font color="white"><b>Time spent <asp:label id="lblTimeSpent" runat="server" /></b></font></td>
  </tr>
</table>
</form>
</span>
<span id="ResultScreen" runat="server">
<asp:label id="lblResult" runat="server" />
</span>
</body>
</html>
