	/**
	* Zahlenraetsel
	* Copyleft 2008 - Luca Lovisa
	* 1.0
	*
	* BEER-WARE-LICENSE:
	* This programm is free software; As long as you retain this
	* notice you can do whatever you want with this stuff and project.
	* If we meet some day, and you think this stuff is worth it,
	* you can buy me a beer in return.
	*
	* This programm is distributed in the hope that it will be useful,
	* but WITHOUT ANY WARRANTY; without even the implied warranty of
	* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
	*/
	
	#include <iostream>

	#define POSSIBLE_DIFFERENCES 81
	#define POSSIBLE_NUMBERS 1000
	#define POSSIBLE_PRODUCTS 103360
	#define POSSIBLE_PRODUCTS_REDUCED 6984
	#define POSSIBLE_SUMMATIONS 235
	#define POSSIBLE_SUMMATIONS_REDUCED	81


	using namespace std;
	
	/**
	* This struct represents one simple product.
	*/
	struct Product
	{
		int value;
		
		Product *next;
		Product *prev;
		
		short one;
		short two;
	};
	
	bool InList(int value, int *list, int start = 0, int stop = (POSSIBLE_PRODUCTS -1));
	
	void DifferencesCreate(int *differences, int *summationsReduced);
	void DifferencesReduce(int *result, int *differences);
	
	void ProductsCopyToList(int *productList, Product *productFirst, Product *productLast);
	void ProductsCreate(Product *productFirst, Product *&productLast);
	void ProductsReduce(Product *&productFirst, Product *&productLast);
	void ProductsReduceSecond(Product *productFirst, Product *productLast, int *productListReduced, int *summations);
	void ProductsSort(Product *productFirst, Product *productLast);
	void ProductsSwap(Product *productFirst, Product *productLast);
	
	void SummationsCreate(int *summations, int *productList);
	void SummationsReduce(int *summationsReduced, int *summations, int *productsListReduced);
	void SummationsReducedSort(int *summationsReduced);
	
	
	/**
	* This function checks if a number is in a list.
	*/
	bool InList(int value, int *list, int start, int stop)
	{
		// there's only one case left
		if(start == stop)
		{
			// value was found
			if(list[start] == value)
				return true;
			else
				return false;
		}
		
		// use algoritm like quicksort to find the summation faster		
		if((list[((start +stop) /2)] < value) && list[((start +stop) /2)] != 0)
			return InList(value, list, (((start +stop) /2) +1), stop);
		else
			return InList(value, list, start, ((start +stop) /2));
	}


	/**
	* This function creates the differences.
	*/
	void DifferencesCreate(int *differences, int *summationsReduced)
	{
		bool doubled;
		
		int a, b, d, tmp, k, count = 0;
		
		short i = 0;
		
		while(i <= 75)
		{
			if(summationsReduced[i] != summationsReduced[i +3])
				i += 3;
			
			else
			{
				doubled = false;
				k = 0;
				         
				d = summationsReduced[i];
				
				while(d == summationsReduced[i +k])
				{
					a = summationsReduced[i +k +1];
					b = summationsReduced[i +k +2];
					tmp = i + k +3;

					while((d == summationsReduced[tmp]) && (tmp <= 78))
					{
						if((summationsReduced[tmp +1] == a) || (summationsReduced[tmp +1] == b) || (summationsReduced[tmp +2] == a) || (summationsReduced[tmp +2] == b))
							doubled = true;

						tmp += 3;
					}
					
					k += 3;
				}
				
				while((d == summationsReduced[i]) && (i <= 78))
				{
					if(doubled)
					{
						differences[count] = summationsReduced[i];
						differences[count +1] = summationsReduced[i +1];
						differences[count +2] = summationsReduced[i +2];

						count += 3;
					}
          
          i += 3;
				}
			}
		}
	}
	
	
	/**
	* This function reduces the differences.
	*/
	void DifferencesReduce(int *result, int *differences)
	{
		short i = 0;
		
		// result not found
		while(differences[i] != 0)
		{
			if((differences[i +1] == differences[i +4]) || (differences[i +2] == differences[i +4]) ||
				(differences[i +1] == differences[i +5]) || (differences[i +2] == differences[i +5]))
			{
				result[0] = differences[i +6];
				result[1] = differences[i +7];
				result[2] = differences[i +8];
			}
			else if((differences[i +1] == differences[i +7]) || (differences[i +2] == differences[i +7]) ||
				(differences[i +1] == differences[i +8]) || (differences[i +2] == differences[i +8]))
			{
				result[0] = differences[i +3];
				result[1] = differences[i +4];
				result[2] = differences[i +5];
			}
			else
			{
				result[0] = differences[i];
				result[1] = differences[i +1];
				result[2] = differences[i +2];
			}

			i += 9;
		}
	}
	
	
	/**
	* This function copy all products to a simple list.
	*/
	void ProductsCopyToList(int *productList,Product *productFirst, Product *productLast)
	{
		int counter = 0;
		
		do {
			// prevent multiple products
			if(productFirst->value != productList[counter -1])
			{
				// add value to the list
				productList[counter] = productFirst->value;
				
				// increase the counter
				counter ++;
			}
			
			// set next product
			productFirst = productFirst->next;
		} while(productFirst->next != 0);
	}
	
	
	/**
	* This function creates the table of products.
	*/
	void ProductsCreate(Product *productFirst, Product *&productLast)
	{
		productFirst->prev = 0;
		productLast = productFirst;
		
		// create the first number
		for(short i = 1; i <= POSSIBLE_NUMBERS; i ++)
		{
			// create the second number
			for(short j = 1; j <= i; j ++)
			{
				// calculate the product
				productFirst->one = i;
				productFirst->two = j;
				productFirst->value = (i *j);
				productFirst->next = new Product;
				
				// reference the next product
				productLast = productFirst->next;
				productLast->prev = productFirst;
				productFirst = productLast;
			}
		}
		
		// delete the product that is too much
		productLast = productLast->prev;
		
		delete productLast->next;
	}
	

	/**
	* This function reduces the products.
	*/
	void ProductsReduce(Product *&productFirst, Product *&productLast)
	{
		// pointer on the first product
		Product *first;
		
		// search for first valid product
		while(productFirst->value != productFirst->next->value)
		{
			// point on the new element
			productFirst = productFirst->next;
			
			// delete the old element
			delete productFirst->prev;
		}
		
		// set the first product
		first = productFirst;
		
		// start with the second product
		productFirst = productFirst->next;
		
		
		// check every product
		while(productFirst != productLast)
		{
			// the value is there just one time
			if((productFirst->value != productFirst->prev->value) && (productFirst->value != productFirst->next->value))
			{
				// buffer the object that should be deleted
				Product *productDelete = productFirst;
				
				// extract it out of the list
				productFirst->prev->next = productFirst->next;
				productFirst->next->prev = productFirst->prev;
				
				productFirst = productFirst->prev;
				
				delete productDelete;
			}
			
			// set next product
			productFirst = productFirst->next;
		}
		
		// check the last product
		if((productFirst->value != productFirst->prev->value))
		{		
			// reset the last product
			productLast = productLast->prev;
			
			// extract it out of the list
			productFirst->prev->next = 0;
				
			delete productFirst;
		}
			
		// reset the first point
		productFirst = first;
	}


	/**
	* This function reduces the product a second time.
	*/
	void ProductsReduceSecond(Product *productFirst, Product *productLast, int *productListReduced, int *summations)
	{
		bool end = false;
		
		short count = 0;
		short counter = 0;
		
		int value;
		
		do {
			// reset counter
			counter = 0;
			
			// set new value
			value = productFirst->value;

			// search for all numbers with the same value
			while((productFirst->value == value) && (end != true))
			{
				// the summation was found
				if(InList((productFirst->one + productFirst->two), summations, 0, (POSSIBLE_SUMMATIONS -1)))
					counter ++;
	
				if(productFirst == productLast)
					end = true;
				else
					productFirst = productFirst->next;
			}

			// the result was found once
			if(counter == 1)
			{
				productListReduced[count] = value;
				
				count ++;
			}
		} while(productFirst != productLast);
	}
		
	
	/**
	* This function sorts the products using quicksort algorithm.
	*/
	void ProductsSort(Product *productFirst, Product *productLast)
	{
		// create the quicksort pivot
		int pivot = (productFirst->value + productLast->value);
		
		// create some local references
		Product *first = productFirst;
		Product *last = productLast;
		
		// the products are still not sorted
		while(first != last)
		{				
			while(((last->value *2) >= pivot) && (first != last)) {
				last = last->prev; }
			
			while(((first->value *2) < pivot) && (first != last)) {
				first = first->next; }
					
			// swap both products
			ProductsSwap(first, last);
		}
		
		if((productFirst != first) && (productLast != first))
			ProductsSort(productFirst, first);
		
		if(productLast != last)
			ProductsSort(last->next, productLast);
	}

	
	/**
	* This function swaps two products.
	*/
	void ProductsSwap(Product *productFirst, Product *productLast)
	{
		Product swap;
		
		// change values to swap
		swap.one = productFirst->one;
		swap.two = productFirst->two;
		swap.value = productFirst->value;
		
		// change values to productFirst
		productFirst->one = productLast->one;
		productFirst->two = productLast->two;
		productFirst->value = productLast->value;
		
		// change values to productLast
		productLast->one = swap.one;
		productLast->two = swap.two;
		productLast->value = swap.value;
	}
	
	
	/**
	* This function creates the summations.
	*/
	void SummationsCreate(int *summations, int *productList)
	{
		bool found;
		
		short counter = 0;
		
		// check all number up to 2000
		for(short i = 2; i <= 2000; i ++)
		{
			found = true;

			for(short j = 1; j <= (i -j); j ++)
			{
				// the product wasn't in the list
				if(!InList(((i -j) *j), productList))
					found = false;
			}
			
			// the summation was found one time
			if(found)
			{
				// add number to summations
				summations[counter] = i;
			
				// increase counter
				counter ++;
			}
		}	
	}
	
	
	/**
	* This function reduces the summations.
	*/
	void SummationsReduce(int *summationsReduced, int *summations, int *productsListReduced)
	{		
		short count = 0;
		short counter = 0;
		
		short tmp;
		
		// check every summation
		for(short i = 0; i < POSSIBLE_SUMMATIONS; i ++)
		{
			// reset counter
			counter = 0;
			
			// check every case
			for(short j = 1; j <= (summations[i] -j); j ++)
			{
				// the product was found
				if(InList(((summations[i] -j) *j), productsListReduced, 0, (POSSIBLE_PRODUCTS_REDUCED -1)))
				{
					// increase counter
					counter ++;
					
					if(counter == 1)
						tmp = j;					
				}
			}
			
			// add value to list (1 time found)
			if(counter == 1)
			{
				summationsReduced[count] = summations[i] -tmp -tmp;
				summationsReduced[count +1] = tmp;
				summationsReduced[count +2] = summations[i] -tmp;
				
				// increase counter
				count += 3;
			}
		}
	}
		
	
	/**
	* This function sorts the reduced functions.
	*/
	void SummationsReducedSort(int *summationsReduced)
	{
		short tmp;
		
		for(short i = 2; i < (POSSIBLE_SUMMATIONS_REDUCED /3); i ++)
		{
			for(short j = 0; (j *3) < (POSSIBLE_SUMMATIONS_REDUCED -(i *3)); j ++)
			{
				if(summationsReduced[(j *3)] > summationsReduced[((j +1) *3)])
				{
					for(short k = 0; k < 3; k ++)
					{
						tmp = summationsReduced[((j *3) +k)];
						summationsReduced[((j *3) +k)] = summationsReduced[(((j +1) *3) +k)];
						summationsReduced[(((j +1) *3) +k)] = tmp;
					}
				}
			}
		}
	}
		
	
	
	/**
	* This function is the main function.
	*/
	int main(int argc, char **argv)
	{
		cout << "\nDas ober-hammer-schwere Zahlenraetsel\n"<< endl;
		
		
		//
		// (1.) Peter: Ich kenne die Zahlen nicht.
		// 	Bedeutung:
		//		Das Produkt, das Peter kennt, ist in mehr als eine Kombination zerlegbar.
		//	Programm:
		//		Erstellen einer Tabelle mit allen 500500 Produkten.
		//		Sortieren dieser Tabelle.
		//		Rausschmeissen aller Eintraege die nur einmal vorkommen.
		//
		cout << "\n Step 1." << endl;
		
		cout << "  >> Creating products ..." << endl;
		// create memory for the products
		Product *productFirst = new Product;
		Product *productLast = 0;
		
		// create a table with all 500500 possible products
		ProductsCreate(productFirst, productLast);
		cout << "  >> Done ...\n" << endl;
		
		
		cout << "  >> Sorting products ..." << endl;
		// sort the table using bubblesort
		ProductsSort(productFirst, productLast);
		cout << "  >> Done ...\n" << endl;
		
		
		cout << "  >> Reducing products ..." << endl;
		// reduce all unique products
		ProductsReduce(productFirst, productLast);
		cout << "  >> Done ...\n" << endl;
		
		
		cout << "  >> Copy products to a simple list ..." << endl;
		// create the product list
		int productList[POSSIBLE_PRODUCTS] = {0};
		
		// copy the prodcuts
		ProductsCopyToList(productList, productFirst, productLast);
		cout << "  >> Done ...\n" << endl;
		
		
		//
		// (2.) Simon: Das brauchst du mir nicht zu sagen, denn das wusste ich schon.
		//	Bedeutung:
		//		Die Summe, die Simon kennt, laesst sich nur in Kombinationen zerlegen deren Produkte wiederum
		//		in mehrere Kombinationen zerlegbar sind.
		//	Programm:
		//		Durchlaufen aller Zahlen von 2 bis 2000.
		//		Fuer jede Zahl ueberpruefen, ob ALLE ihre moeglichen Zerlegungen jeweils als Produkt in Tabelle(1) auftauchen.
		//		Eintragen dieser Zahlen in eine neue Tabelle.
		//
		cout << "\n Step 2." << endl;
		
		// create memory for the summations
		int summations[POSSIBLE_SUMMATIONS];
		
		cout << "  >> Creating summations ..." << endl;
		// check the summations from 2 up to 2000
		SummationsCreate(summations, productList);
		cout << "  >> Done ...\n" << endl;
		
		
		//
		// (3.) Peter: Dann kenne ich die Zahlen jetzt.
		//	Bedeutung:
		//		Das Produkt das Peter kennt, besitzt genau EINE Kombination deren Summe Kriterium (2) erfuellt.
		//		Alle anderen Kombinationen ergeben Summen die (2) nicht erfuellen.
		//	Programm:
		//		Durchlaufen aller Kombinationen, deren Produkte in Tabelle(1) gespeichert sind.
		//		Rausschmeissen aller Produkte, die entweder keine, oder mehr als eine Kombination besitzen
		//		deren Summe in Tabelle(2) gespeichert ist.
		//
		cout << "\n Step 3." << endl;
		
		// create memory for the reduced products
		int productListReduced[POSSIBLE_PRODUCTS_REDUCED];
		
		cout << "  >> Reducing products ..." << endl;
		ProductsReduceSecond(productFirst, productLast, &productListReduced[0], &summations[0]);
		cout << "  >> Done ...\n" << endl;
		
		
		//
		// (4.) Simon: Ich kenne sie jetzt auch.
		//	Bedeutung:
		//		Die Summe, die Simon kennt, besitzt genau EINE Kombination deren Produkt Kriterium (3) erfuellt,
		//		alle anderen Kombinationen ergeben Produkte die (3) nicht erfuellen.
		//	Programm:
		//		Durchlaufen aller Kombinationen, deren Summen in Tabelle(2) gespeichert sind.
		//		Rausschmeissen aller Summen, die entweder keine, oder mehr als eine Kombination besitzen,
		//		deren Produkt in (der ausgeduennten) Tabelle(1) gespeichert ist.
		//
		cout << "\n Step 4." << endl;
		
		cout << "  >> Reducing summations ..." << endl;
		// create memory for the reduced summations
		int summationsReduced[POSSIBLE_SUMMATIONS_REDUCED];
		SummationsReduce(summationsReduced, summations, productListReduced);
		cout << "  >> Done\n" << endl;
		
	
		cout << "  >> Sorting reduced summations ..." << endl;
		// sort the reduced summations
		SummationsReducedSort(summationsReduced);
		cout << "  >> Done\n" << endl;
		
		
		//
		// (5.) Daniel: Ich kenne die beiden Zahlen noch nicht. Ich kann nur eine Zahl vermuten, die wahrscheinlich dabei ist, aber sicher weiß ich's nicht.
		// 	Bedeutung:
		//		Mindestens zwei Kombinationen haben dieselbe Differenz, darueber hinaus besitzen sie mindestens eine gemeinsame Zahl
		//	Programm:
		//		Dortieren aller moeglichen Kombinationen nach der Differenz.
		//		Rausschmeissen aller Kombinationen, deren Differenz nur einmal auftaucht.
		//		Rausschmeissen aller Kombinationen gleicher Differenz, die keine Zahl gemeinsam haben.
		//
		cout << "\n Step 5." << endl;
		
		// create memory for the differences
		int differences[POSSIBLE_DIFFERENCES] = {0};
		
		cout << "  >> Creating differences ..." << endl;
		// creating differences
		DifferencesCreate(differences, summationsReduced);
		cout << "  >> Done ...\n" << endl;
				
		
		//
		// (6.) Peter: Ich weiß, welche Zahl Du vermutest, aber die ist falsch.
		// (7.) Daniel: OK, dann kenne ich jetzt auch beide Zahlen.
		// 	Bedeutung:
		//		Es gibt drei Kombinationen derselben Differenz, in zwei Kombinationen kommt dieselbe Zahl vor,
		//		in der dritten ist diese Zahl nicht enthalten. [(a, b), (b, c), (d, e)]
		//	Programm:
		//		Überpruefen aller Dreier-Kombinationen auf dieses Kriterium hin.
		//
		cout << " Step 6. + 7." << endl;
		
		// create memory for the result
		int result[3] = {0};
		
		cout << "  >> Reducing differences ..." << endl;
		// reducing differences
		DifferencesReduce(result, differences);
		cout << "  >> Done ...\n" << endl;
		
		
		cout << "  >> Die gesuchten Zahlen sind " << result[1] << " und " << result[2] << ".\n" << endl;

		delete productFirst;
		
		return 0;
	}

