<?php

// Do standard require_onces
require_once('./etc/runtime.conf.php');
require_once(PHPRPG_DIR.'/lib/auth.lib.php');
require_once(PHPRPG_DIR.'/lib/display.lib.php');
require_once(PHPRPG_DIR.'/lib/mysql.lib.php');
require_once(PHPRPG_DIR.'/lib/template.lib.php');

// Check if user has logged in and is an admin
$authObj = new AUTHENTICATE();
$authObj->login(PHPRPG_AUTH_TILE);

// Main logic of the application
switch(@$_REQUEST['submit']) {

default:

	require_once(PHPRPG_DIR.'/lib/tile.lib.php');
	require_once(PHPRPG_DIR.'/lib/admin/tile/tile_editor.php');
	require_once(PHPRPG_DIR.'/lib/context.lib.php');

	exit(drawTileEditor());

case 'Scan':

	require_once(PHPRPG_DIR.'/lib/admin/tile/image_scan.php');

	exit(drawTileScan());

case 'Organize Images':

	require_once(PHPRPG_DIR.'/lib/tile.lib.php');
	require_once(PHPRPG_DIR.'/lib/admin/tile/image_set_editor.php');

	exit(drawImageEditor($_GET['tile-id'],
	                     $_GET['image-id'],
	                     $_GET['old-image-id'],
	                     $_GET['image-set'],
	                     $_GET['action']));

case 'Upload Image':

	require_once(PHPRPG_DIR.'/lib/admin/tile/image_uploader.php');

	exit(drawImageUploader(@$_POST['action']));

case 'Organize Terrain':

	require_once(PHPRPG_DIR.'/lib/admin/tile/terrain_editor.php');
	require_once(PHPRPG_DIR.'/lib/tile.lib.php');
	require_once(PHPRPG_DIR.'/lib/context.lib.php');

	exit(drawTerrainEditor($_GET['terrain-id'],
	                       $_GET['action']));

case 'Edit Attributes':

	require_once(PHPRPG_DIR.'/lib/attributes.lib.php');
	require_once(PHPRPG_DIR.'/lib/admin/tile/attribute_editor.php');

	exit(drawAttributeEditor($_GET['tile-id'],
	                         $_GET['action'],
	                         $_GET['attrib-key'],
	                         $_GET['attrib-value'],
	                         $_GET['attrib-key-old']));

case 'Script Select':

	require_once(PHPRPG_DIR.'/lib/admin/tile/script_selector.php');

	exit(drawScriptSelector($_GET['tile-id'],
	                        $_GET['tile-event'],
	                        $_GET['script-filter-input']));

case 'Add Images':

	// See if $add_entries exists and if so try to add them to database
	if (!empty($_POST['add_entries'])) {
		$dbObj = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		foreach ($_POST['add_entries'] as $value) {
			$tablename = PHPRPG_DB_PREFIX.'_tile_images';
			$query = "INSERT INTO $tablename (TileImagePath) VALUES ('$value')";
			if (!$dbObj->command($query)) die($dbObj->error);
		}
		$dbObj->flush();
	}

	exit(header("location: ".PHPRPG_URL."/tiles.php?submit=Scan"));

case 'Del Images':

	// See if $del_entries exists and if so try to remove them from the database
	if (!empty($_POST['rem_entries'])) {
		$dbObj = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		foreach ($_POST['rem_entries'] as $value) {
			$tablename = PHPRPG_DB_PREFIX.'_tile_images';
			$query = "DELETE FROM $tablename WHERE TileImagePath='$value'";
			if (!$dbObj->command($query)) die($dbObj->error);
		}
		$dbObj->flush();
	}

	exit(header("location: ".PHPRPG_URL."/tiles.php?submit=Scan"));
}


?>