<?php

// Do standard require_onces
require_once('./etc/runtime.conf.php');
require_once(PHPRPG_DIR.'/lib/auth.lib.php');
require_once(PHPRPG_DIR.'/lib/mysql.lib.php');
require_once(PHPRPG_DIR.'/lib/display.lib.php');
require_once(PHPRPG_DIR.'/lib/character.lib.php');
require_once(PHPRPG_DIR.'/lib/user.lib.php');
require_once(PHPRPG_DIR.'/lib/template.lib.php');

// Main logic of the application
switch(@$_REQUEST['submit']) {

case 'activate':

	// Activating an account
	$username = @$_GET['username'];
	$validate = @$_GET['validate'];

	if (isset($username) && isset($validate)) {

		$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		$errObj = new ERROR_REPORTER();

		$tablename = PHPRPG_DB_PREFIX.'_user_pending';
		$query  = "SELECT PendingUser,PendingPass,PendingMail ";
		$query .= "FROM $tablename ";
		$query .= "WHERE PendingUser='$username' AND PendingCode='$validate'";

		if (!$dbObj->query($query)) $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);

		if ($dbObj->result) {
			// Is there a matching pair of username and validation string in the pending table?
			if (mysql_num_rows($dbObj->result) != 0) {

				// Yes -> insert a new row in the main user table
				list($username, $password, $email) = mysql_fetch_row($dbObj->result);

				$userObj = new USER();
				$userObj->name = $username;
				$userObj->pass = $password;
				$userObj->email = $email;
				$userObj->level = PHPRPG_AUTH_NONE;
				$userObj->save();

				// Remove from the pending table
				$tablename = PHPRPG_DB_PREFIX.'_user_pending';
				$query  = "DELETE FROM $tablename ";
				$query .= "WHERE PendingUser='$username'";
				if (!$dbObj->command($query)) $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);

				$MESSAGE = 'Congratulations your account has been activated!';
			}
			else {
				// No -> return error to user
				$MESSAGE  = 'Validation Error: Your account has either been activated or does not exist in our database!<br>';
				$MESSAGE .= 'Please note that accounts not activated within 48 hours are automatically deleted.';
			}
		}
		else $MESSAGE = 'Database Error: ' . mysql_error();
	}
	else $MESSAGE = 'Validation Error: The information you are providing is either incorrect or incomplete!';

	$dbObj->flush();

	// Create and display page
	$page = new TEMPLATE('page');
	$page->define('MESSAGE', $MESSAGE);

	exit($page->build('register_activation'));

case 'validate':

	$username = @$_POST['username'];
	$verify   = @$_POST['verify'];
	$email    = @$_POST['email'];

	$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
	$errObj = new ERROR_REPORTER();

	if (!($username && $password && $verify && $email)) {
		// missing required field
		$error_msg = 'One or more of the required fields are empty.';
	}
	elseif ($password != $verify) {
		// password mismatch
		$error_msg = 'Passwords do not match.';
	}
	elseif (eregi(' ', $password)) {
		// password contained empty space
		$error_msg = 'Passwords cannot contain empty space.';
	}
	elseif (!(eregi('^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*$', $email))) {
		// invalid email
		$error_msg = 'Invalid e-mail!<br><font size="1">A valid e-mail address is required to complete the registration.</font>';
		$email = '*Error';
	}
	elseif (!(eregi('^[a-z0-9]*$', $username))) {
		// invalid username
		$error_msg = 'A username may only contain alpha-numeric characters.';
		$username = '*Error';
	}
	else {
		// no problems with form, so far...
		$dbObj->query("SELECT UserId FROM ".PHPRPG_DB_PREFIX."_users WHERE UserName='$username'");
		$result1 = $dbObj->result;
		$dbObj->query("SELECT PendingId FROM ".PHPRPG_DB_PREFIX."_user_pending WHERE PendingUser='$username'");
		$result2 = $dbObj->result;
		if ((mysql_num_rows($result1) != 0) || (mysql_num_rows($result2) != 0)) {
			// username exists in either main or pending user database
			$error_msg = 'Sorry, the username ' . $username . ' has already been taken!';
			$username = "*$username";
		}
		$dbObj->flush();

		$dbObj->query("SELECT UserId FROM ".PHPRPG_DB_PREFIX."_users WHERE UserMail='$email'");
		$result1 = $dbObj->result;
		$dbObj->query("SELECT PendingId FROM ".PHPRPG_DB_PREFIX."_user_pending WHERE PendingMail='$email'");
		$result2 = $dbObj->result;
		if ((mysql_num_rows($result1) != 0) || (mysql_num_rows($result2) != 0)) {
			// email already exists
			$error_msg = 'An account has already been registered under this e-mail address!';
			$email = "*$email";
		}
		$dbObj->flush();
	}

	if (empty($error_msg)) {
		// Passed validation
		// Generate a random validation string (length of 10 characters)
		$validation_string = '';
		mt_srand((double) microtime() * 100000);
		for ($i = 0; $i < 10; $i++) {
			// ASCII for capital letters range from 65 - 90, digits are from 48 - 57
			$rand_val = mt_rand(65, 100);
			if ($rand_val > 90) {
				// if $rand_val > 90, then 91 would generate digit '0'
				// ... 100 would generate digit '9'
				$rand_val = $rand_val - 91;
				$validation_string .= $rand_val;
			}
			else {
				// generate upper case letter
				$validation_string .= chr($rand_val);
			}
		}

		// Insert user details into pending table
		$user_time = time();
		$tablename = PHPRPG_DB_PREFIX.'_user_pending';
		$query  = "INSERT INTO $tablename (PendingUser, PendingPass, PendingMail, PendingCode, PendingStamp) ";
		$query .= "VALUES ('$username', MD5('$password'), '$email', '$validation_string', $user_time)";
		if (!$dbObj->command("$query")) $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);

		$subject = '[phpRPG] Validation Code';

		$message  = "Greetings $username,\n\n";
		$message .= "We have recently received your application at ".PHPRPG_URL.".\n\n";
		$message .= "To complete the registration, you will have to validate your account through the link below:\n\n";
		$message .= PHPRPG_URL."/register.php?submit=activate&username=$username&validate=$validation_string\n\n";
		$message .= "Once your account has been activated, you can login with:\n";
		$message .= " > username: $username\n";
		$message .= " > password: $password\n\n";
		$message .= "PLEASE NOTE: Accounts not activated in 48 hours are considered unsuccessful and will automatically be deleted.\n\n";
		$message .= "Thank you for registering with phpRPG. I hope you'll enjoy it!!\n\n";
		$message .= "Timothy Chung (aka Axolotl)\n\n";
		$message .= "http://phpRPG.org/\n";
		$message .= "http://sourceforge.net/projects/phprpg/\n\n";

		$headers  = "From: phpRPG Registrar <".PHPRPG_MAIL.">\n";
		$headers .= "X-Sender: phpRPG Registrar <".PHPRPG_MAIL.">\n";
		$headers .= "X-Mailer: PHP " . phpversion() . "\n";
		$headers .= "X-Priority: 1\n";
		$headers .= "Return-Path: phpRPG Registrar <".PHPRPG_MAIL.">\n";

		// Send validation email! ~ how exciting! :)
		mail($email, $subject, $message, $headers);

		// Create and display page
		$page = new TEMPLATE('page');

		exit($page->build('register_receipt'));

	}
	# DO NOT ADD A BREAK, THIS IS SUPPOSED TO FALL THROUGH!!!

default:

	if (empty($email))    $email = "";
	if (empty($username)) $username = "";

	if (empty($error_msg)) $ERROR = "<!-- WHERE ERRORS GO -->";
	else $ERROR  = "<br>Error: $error_msg";

	$FORM_HEADER = '<form action="register.php?submit=validate" method="post" autocomplete="off">';
	$USERNAME  = '<input type="text" name="username" maxlength="20" size="24" value="'.$username.'" class="input">';
	$PASSWORD  = '<input type="password" name="password" maxlength="20" size="24" class="input">';
	$VERIFY    = '<input type="password" name="verify" maxlength="20" size="24" class="input">';
	$EMAIL     = '<input type="text" name="email" maxlength="60" size="24" value="'.$email.'" class="input">';

	// Create and display page
	$page = new TEMPLATE('page');
	$page->define('ERROR',       $ERROR);
	$page->define('USERNAME',    $USERNAME);
	$page->define('PASSWORD',    $PASSWORD);
	$page->define('VERIFY',      $VERIFY);
	$page->define('EMAIL',       $EMAIL);
	$page->define('FORM_HEADER', $FORM_HEADER);

	exit($page->build('register'));
}


?>
