#/bin/sh

# check if they have enough arguments
if [ $# -ne 1 ]
then
	echo "Error: Unable to change group"
	echo "Usage: sh $0 <group of webserver>"
	exit
fi

# Do a mass change of all permissions for the root
chgrp $1   ./share/images -R
chmod 644  ./* -R
chmod 755  ./
chmod 755  ./bin
chmod 755  ./bin/admin
chmod 755  ./bin/admin/character
chmod 755  ./bin/admin/item
chmod 755  ./bin/admin/map
chmod 755  ./bin/admin/script
chmod 755  ./bin/admin/tile
chmod 755  ./doc
chmod 755  ./etc
chmod 755  ./lib
chmod 755  ./lib/admin
chmod 755  ./lib/admin/character
chmod 755  ./lib/admin/item
chmod 755  ./lib/admin/map
chmod 755  ./lib/admin/script
chmod 755  ./lib/admin/tile
chmod 755  ./lib/js
chmod 755  ./setup
chmod 755  ./setup/upgrade
chmod 755  ./share
chmod 755  ./share/images
chmod 755  ./share/images/items
chmod 755  ./share/images/items/icon
chmod 755  ./share/images/items/merg
chmod 755  ./share/images/sprites
chmod 755  ./share/images/sprites/body
chmod 755  ./share/images/sprites/hair
chmod 775  ./share/images/sprites/portrait 
chmod 775  ./share/images/sprites/tail 
chmod 775  ./share/images/sprites/wings 
chmod 755  ./share/images/tiles
chmod 755  ./share/locale
chmod 755  ./share/locale/fr_fr
chmod 755  ./share/locale/fr_fr/LC_MESSAGES
chmod 755  ./share/log
chmod 755  ./share/templates
chmod 755  ./share/templates/phantasy
chmod 755  ./share/templates/phantasy/images
chmod 755  ./share/templates/phantasy/includes

# change group and permission for the log file
chgrp $1   ./share/log/error.log 
chmod 775  ./share/log/error.log 

#change group and permisions of temporary folder
chgrp $1   ./tmp -R
chmod 1775 ./tmp 