<?php

// Do standard require_onces
require_once('./etc/runtime.conf.php');
require_once(PHPRPG_DIR.'/lib/auth.lib.php');
require_once(PHPRPG_DIR.'/lib/display.lib.php');
require_once(PHPRPG_DIR.'/lib/mysql.lib.php');
require_once(PHPRPG_DIR.'/lib/template.lib.php');
require_once(PHPRPG_DIR.'/lib/admin/map/map_editor.php');
require_once(PHPRPG_DIR.'/lib/context.lib.php');

// Check if user has logged in and is an admin
$authObj = new AUTHENTICATE();
$authObj->login(PHPRPG_AUTH_MAP);

// Main logic of the application
switch(@$_REQUEST['submit']) {

default:

	$objChar = new CHARACTER($_SESSION['PHPRPG']['CharId']);
	$mapId = $objChar->loc['map'];
	$display = drawMapEditor($_GET['tile_set']);

	exit($display);

case 'Organize Maps':

	$display = OrganizeMaps(
		$_GET['terrain-id'],
		$_GET['action'],
		$_GET['update_tile_set'],
	 	$_GET['image_set']
	 );

	$page = new TEMPLATE('page');
	$page->define('TITLE',         'PHPRPG - Map Organizer');
	$page->define('DISPLAY',       $display);
	$page->define('HEADER_EXTRAS', '');

	exit($page->build('popup'));

case 'Pick Location':

	$display = drawLocationPicker(
		@$_GET['mapid'],
		@$_GET['locid']
	);

	$page = new TEMPLATE('page');
	$page->define('TITLE',		'PHPRPG - Location Picker');
	$page->define('STYLE',		'');
	$page->define('DISPLAY',	$display);
	$page->define('HEADER_EXTRAS',	'<script src="'.PHPRPG_URL.'/lib/js/loc-pick.js.php" type="text/javascript" language="JavaScript" />
<script type="text/javascript" language="JavaScript" src="'.PHPRPG_URL.'/lib/js/scriptload.js" />');

	exit($page->build('popup'));

}

?>
