<?php

if (!defined('PHPRPG_TIME')) define('PHPRPG_TIME', true);

class CLOCK
{
//PUBLIC:
	function cycle($seconds=false) {
		$seconds = intval($seconds);
		if ($seconds) $this->real_time_seconds = $seconds;
		$this->update();
		$cycle = floor($this->time() / $this->seconds_in_day) + 1;
		return($cycle);
	}

	function secInCycle($seconds=false) {
		$seconds = intval($seconds);
		if ($seconds) $this->real_time_seconds = $seconds;
		$this->update();
		$seconds_into_cycle = $this->time() % ($this->seconds_in_day);
		return($seconds_into_cycle);
	}

	function time($seconds=false) {
		$seconds = intval($seconds);
		if ($seconds) $this->real_time_seconds = $seconds;
		$this->update();
		return($this->game_seconds);
	}

	function date($seconds=false) {

		$seconds = intval($seconds);

		if ($seconds) $this->real_time_seconds = $seconds;
		$this->update();

		$game_hour = floor($this->secInCycle() / $this->seconds_in_hour);
		$game_seconds_into_game_hour = $this->secInCycle() % $this->seconds_in_hour;
		$game_minute = floor($game_seconds_into_game_hour / 60);

		// Prepend a '0' if $game_minute is only one digit
		$minute = trim($game_minute);
		if (strlen($minute) == 1) $minute = '0'.$minute;

		// Determine the period of the day so that an appropriate sundial image can be displayed
		if ($game_hour >= 0 && $game_hour <= 6) $period = 'dawn';
		elseif ($game_hour >= 7 && $game_hour <= 12) $period = 'day';
		elseif ($game_hour >= 13 && $game_hour <= 18) $period = 'dusk';
		elseif ($game_hour >= 19 && $game_hour <= 24) $period = 'night';

		switch ($this->cycle()) {
		case 1:
			$cycle = '1st Cycle';
			break;
		case 2:
			$cycle = '2nd Cycle';
			break;
		case 3:
			$cycle = '3rd Cycle';
			break;
		case 4:
			$cycle = '4th Cycle';
			break;
		default:
			$cycle = 'Invalid Cycle!';
			break;
		}

		$rtn['day']    = $this->game_days;
		$rtn['hour']   = $game_hour;
		$rtn['minute'] = $minute;
		$rtn['cycle']  = $cycle;
		$rtn['period'] = $period;
		return($rtn);
	}

//PRIVATE:
	// internal constants
	var $seconds_in_day;
	var $seconds_in_hour;

	// time of day variables
	var $real_time_seconds;
	var $game_days;
	var $game_seconds;

	function CLOCK($seconds=false) {
		$this->seconds_in_day = (60 * 60 * 24);
		$this->seconds_in_hour = (60 * 60);
		$this->real_time_seconds = $seconds;
	}

	function update() {
		if (!$this->real_time_seconds) $this->real_time_seconds = time();
		$seconds_since_epoch = $this->real_time_seconds - PHPRPG_EPOCH;

		$this->game_days = floor($seconds_since_epoch / $this->seconds_in_day);
		$seconds_into_the_day = $seconds_since_epoch % $this->seconds_in_day;
		$this->game_seconds = $seconds_into_the_day * 4;
	}
}


?>