<?php

if (!defined('PHPRPG_TERRAIN')) define('PHPRPG_TERRAIN', true);

require_once(PHPRPG_DIR.'/lib/action.lib.php');
require_once(PHPRPG_DIR.'/lib/attributes.lib.php');
require_once(PHPRPG_DIR.'/lib/error.lib.php');
require_once(PHPRPG_DIR.'/lib/mysql.lib.php');

define('PHPRPG_PORT_SPACE', 1);
define('PHPRPG_PORT_AIR',   2);
define('PHPRPG_PORT_SEA',   4);

class TERRAIN {
//PUBLIC:
	var $id;
	var $name;
	var $state;
	var $portType;
	var $attribs;
	var $mods;

	var $errors;

	function load($terrainId=0) {

		$terrainId = intval($terrainId);

		if ($terrainId < 1 && $this->id < 1) return(false);
		if ($terrainId < 1 && $this->id > 0) $terrainId = $this->id;

		$this->flush();
		$this->errors = NULL;

		$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		$errObj = new ERROR_REPORTER();

		$table = PHPRPG_DB_PREFIX."_tile_terrain";

		$sql  = "SELECT TerrainId, TerrainName, TerrainState, TerrainPortType ";
		$sql .= "FROM $table ";
		$sql .= "WHERE TerrainId=$terrainId";

		if (!($dbObj->query($sql))) $this->errors[] = $errObj->report(PHPRPG_ERR_CRITICAL, $dbObj->error, __FILE__, __LINE__);
		list($this->id,
		     $this->name,
		     $this->state,
		     $this->portType) = mysql_fetch_row($dbObj->result);
		$dbObj->flush();

		$this->attribs = new ATTRIBUTES($terrainId,PHPRPG_CLASS_TERRAIN);
		$this->spells  = new ACTION($terrainId,    PHPRPG_CLASS_TERRAIN);

		if (empty($this->errors)) return(true);
		return(false);
	}

	function save() {

		$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		$errObj = new ERROR_REPORTER();

		$this->errors = NULL;

		$table = PHPRPG_DB_PREFIX."_tile_terrain";

		if ($this->id > 0) {

			$sql  = "UPDATE $table SET ";
			$sql .= "TerrainName='$this->name',TerrainState='$this->state',";
			$sql .= "TerrainPortType='$this->portType' ";
			$sql .= "WHERE TerrainId=$this->id";

			if (!$dbObj->command($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_CRITICAL, $dbObj->error, __FILE__, __LINE__);
		}
		else {

			$sql  = "INSERT INTO $table ";
			$sql .= "(TerrainName,TerrainState,TerrainPortType)";
			$sql .= " VALUES ";
			$sql .= "('$this->name','$this->state','$this->portType')";

			if (!$dbObj->command($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_CRITICAL, $dbObj->error, __FILE__, __LINE__);

			$this->id = mysql_insert_id();
		}
		if (empty($this->errors)) return(true);
		return(false);
	}

	function delete($terrainId=0) {

		If ($terrainId < 1 && $this->id < 1) return(false);
		if ($terrainId < 1) $terrainId = $this->id;

		$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		$errObj = new ERROR_REPORTER();

		$table = PHPRPG_DB_PREFIX.'_tile_terrain';
		$sql = "DELETE FROM $table WHERE TerrainId='$terrainId'";
		if (!$dbObj->command($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_CRITICAL, $dbObj->error, __FILE__, __LINE__);

		$table = PHPRPG_DB_PREFIX.'_tiles';
		$sql = "UPDATE $table SET TileTerrain='0' WHERE TileTerrain='$terrainId'";
		if (!$dbObj->command($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_CRITICAL, $dbObj->error, __FILE__, __LINE__);

		if (empty($this->errors)) return(true);
		return(false);
	}

	function flush () {
		$this->id = 0;
		$this->name = '';
		$this->state = 0;
		$this->portType = 0;
		$this->attribs = NULL;
		$this->mods = NULL;
	}

	//Does a particular terrain exist?
	function exists($terrainId) {

		if (empty($terrainId)) return(false);

		$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		$errObj = new ERROR_REPORTER();

		$this->errors = NULL;

		$table = PHPRPG_DB_PREFIX.'_tile_terrain';
		$sql = "SELECT TerrainId FROM $table WHERE TerrainId='$terrainId'";
		if (!$dbObj->query($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_CRITICAL, $dbObj->error, __FILE__, __LINE__);
		$row = mysql_fetch_assoc($dbObj->result);
		$dbObj->flush();

		if (empty($this->errors) && !empty($row['TerrainId'])) return(true);
		return(false);
	}

	// Return an array of distinct TerrainNames
	function unique($terrainId=0) {

		$tmp = false;
		$rtn = array();

		$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		$errObj = new ERROR_REPORTER();

		$this->errors = NULL;

		$table = PHPRPG_DB_PREFIX.'_tile_terrain';
		$query = "SELECT DISTINCT TerrainName,TerrainId FROM $table ORDER BY TerrainName ";
		if (!$dbObj->query($query)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);
		if ($row = mysql_fetch_assoc($dbObj->result)) {
			do {
				$id = $row['TerrainId'];
				$name = $row['TerrainName'];
				if ($id > 0) {
					if ($id == $terrainId) $selected = "selected";
					else $selected = "";
					$rtn[] = array('selected'=>$selected, 'name'=>$name, 'value'=>$id);
				}
			}
			while($row = mysql_fetch_assoc($dbObj->result));
		}
		if (empty($this->errors)) return($rtn);
		return(false);
	}

	// Return the first Id for a given Terrain name
	function firstTile($terrainId) {
		$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		$errObj = new ERROR_REPORTER();

		$this->errors = NULL;

		$table = PHPRPG_DB_PREFIX.'_tiles';
		$query = "SELECT TileId FROM $table WHERE TileTerrain='$terrainId' LIMIT 1";
		if (!$dbObj->query($query)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);
		else $row = mysql_fetch_assoc($dbObj->result);
		if (empty($this->errors)) return($row['TileId']);
		return(false);
	}

//PRIVATE:

	function TERRAIN($terrainId=0) {
		$this->flush();
		$terrainId = intval($terrainId);
		if ($terrainId > 0) $this->load($terrainId);
	}
}


?>
