<?php

if (!defined('PHPRPG_TEMPLATE')) define('PHPRPG_TEMPLATE', true);

require_once(PHPRPG_DIR.'/lib/error.lib.php');

class TEMPLATE
{
//PUBLIC:
	// template data
	var $tmpl;
	// container for errors registered by class
	var $errors;

	// define variables into container for use with current instance
	function define($name, $var) {
		if ($this->def_container[$name] = $var) return(true);
		return(false);
	}

	// define functions and vars that will be used with every instace
	function register($name, $object) {
		if ($this->reg_container[$name] = $object) return(true);
		return(false);
	}

	// return parsed template data ready for display
	function build($template='') {

		$this->errors = NULL;

		$errObj = new ERROR_REPORTER();

		if (empty($this->tmpl) && empty($template)) {
			$this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, 'There is no template '.$template.' specified in '.PHPRPG_THEME);
			return(false);
		}
		if (!empty($template)) $this->tmpl = $this->getTemplate(trim($template));

		foreach($this->def_container as $key => $value) {
			if (preg_match('/\$'.$key.'/', $this->tmpl)) $$key = $value;
		}

		foreach($this->reg_container as $key => $value) {
			if (!@$this->def_container[$key] && preg_match('/\$'.$key.'/', $this->tmpl)) {
				if(function_exists($value)) $$key = $value();
				else $$key = $value;
				$this->def_container[$key] = $$key;
			}
		}

		$BASE_URL = PHPRPG_URL;
		$BASE_DIR = PHPRPG_DIR;
		$BASE_IMG = PHPRPG_CORE_IMG;
		$TMPL_IMG = PHPRPG_TMPL_IMG;
		$SELF     = $_SERVER['PHP_SELF'];

		eval("\$rtn=\"$this->tmpl\";");
		return(stripslashes($rtn));
	}

	// free data in template instance
	function flush() {
		$this->def_container = array();
		$this->tmpl = '';
	}

//PRIVATE:
	// containers for registered and defined objects
	var $def_container;
	var $reg_container;
	// what type of template is this?
	var $type;

	// constructor
	function TEMPLATE($type='') {

		$this->type = trim($type);
		$this->def_container = array();
		$this->reg_container = array();
		$this->errors = NULL;

		$errObj = new ERROR_REPORTER();

		if (!empty($this->type)) {
			$local_include = PHPRPG_DIR.'/share/templates/'.PHPRPG_THEME.'/includes/'.$type.'.inc.php';
			if (!file_exists($local_include)) {
				$this->errors[] = $errObj->report(PHPRPG_ERR_WARN, "There is no type '$type' specified in ".PHPRPG_THEME);
				return(NULL);
			}
			include_once($local_include);
		}
	}

	// return template information as a slashed string
	function getTemplate($template) {
		$this->errors = NULL;

		$errObj = new ERROR_REPORTER();

		$template_name = PHPRPG_DIR.'/share/templates/'.PHPRPG_THEME.'/'.$template.'.tpl';
		if (!file_exists($template_name)) {
			$this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, 'There is no template '.$template.' specified in '.PHPRPG_THEME);
			return(false);
		}

		$tmpl = implode('', file($template_name));
		$tmpl = addslashes($tmpl);
		return($tmpl);
	}
}


?>
