<?php

if (!defined('PHPRPG_SCRIPT')) define('PHPRPG_SCRIPT', true);

require_once(PHPRPG_DIR.'/lib/error.lib.php');
require_once(PHPRPG_DIR.'/lib/mysql.lib.php');

class SCRIPT
{
//PUBLIC:
	var $id;
	var $type;
	var $name;
	var $targeted;
	var $content;

	var $errors;

	function load($scriptId=0) {

		$scriptId = intval($scriptId);

		if ($scriptId < 1 && $this->id < 1) return(false);
		if ($scriptId < 1 && $this->id > 0) $scriptId = $this->id;

		$this->flush();

		$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		$errObj = new ERROR_REPORTER();

		$table = PHPRPG_DB_PREFIX.'_scripts';
		$sql  = "SELECT ScriptId,ScriptType,ScriptTargeted,ScriptName,ScriptContent FROM $table WHERE ScriptId=$scriptId";

		if (!$dbObj->query($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);

		list($this->id,
		     $this->type,
		     $this->targeted,
		     $this->name,
		     $content) = mysql_fetch_row($dbObj->result);

		$dbObj->flush();

		$this->content = unserialize(urldecode($content));

		if (empty($this->errors)) return(true);
		return(false);
	}

	function save() {

		$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		$errObj = new ERROR_REPORTER();

		$table = PHPRPG_DB_PREFIX.'_scripts';

		$content = urlencode(serialize($this->content));

		if ($this->id > 0) {

			$sql  = "UPDATE $table SET ";
			$sql .= "ScriptContent='$content',ScriptType='$this->type',ScriptName='$this->name',ScriptTargeted='$this->targeted' WHERE ScriptId='$this->id'";
			if (!$dbObj->command($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);
		}
		else {
			$sql  = "INSERT INTO $table ";
			$sql .= "( ScriptType,ScriptName,ScriptTargeted,ScriptContent )";
			$sql .= " VALUES ";
			$sql .= "( '$this->type','$this->name','$this->targeted','$content' )";
			if (!$dbObj->command($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);

			$this->id = mysql_insert_id();
		}
		if (empty($this->errors)) return(true);
		return(false);
	}

	function delete($id = 0) {

		if ($this->id > 0 && $id < 1) $id = $this->id;

		if ($id > 0) {
			$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
			$errObj = new ERROR_REPORTER();

			$table = PHPRPG_DB_PREFIX.'_scripts';
			$sql = "DELETE FROM $table WHERE ScriptId='$id'";
			if (!$dbObj->command($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);
			return(true);
		}
		if (empty($this->errors)) return(true);
		return(false);
	}

	function flush() {
		$this->id = 0;
		$this->type = 0;
		$this->name = '';
		$this->targeted = false;
		$this->content = '';
		$this->errors = NULL;
	}

	//Does a particular script exist?
	function exists($scriptName) {

		$scriptName = trim($scriptName);

		$rtn = NULL;

		$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		$errObj = new ERROR_REPORTER();

		$table = PHPRPG_DB_PREFIX.'_scripts';
		$sql = "SELECT ScriptId FROM $table WHERE ScriptName='$scriptName' LIMIT 1";
		if (!$dbObj->query($sql)) $this->errors[] = $errObj->report(PHPRPG_CRIT_ERROR, $dbObj->error, __FILE__, __LINE__);
		$rtn = mysql_fetch_assoc($dbObj->result);
		$dbObj->flush();

		if (!empty($rtn['ScriptId'])) return(true);
		return(false);
	}

//PRIVATE:
	function SCRIPT($scriptId=0) {
		$this->flush();
		$this->id = intval($scriptId);
		if (!empty($this->id)) $this->load($this->id);
	}
}


?>