<?php
// Do standard require_onces
require_once('../../etc/runtime.conf.php');
require_once(PHPRPG_DIR.'/lib/auth.lib.php');

// Check if user has logged in and is an admin
$authObj = new AUTHENTICATE();
$authObj->login(PHPRPG_AUTH_TILE);

?>

var iTile = -1;
var iTerrain = -1;
var iImage = -1;
var sImageSet = '';
var iDataState = 0;

function setImage(iImageId) { iImage = iImageId; }
function setImageSet(sImageSetName) { sImageSet = sImageSetName; }
function setTile(iTileId) { iTile = iTileId; }
function setTerrain(iTerrainId) { iTerrain = iTerrainId; }

function changeForm() { iDataState = 1; }
function resetForm() { iDataState = 0; }

function checkForm(needId) {
	if (iDataState) {
		if (!confirm('Are you sure? You could lose any unsaved data!')) return(false);
		resetForm();
	}
	else {
		if (iTile <= 0 && needId) {
			alert("Please select a tile!");
			return(false);
		}
	}
	return(true);
}

function doPopup(url,name,x,y,bars) {
	var winArgs = "menubar=0,toolbar=0,resizable=1,statusbar=0,scrollbars="+bars+",width="+x+",height="+y;
	childWindow = window.open(url,name,winArgs);
}

function attribDelete(sKey) {
	if (checkForm(true)) loadScript("<?php echo PHPRPG_URL ?>/bin/admin/tile/delete-attribute.js.php?tile-id="+iTile+"&key="+sKey);
}

function attribFilter() {
	oFilter = document.getElementById("attrib-filter-input");
	if (checkForm(true)) loadScript("<?php echo PHPRPG_URL ?>/bin/admin/tile/gen-attrib-list.js.php?tile-id="+iTile+"&filter="+oFilter.value);
}

function attribModify(sKey) {
	if (checkForm(true)) doPopup('<?php echo PHPRPG_URL ?>/tiles.php?submit=Edit+Attributes&tile-id='+iTile+'&attrib-key='+sKey,'Item_Search',450,350,1);
}

function setTileEvent(iScriptId, iEventType) {
	loadScript("<?php echo PHPRPG_URL ?>/bin/admin/tile/save-event.js.php?tile-id="+iTile+"&script-id="+iScriptId+"&script-type="+iEventType);
}

function delTileEvent(iEventType) {
	loadScript("<?php echo PHPRPG_URL ?>/bin/admin/tile/save-event.js.php?tile-id="+iTile+"&script-id=0&script-type="+iEventType);
}

function editorSelect() {

	oToolBox = document.getElementById("tool-box");

	for(i=0;i<oToolBox.childNodes.length;i++) {
		if(oToolBox.childNodes[i].className == "editor") {
			oToolBox.childNodes[i].style.display = "none";
		}
	}

	oEditorSelect = document.getElementById('tile-editor-select');

	switch (oEditorSelect.selectedIndex) {
	default:
		return(true);
	case 1:
		loadScript("<?php echo PHPRPG_URL ?>/bin/admin/tile/gen-image-list.js.php?image-set="+sImageSet);
		editor = "image";
		break;
	case 2:
		loadScript("<?php echo PHPRPG_URL ?>/bin/admin/tile/gen-event-list.js.php?tile-id="+iTile);
		editor = "event";
		break;
	case 3:
		loadScript("<?php echo PHPRPG_URL ?>/bin/admin/tile/gen-attrib-list.js.php?tile-id="+iTile);
		editor = "attrib";
		break;
	}

	oTool = document.getElementById("tile-editor-"+editor);

	oTool.style.display = "block";
}

function newTile() {
	loadScript("<?php echo PHPRPG_URL ?>/bin/admin/tile/new-tile.js.php?terrain-id="+iTerrain);
}

function deleteTile() {
	if (!iTile) return(false);
	loadScript("<?php echo PHPRPG_URL ?>/bin/admin/tile/delete-tile.js.php?tile-id="+iTile+"&terrain-id="+iTerrain);
}

function saveTile(saveAs) {

	if (iTile < 0) return(false);

	resetForm();

	oTileDNCost = document.getElementById("tile-dn-cost");
	if (oTileDNCost) iTileDNCost = oTileDNCost.value;
	else iTileDNCost = '';

	oTileNECost = document.getElementById("tile-ne-cost");
	if (oTileNECost) iTileNECost = oTileNECost.value;
	else iTileNECost = '';

	oTileDECost = document.getElementById("tile-de-cost");
	if (oTileDECost) iTileDECost = oTileDECost.value;
	else iTileDECost = '';

	oTileSECost = document.getElementById("tile-se-cost");
	if (oTileSECost) iTileSECost = oTileSECost.value;
	else iTileSECost = '';

	oTileDSCost = document.getElementById("tile-ds-cost");
	if (oTileDSCost) iTileDSCost = oTileDSCost.value;
	else iTileDSCost = '';

	oTileSWCost = document.getElementById("tile-sw-cost");
	if (oTileSWCost) iTileSWCost = oTileSWCost.value;
	else iTileSWCost = '';

	oTileDWCost = document.getElementById("tile-dw-cost");
	if (oTileDWCost) iTileDWCost = oTileDWCost.value;
	else iTileDWCost = '';

	oTileNWCost = document.getElementById("tile-nw-cost");
	if (oTileNWCost) iTileNWCost = oTileNWCost.value;
	else iTileNWCost = '';

	oTileDUCost = document.getElementById("tile-du-cost");
	if (oTileDUCost) iTileDUCost = oTileDUCost.value;
	else iTileDUCost = '';

	oTileDDCost = document.getElementById("tile-dd-cost");
	if (oTileDDCost) iTileDDCost = oTileDDCost.value;
	else iTileDDCost = '';

	oTileName = document.getElementById("tile-name-input");
	if (oTileName) iTileName = oTileName.value;
	else iTileName = '';

	oTileTerrain = document.getElementById("tile-terrain-select");
	if (oTileTerrain) iTileTerrain = oTileTerrain.options[oTileTerrain.selectedIndex].value;
	else iTileTerrain = 0;

	oTileOverride = document.getElementById("tile-override-checkbox");
	if (oTileOverride.checked) iTileOverride = 1;
	else iTileOverride = 0;

	if (saveAs == true) saveAs = 1;
	else saveAs = 0;

	params  = "tile-id="+iTile+"&terrain-id="+iTileTerrain+"&tile-name="+iTileName+"&tile-terrain_id="+iTileTerrain+"&tile-override="+iTileOverride;
	params += "&tile-dn-cost="+iTileDNCost+"&tile-ne-cost="+iTileNECost+"&tile-de-cost="+iTileDECost+"&tile-se-cost="+iTileSECost;
	params += "&tile-ds-cost="+iTileDSCost+"&tile-sw-cost="+iTileSWCost+"&tile-dw-cost="+iTileDWCost+"&tile-nw-cost="+iTileNWCost;
	params += "&tile-du-cost="+iTileDUCost+"&tile-dd-cost="+iTileDDCost+"&terrain-save-as="+saveAs;

	loadScript("<?php echo PHPRPG_URL ?>/bin/admin/tile/save-tile.js.php?"+params);

}

function clearTile() {
	oTileImage = document.getElementById('tile-display-image');
	oTileImage.src = '<?php echo PHPRPG_URL ?>/share/images/default_tile.png';
	oTileDNCost = document.getElementById('tile-dn-cost');
	oTileDNCost.value = '';
	oTileNECost = document.getElementById('tile-ne-cost');
	oTileNECost.value = '';
	oTileDECost = document.getElementById('tile-de-cost');
	oTileDECost.value = '';
	oTileSECost = document.getElementById('tile-se-cost');
	oTileSECost.value = '';
	oTileDSCost = document.getElementById('tile-ds-cost');
	oTileDSCost.value = '';
	oTileSWCost = document.getElementById('tile-sw-cost');
	oTileSWCost.value = '';
	oTileDWCost = document.getElementById('tile-dw-cost');
	oTileDWCost.value = '';
	oTileNWCost = document.getElementById('tile-nw-cost');
	oTileNWCost.value = '';
	oTileName = document.getElementById('tile-name-input');
	oTileName.value = '';
	oTileOverride = document.getElementById('tile-override-checkbox');
	oTileOverride.checked = false;
	oTileTerrain = document.getElementById('tile-terrain-select');
	oTileTerrain.options.length = 1;
	oTileTerrain.selectedIndex = 0;
}

function clearTilePalette() {
	oTileset = document.getElementById("tile-palette");
	while (oTileset.hasChildNodes()) oTileset.removeChild(oTileset.lastChild);
	setTile(-1);
}

function clearImagePalette() {
	oTileset = document.getElementById("image-palette");
	while (oTileset.hasChildNodes()) oTileset.removeChild(oTileset.lastChild);
}

function showTiles() {
	oTerrain = document.getElementById('terrain-select');
	iTerrainId = oTerrain.options[oTerrain.selectedIndex].value;
	if (iTerrain != iTerrainId) {
		setTerrain(iTerrainId);
		setTile(-1);
	}
	loadScript("<?php echo PHPRPG_URL ?>/bin/admin/tile/load-terrain.js.php?terrain-id="+iTerrain+"&tile-id="+iTile);
	editorSelect();
}

function showImages() {
	oSelect = document.getElementById("image-set-select");
	sImageSet = oSelect.options[oSelect.selectedIndex].value;
	loadScript("<?php echo PHPRPG_URL ?>/bin/admin/tile/load-image-set.js.php?image-set="+sImageSet);
}

function selectTile(iTileId) {
	if (checkForm()) {
		resetForm();
		oPalette = document.getElementById("tile-palette");
		aImages = oPalette.getElementsByTagName("IMG");
		for(i=0; i<aImages.length; i++) {
			aImages[i].className = 'unseltile';
		}
		setTile(iTileId);
		oImage = document.getElementById("tile-"+iTile);
		if (oImage) oImage.className = 'seltile';
		loadScript("<?php echo PHPRPG_URL ?>/bin/admin/tile/load-tile.js.php?tile-id="+iTile);
		editorSelect();
	}
}

function selectImage(iImageId) {
	if (checkForm()) {
		resetForm();
		if (!iTile) return(false);
		oPalette = document.getElementById("image-palette");
		aImages = oPalette.getElementsByTagName("IMG");
		for(i=0; i<aImages.length; i++) {
			aImages[i].className = 'tile-images';
		}
		setImage(iImageId);
		loadScript("<?php echo PHPRPG_URL ?>/bin/admin/tile/swap-tile-image.js.php?tile-id="+iTile+"&image-id="+iImage);
	}
}

function addTileToPalette(id, imgpath) {
	oTileset = document.getElementById("tile-palette");
	oTile = document.createElement("IMG");
	oTile.setAttribute("id", "tile-"+id);
	oTile.setAttribute("name", "tile");
	oTile.setAttribute("src", "<?php echo PHPRPG_URL ?>"+imgpath);
	oTile.className = "unseltile";
	oTile.onclick = function(){ selectTile(id); };
	oTileset.appendChild(oTile);
}

function addImageToPalette(id, imgpath) {
	oTileset = document.getElementById("image-palette");
	oTile = document.createElement("IMG");
	oTile.setAttribute("id", "image-"+id);
	oTile.setAttribute("name", "tile");
	oTile.setAttribute("src", "<?php echo PHPRPG_URL ?>"+imgpath);
	oTile.className = "tile-images";
	oTile.onclick = function(){ selectImage(id); };
	oTileset.appendChild(oTile);
}

function loadPage() {
	loadScript("<?php echo PHPRPG_URL ?>/bin/admin/tile/gen-terrain-list.js.php?terrain-id="+iTerrain);
	editorSelect();
}

window.onload = function() { loadPage(); }
