<?php
require_once('../../etc/runtime.conf.php');
require_once(PHPRPG_DIR.'/lib/auth.lib.php');
$trans_img_url = PHPRPG_URL.'/share/images/mask_trans.png';

$objAuth = new AUTHENTICATE();
if ($objAuth->levelCheck(PHPRPG_AUTH_MAP)) {
	$admin = intval(@$_REQUEST['admin']);
} else {
	$admin = 0;
}
?>
var mapWidth = <?php echo PHPRPG_PICK_WIDTH;?>;
var mapHeight = <?php echo PHPRPG_PICK_HEIGHT;?>;

window.onload = loadMap;

function move(x,y,z) {
	loadScript("<?php echo PHPRPG_URL;?>/bin/admin/map/loc-pick-move.js.php?x="+x+"&y="+y+"&z="+z);
}

function refreshMap() {
	target = "/bin/admin/map/loc-pick-refresh-locs.js.php";
	loadScript("<?php echo PHPRPG_URL;?>"+target);
}

function updateLoc(x, y, priImage, altImage, maskImage) {
	maskTruePath = '/share/images/mask_success.png';
	if (oCell = document.getElementById(x+"|"+y)) {
		if (oImage = oCell.getElementsByTagName("IMG")[0])
			oImage.src = "<?php echo PHPRPG_URL;?>"+priImage;
		if (oImage = oCell.getElementsByTagName("IMG")[1])
			oImage.src = "<?php echo PHPRPG_URL;?>"+altImage;
		if (oImage = oCell.getElementsByTagName("IMG")[2])
			oImage.src = "<?php echo PHPRPG_URL;?>"+maskImage
	}
}

function loadMap() {
	oSelect = document.getElementById("map-select");
	target = "/bin/admin/map/loc-pick-load-map.js.php?id="+oSelect.options[oSelect.selectedIndex].value;
	loadScript("<?php echo PHPRPG_URL;?>"+target);
}

function defineLocation(oCell) {
	aCoords = oCell.id.match(/(.*)\|(.*)/);
	x = aCoords[1];
	y = aCoords[2];
	z = 0;
	oSelect = document.getElementById("map-select");
	window.opener.setLinkDest(oSelect.options[oSelect.selectedIndex].value, x, y, z);
	window.close();
}

function wrapCoord(n, size) {
	n = (n + size) % size;
	while(n < 0 && size > 0) n += size;
	return n;
}

// locX and locY should be the users current coordinates as provided from the server
function rebuildMap(locX, locY, sizeX, sizeY, wrapX, wrapY) {
	oMap = document.getElementById("map-table");
	aBody = oMap.getElementsByTagName("tbody");
	if (aBody.length > 0) {
		oMap = aBody[0];
	}
	aRows = oMap.getElementsByTagName("tr");
	for(dy=-mapHeight; dy<=mapHeight; dy++) {
		oRow = aRows[(dy+mapHeight)];
		aCells = oRow.getElementsByTagName("td");
		aCells = oRow.getElementsByTagName("td");
		for(dx=-mapWidth; dx<=mapWidth; dx++) {
			coordX = locX+dx;
			coordY = locY+dy;
			if (wrapX) coordX = wrapCoord(coordX, sizeX);
			if (wrapY) coordY = wrapCoord(coordY, sizeY);
			oCell = aCells[(dx+mapWidth)];
			oCell.setAttribute("id", (coordX)+"|"+(coordY));
			oImage = oCell.getElementsByTagName("img")[0];
			oImage.setAttribute("alt", "("+(coordX)+","+(coordY)+")");
		}
	}
	refreshMap();
}
