<?php
// Do standard require_onces
require_once('../../etc/runtime.conf.php');
require_once(PHPRPG_DIR.'/lib/auth.lib.php');

// Check if user has logged in and is an admin
$authObj = new AUTHENTICATE();
$authObj->login(PHPRPG_AUTH_ITEM);

?>

var iItem = 0;
var sImageType = 'icon';
var sImageSetIcon = '';
var sImageSetMerg = '';
var sEditor = '';
var iDataState = 0;

function setItem(item)      { iItem = item; }
function setImageType(type) { sImageType = type; }
function setEditor(editor)  { sEditor = editor; }

function setImageSet(set, type) {
	if (type == "icon") sImageSetIcon = set;
	else sImageSetMerg = set;
}

function changeForm() { iDataState = 1; }
function resetForm()  { iDataState = 0; }

function checkForm(needId) {
	if (iDataState) {
		if (!confirm('Are you sure? You could lose any unsaved data!')) return(false);
	}
	else {
		if (iItem <= 0 && needId) {
			alert("Please select an item!");
			return(false);
		}
	}
	return(true);
}

function doPopup(url,name,x,y,bars) {
	var winArgs = 'menubar=0,toolbar=0,resizable=1,statusbar=0,scrollbars='+bars+',width='+x+',height='+y;
	childWindow = window.open(url,name,winArgs);
}

function attribDelete(sKey) {
	if (checkForm(true)) loadScript("<?php echo PHPRPG_URL ?>/bin/admin/item/delete-attribute.js.php?item-id="+iItem+"&item-key="+sKey);
}

function attribFilter() {
	sFilter = document.getElementById("attrib-filter-input");
	if (checkForm(true)) loadScript("<?php echo PHPRPG_URL ?>/bin/admin/item/gen-attrib-list.js.php?item-id="+iItem+"&filter="+sFilter.value);
}

function attribModify(sKey) {
	if (checkForm(true)) doPopup('<?php echo PHPRPG_URL ?>/items.php?submit=Edit+Attributes&item-id='+iItem+'&attrib-key='+sKey,'Item_Search',450,350,1);
}

function setItemEvent(iId, sType) {
	loadScript("<?php echo PHPRPG_URL ?>/bin/admin/item/save-event.js.php?item-id="+iItem+"&script-id="+iId+"&script-type="+sType);
	loadScript("<?php echo PHPRPG_URL ?>/bin/admin/item/gen-event-list.js.php?item-id="+iItem);
}

function delItemEvent(iId, sType) {
	loadScript("<?php echo PHPRPG_URL ?>/bin/admin/item/delete-event.js.php?item-id="+iItem+"&script-type="+sType);
	loadScript("<?php echo PHPRPG_URL ?>/bin/admin/item/gen-event-list.js.php?item-id="+iItem);
}

function editorSelect(sEditorSelect) {

	setEditor(sEditorSelect);

	oEquipLoc = document.getElementById("item-equip-location");
	if (oEquipLoc.selectedIndex < 1 && sEditor == 'merg' && iItem > 0) {
		alert("The Item is unequipable");
		sEditor = 'icon';
	}

	oToolBox = document.getElementById("tool-box");
	for(i=0;i<oToolBox.childNodes.length;i++) {
		if(oToolBox.childNodes[i].className == "editor") {
			oToolBox.childNodes[i].style.display = "none";
		}
	}

	switch (sEditorSelect) {
	default:
		sImageType = 'icon';
		return;
	case "icon":

		setImageType(sEditor);
		sEditorSelect = "images";

		oImageType = document.getElementById('image-type-merg');
		oImageType.checked = false;
		oImageType = document.getElementById('image-type-icon');
		oImageType.checked = true;

		loadScript("<?php echo PHPRPG_URL ?>/bin/admin/item/gen-icon-images.js.php?image-set="+sImageSetIcon);
		loadScript("<?php echo PHPRPG_URL ?>/bin/admin/item/load-item.js.php?item-id="+iItem+"&image-type="+sImageType);
		break;
	case "merg":

		setImageType(sEditor);
		sEditorSelect = "images";

		oImageType = document.getElementById('image-type-merg');
		oImageType.checked = true;
		oImageType = document.getElementById('image-type-icon');
		oImageType.checked = false;

		loadScript("<?php echo PHPRPG_URL ?>/bin/admin/item/gen-merg-images.js.php?image-set="+sImageSetMerg);
		loadScript("<?php echo PHPRPG_URL ?>/bin/admin/item/load-item.js.php?item-id="+iItem+"&image-type="+sImageType);
		break;
	case "event":
		if (!checkForm(true)) {
			oEditorSelect = document.getElementById('item-editor-select');
			oEditorSelect.selectedIndex = 0;
			sEditor = '';
			return;
		}
		loadScript("<?php echo PHPRPG_URL ?>/bin/admin/item/gen-event-list.js.php?item-id="+iItem);
		break;
	case "attrib":
		if (!checkForm(true)) {
			oEditorSelect = document.getElementById('item-editor-select');
			oEditorSelect.selectedIndex = 0;
			sEditor = '';
			return;
		}
		loadScript("<?php echo PHPRPG_URL ?>/bin/admin/item/gen-attrib-list.js.php?item-id="+iItem);
		break;
	}

	oTool = document.getElementById("item-editor-"+sEditorSelect);
	oTool.style.display = "block";
}

function searchItems() {
	sItemSearch = document.getElementById("item-search-input");
	if (checkForm()) {
		doPopup('<?php echo PHPRPG_URL ?>/items.php?submit=Search&query-string='+sItemSearch.value,'Item_Search',450,350,1);
	}
}

function deleteItem() {
	if (checkForm(true) && !confirm("Do you want to delete this item and all items of this type in the game universe?")) {
		return(false);
	}
	loadScript("<?php echo PHPRPG_URL ?>/bin/admin/item/delete-items.js.php?item-id="+iItem);
}

function saveItem(saveAs) {

	resetForm();

	oItemName = document.getElementById('item-name-input');
	if (oItemName) sItemName = oItemName.value;
	else sItemName = '';

	oItemTwoHanded = document.getElementById('item-two-handed-check');
	if (oItemTwoHanded.checked) iItemTwoHanded = 1;
	else iItemTwoHanded = 0;

	oItemStackable = document.getElementById('item-stackable-check');
	if (oItemStackable.checked) iItemStackable = 1;
	else iItemStackable = 0;

	oItemEquipLocation = document.getElementById('item-equip-location');
	if (oItemEquipLocation) iItemEquipLocation = oItemEquipLocation.selectedIndex;
	else iItemEquipLocation = 0;

	oItemSize = document.getElementById('item-size-select');
	if (oItemSize) iItemSize = oItemSize.selectedIndex;
	else iItemSize = 0;

	oItemWeight = document.getElementById('item-weight-input');
	if (oItemWeight) iItemWeight = oItemWeight.value;
	else iItemWeight = '';

	oItemValue = document.getElementById('item-value-input');
	if (oItemValue) iItemValue = oItemValue.value;
	else iItemValue = '';

	oItemDmgMin = document.getElementById('item-dmgmin-input');
	if (oItemDmgMin) iItemDmgMin = oItemDmgMin.value;
	else iItemDmgMin = '';

	oItemDmgMax = document.getElementById('item-dmgmax-input');
	if (oItemDmgMax) iItemDmgMax = oItemDmgMax.value;
	else iItemDmgMax = '';

	oItemDmgAdj = document.getElementById('item-dmgadj-input');
	if (oItemDmgAdj) iItemDmgAdj = oItemDmgAdj.value;
	else iItemDmgAdj = '';

	oItemMaxCC = document.getElementById('item-max-cc-input');
	if (oItemMaxCC) iItemMaxCC = oItemMaxCC.value;
	else iItemMaxCC = '';

	oItemMaxSlots = document.getElementById('item-max-slots-input');
	if (oItemMaxSlots) iItemMaxSlots = oItemMaxSlots.value;
	else iItemMaxSlots = '';

	oItemMaxAR = document.getElementById('item-armor-rate-input');
	if (oItemMaxAR) iItemMaxAR = oItemMaxAR.value;
	else iItemMaxAR = '';

	oItemMaxHP = document.getElementById('item-hit-point-input');
	if (oItemMaxHP) iItemMaxHP = oItemMaxHP.value;
	else iItemMaxHP = '';

	if (saveAs == true) saveAs = 1;
	else saveAs = 0;

	params  = "item-id="+iItem+"&item-name="+sItemName+"&item-two-handed="+iItemTwoHanded+"&item-stackable="+iItemStackable+"&item-equip-location="+iItemEquipLocation;
	params += "&item-size="+iItemSize+"&item-weight="+iItemWeight+"&item-value="+iItemValue+"&item-dmg-min="+iItemDmgMin;
	params += "&item-dmg-max="+iItemDmgMax+"&item-dmg-adj="+iItemDmgAdj+"&item-max-cc="+iItemMaxCC+"&item-max-slots="+iItemMaxSlots;
	params += "&item-ar="+iItemMaxAR+"&item-hp="+iItemMaxHP+"&item-save-as="+saveAs;

	loadScript("<?php echo PHPRPG_URL ?>/bin/admin/item/save-item.js.php?"+params);
}

function clearItem() {
	resetForm();
	setItem(-1);

	oItemImage = document.getElementById('item-image-pallete');
	oItemImage.src = '<?php echo PHPRPG_URL ?>/share/images/default_item_icon.png';
	oItemTwoHanded = document.getElementById('item-two-handed-check');
	oItemTwoHanded.checked = false;
	oItemStackable = document.getElementById('item-stackable-check');
	oItemStackable.checked = false;
	oItemName = document.getElementById('item-name-input');
	oItemName.value = '';
	oItemEquipLocation = document.getElementById('item-equip-location');
	oItemEquipLocation.selectedIndex = 0;
	oItemSizeSelect = document.getElementById('item-size-select');
	oItemSizeSelect.selectedIndex = 3;
	oItemWeight = document.getElementById('item-weight-input');
	oItemWeight.value = '';
	oItemValue = document.getElementById('item-value-input');
	oItemValue.value = '';
	oItemDmgMin = document.getElementById('item-dmgmin-input');
	oItemDmgMin.value = '';
	oItemDmgMax = document.getElementById('item-dmgmax-input');
	oItemDmgMax.value = '';
	oItemDmgAdj = document.getElementById('item-dmgadj-input');
	oItemDmgAdj.value = '';
	oItemMaxCC = document.getElementById('item-max-cc-input');
	oItemMaxCC.value = '';
	oItemMaxSlots = document.getElementById('item-max-slots-input');
	oItemMaxSlots.value = '';
	oItemMaxAR = document.getElementById('item-armor-rate-input');
	oItemMaxAR.value = '';
	oItemMaxHP = document.getElementById('item-hit-point-input');
	oItemMaxHP.value = '';
}

function clearImagePalette() {
	oItemset = document.getElementById("image-palette");
	while (oItemset.hasChildNodes()) oItemset.removeChild(oItemset.lastChild);
	iSelectedItem = -1;
}

function showImages(oSelect) {
	setImageSet(oSelect.options[oSelect.selectedIndex].value, sImageType);
	if (sImageType == "icon") sImageSet = sImageSetIcon;
	else sImageSet = sImageSetMerg;
	loadScript("<?php echo PHPRPG_URL ?>/bin/admin/item/load-image-set.js.php?image-set="+sImageSet+"&image-type="+sImageType);
}

function scanImages() {
	if (sImageType == "icon") sTag = "Scan+Icon";
	else sTag = "Scan+Merg";
	if (checkForm()) doPopup("<?php echo PHPRPG_URL ?>/items.php?submit="+sTag,"Scan_Images",500,350,1);
}

function uploadImages() {
	if (sImageType == "icon") sTag = "Upload+Image+Icon";
	else sTag = "Upload+Image+Merg";
	if (checkForm()) doPopup('<?php echo PHPRPG_URL ?>/items.php?submit='+sTag,'Image_Uploader',500,175,1);
}

function editImageSet() {
	if (sImageType == "icon") sTag = "Organize+Images+Icon";
	else sTag = "Organize+Images+Merg";

	if (sImageType == "icon") sImageSet = sImageSetIcon;
	else sImageSet = sImageSetMerg;

	url = "<?php echo PHPRPG_URL ?>/items.php?submit="+sTag+"&item-id="+iItem+"&image-set="+sImageSet+"&old-image-set="+sImageSet;
	if (checkForm()) doPopup(url,'Organize_Image_Sets',525,350,1);
}

function selectImage(iImage) {
	if (checkForm(true)) {
		resetForm();
		loadScript("<?php echo PHPRPG_URL ?>/bin/admin/item/swap-item-image.js.php?item-id="+iItem+"&image-id="+iImage);
	}
}

function addImageToPalette(id, imgpath) {
	oItemset = document.getElementById("image-palette");
	oItem = document.createElement("IMG");
	oItem.setAttribute("id", "image-"+id);
	oItem.setAttribute("name", "item");
	oItem.setAttribute("src", "<?php echo PHPRPG_URL ?>"+imgpath);
	oItem.className = "item-images";
	oItem.onclick = function(){ selectImage(id); };
	oItemset.appendChild(oItem);
}

function loadPage() {
	loadScript("<?php echo PHPRPG_URL ?>/bin/admin/item/load-item.js.php?item-id="+iItem+"&image-type="+sImageType);
	editorSelect(sEditor);
}

window.onload = function() { loadPage(); }