<?php
// Do standard require_onces
require_once('../../etc/runtime.conf.php');
require_once(PHPRPG_DIR.'/lib/auth.lib.php');

// Check if user has logged in and is an admin
$authObj = new AUTHENTICATE();
$authObj->login(PHPRPG_AUTH_CHAR);

?>

var iChar = 0;
var iUser = 0;
var sImageType = 'body';
var sImageSetPortrait = '';
var sImageSetBody = '';
var sImageSetHair = '';
var sImageSetWings = '';
var sImageSetTail = '';
var sEditor = '';
var iDataState = 0;

function setChar(character) { iChar = character; }
function setUser(user)      { iUser = user; }
function setImageType(type) { sImageType = type; }
function setEditor(editor)  { sEditor = editor; }

function setImageSet(set, type) {
	switch(type) {
	case 'portrait': sImageSetPortrait = set; break;
	case 'body'    : sImageSetBody     = set; break;
	case 'hair'    : sImageSetHair     = set; break;
	case 'wings'   : sImageSetWings    = set; break;
	case 'tail'    : sImageSetTail     = set; break;
	}
}


function formChange() { iDataState = 1; }
function resetForm()  { iDataState = 0; }

function checkForm(needId) {
	if (iDataState) {
		if (!confirm('Are you sure? You could lose any unsaved data!')) return(false);
	}
	else {
		if (iChar <= 0 && needId) {
			alert("Please select an character first!");
			return(false);
		}
	}
	return(true);
}

function doPopup(url,name,x,y,bars) {
	var winArgs = 'menubar=0,toolbar=0,resizable=1,statusbar=0,scrollbars='+bars+',width='+x+',height='+y;
	childWindow = window.open(url,name,winArgs);
}

function attribDelete(sKey) {
	if (checkForm(true)) loadScript("<?php echo PHPRPG_URL ?>/bin/admin/character/delete-attribute.js.php?char-id="+iChar+"&attrib-key="+sKey);
}

function attribFilter() {
	sFilter = document.getElementById("attrib-filter-input");
	if (checkForm(true)) loadScript("<?php echo PHPRPG_URL ?>/bin/admin/character/gen-attrib-list.js.php?char-id="+iChar+"&filter="+sFilter.value);
}

function attribModify(sKey) {
	if (checkForm(true)) doPopup('<?php echo PHPRPG_URL ?>/characters.php?submit=Edit+Attributes&char-id='+iChar+'&attrib-key='+sKey,'Attribute_Editor',450,350,1);
}

function editorSelect(sEditorSelected) {

	setEditor(sEditorSelected);

	oToolBox = document.getElementById("tool-box");
	for(i=0;i<oToolBox.childNodes.length;i++) {
		if(oToolBox.childNodes[i].className == "editor") {
			oToolBox.childNodes[i].style.display = "none";
		}
	}

	switch (sEditorSelected) {
	default:
		sImageType = 'body';
		return(true);
	case "body":
		sImageType = sEditorSelected;
		sEditorSelected = "sprite";

		oImageType = document.getElementById('image-type-body');
		oImageType.checked = true;
		oImageType = document.getElementById('image-type-hair');
		oImageType.checked = false;
		oImageType = document.getElementById('image-type-wings');
		oImageType.checked = false;
		oImageType = document.getElementById('image-type-tail');
		oImageType.checked = false;

		loadScript("<?php echo PHPRPG_URL ?>/bin/admin/character/load-image-set.js.php?image-set="+sImageSetBody+"&image-type="+sImageType);
		break;
	case "hair":
		sImageType = sEditorSelected;
		sEditorSelected = "sprite";

		oImageType = document.getElementById('image-type-body');
		oImageType.checked = false;
		oImageType = document.getElementById('image-type-hair');
		oImageType.checked = true;
		oImageType = document.getElementById('image-type-wings');
		oImageType.checked = false;
		oImageType = document.getElementById('image-type-tail');
		oImageType.checked = false;

		loadScript("<?php echo PHPRPG_URL ?>/bin/admin/character/load-image-set.js.php?image-set="+sImageSetHair+"&image-type="+sImageType);
		break;
	case "wings":
		sImageType = sEditorSelected;
		sEditorSelected = "sprite";

		oImageType = document.getElementById('image-type-body');
		oImageType.checked = false;
		oImageType = document.getElementById('image-type-hair');
		oImageType.checked = false;
		oImageType = document.getElementById('image-type-wings');
		oImageType.checked = true;
		oImageType = document.getElementById('image-type-tail');
		oImageType.checked = false;

		loadScript("<?php echo PHPRPG_URL ?>/bin/admin/character/load-image-set.js.php?image-set="+sImageSetWings+"&image-type="+sImageType);
		break;
	case "tail":
		sImageType = sEditorSelected;
		sEditorSelected = "sprite";

		oImageType = document.getElementById('image-type-body');
		oImageType.checked = false;
		oImageType = document.getElementById('image-type-hair');
		oImageType.checked = false;
		oImageType = document.getElementById('image-type-wings');
		oImageType.checked = false;
		oImageType = document.getElementById('image-type-tail');
		oImageType.checked = true;

		loadScript("<?php echo PHPRPG_URL ?>/bin/admin/character/load-image-set.js.php?image-set="+sImageSetTail+"&image-type="+sImageType);
		break;
	case "portrait":
		sImageType = sEditorSelected;
		loadScript("<?php echo PHPRPG_URL ?>/bin/admin/character/load-image-set.js.php?image-set="+sImageSetPortrait+"&image-type="+sImageType);
		break;
	case "attrib":
		if (!checkForm(true)) {
			oEditorSelect = document.getElementById('char-editor-select');
			oEditorSelect.selectedIndex = 0;
			sEditor = '';
			return;
		}
		loadScript("<?php echo PHPRPG_URL ?>/bin/admin/character/gen-attrib-list.js.php?char-id="+iChar);
		break;
	}

	oTool = document.getElementById("char-editor-"+sEditorSelected);
	oTool.style.display = "block";
}

function searchChar() {
	oCharSearch = document.getElementById("char-search-input");
	if (checkForm()) {
		doPopup('<?php echo PHPRPG_URL ?>/characters.php?submit=Search&query-string='+oCharSearch.value,'Item_Search',450,350,1);
	}
}

function deleteChar() {
	if (checkForm(true) && !confirm("Do you want to delete this character from the game universe?")) {
		return(false);
	}
	loadScript("<?php echo PHPRPG_URL ?>/bin/admin/character/delete-character.js.php?char-id="+iChar);
}

function saveChar(saveAs) {

	resetForm();

	oCharUserId = document.getElementById('char-userid-input');
	if (oCharUserId) iCharUserId = oCharUserId.value;
	else iCharUserId = '';

	oCharName = document.getElementById('char-name-input');
	if (oCharName) sCharName = oCharName.value;
	else sCharName = '';

	oCharStr = document.getElementById('char-str-input');
	if (oCharStr) iCharStr = oCharStr.value;
	else iCharStr = '';

	oCharVit = document.getElementById('char-vit-input');
	if (oCharVit) iCharVit = oCharVit.value;
	else iCharVit = '';

	oCharAgl = document.getElementById('char-agl-input');
	if (oCharAgl) iCharAgl = oCharAgl.value;
	else iCharAgl = '';

	oCharInt = document.getElementById('char-int-input');
	if (oCharInt) iCharInt = oCharInt.value;
	else iCharInt = '';

	oCharWis = document.getElementById('char-wis-input');
	if (oCharWis) iCharWis = oCharWis.value;
	else iCharWis = '';

	oCharChr = document.getElementById('char-chr-input');
	if (oCharChr) iCharChr = oCharChr.value;
	else iCharChr = '';

	oCharAge = document.getElementById('char-age-input');
	if (oCharAge) iCharAge = oCharAge.value;
	else iCharAge = '';

	oCharKrm = document.getElementById('char-krm-input');
	if (oCharKrm) iCharKrm = oCharKrm.value;
	else iCharKrm = '';

	oCharAC = document.getElementById('char-ac-input');
	if (oCharAC) iCharAC = oCharAC.value;
	else iCharAC = '';

	oCharHPCur = document.getElementById('char-hpcur-input');
	if (oCharHPCur) iCharHPCur = oCharHPCur.value;
	else iCharHPCur = '';

	oCharHPMax = document.getElementById('char-hpmax-input');
	if (oCharHPMax) iCharHPMax = oCharHPMax.value;
	else iCharHPMax = '';

	oCharStmCur = document.getElementById('char-stmcur-input');
	if (oCharStmCur) iCharStmCur = oCharStmCur.value;
	else iCharStmCur = '';

	oCharStmMax = document.getElementById('char-stmmax-input');
	if (oCharStmMax) iCharStmMax = oCharStmMax.value;
	else iCharStmMax = '';

	oCharManaCur = document.getElementById('char-manacur-input');
	if (oCharManaCur) iCharManaCur = oCharManaCur.value;
	else iCharManaCur = '';

	oCharManaMax = document.getElementById('char-manamax-input');
	if (oCharManaMax) iCharManaMax = oCharManaMax.value;
	else iCharManaMax = '';

	oCharCapCur = document.getElementById('char-capcur-input');
	if (oCharCapCur) iCharCapCur = oCharCapCur.value;
	else iCharCapCur = '';

	oCharCapMax = document.getElementById('char-capmax-input');
	if (oCharCapMax) iCharCapMax = oCharCapMax.value;
	else iCharCapMax = '';

	oCharSizeSelect = document.getElementById('char-size-select');
	if (oCharSizeSelect) iCharSizeSelect = oCharSizeSelect.options[oCharSizeSelect.selectedIndex].value;
	else iCharSizeSelect = 3;

	if (saveAs == true) saveAs = 1;
	else saveAs = 0;

    params  = "char-id="+iChar+"&char-user-id="+iCharUserId+"&char-name="+sCharName+"&char-str="+iCharStr+"&char-vit="+iCharVit;
    params += "&char-agl="+iCharAgl+"&char-int="+iCharInt+"&char-wis="+iCharWis+"&char-chr="+iCharChr+"&char-age="+iCharAge;
    params += "&char-krm="+iCharKrm+"&char-ac="+iCharAC+"&char-hp-cur="+iCharHPCur+"&char-hp-max="+iCharHPMax+"&char-stm-cur="+iCharStmCur;
    params += "&char-stm-max="+iCharStmMax+"&char-mana-cur="+iCharManaCur+"&char-mana-max="+iCharManaMax+"&char-cap-cur="+iCharCapCur;
    params += "&char-cap-max="+iCharCapMax+"&char-size="+iCharSizeSelect+"&char-save-as="+saveAs;

	loadScript("<?php echo PHPRPG_URL ?>/bin/admin/character/save-character.js.php?"+params);

}

function clearChar() {
	setChar(-1);
	setUser(-1);
	resetForm();

	oCharSearchInput = document.getElementById('char-search-input');
	oCharSearchInput.value = '';

	oCharImageSprite = document.getElementById('char-image-sprite');
	oCharImageSprite.src = '<?php echo PHPRPG_URL ?>/share/images/default_sprite.png';

	oCharImagePortrait = document.getElementById('char-image-portrait');
	oCharImagePortrait.src = '<?php echo PHPRPG_URL ?>/share/images/default_portrait.png';

	oCharUserId = document.getElementById('char-userid-input');
	oCharUserId.value = '';
	oCharName = document.getElementById('char-name-input');
	oCharName.value = '';
	oCharStr = document.getElementById('char-str-input');
	oCharStr.value = '';
	oCharVit = document.getElementById('char-vit-input');
	oCharVit.value = '';
	oCharAgl = document.getElementById('char-agl-input');
	oCharAgl.value = '';
	oCharInt = document.getElementById('char-int-input');
	oCharInt.value = '';
	oCharWis = document.getElementById('char-wis-input');
	oCharWis.value = '';
	oCharChr = document.getElementById('char-chr-input');
	oCharChr.value = '';
	oCharAge = document.getElementById('char-age-input');
	oCharAge.value = '';
	oCharKrm = document.getElementById('char-krm-input');
	oCharKrm.value = '';
	oCharAC = document.getElementById('char-ac-input');
	oCharAC.value = '';
	oCharHPCur = document.getElementById('char-hpcur-input');
	oCharHPCur.value = '';
	oCharHPMax = document.getElementById('char-hpmax-input');
	oCharHPMax.value = '';
	oCharStmCur = document.getElementById('char-stmcur-input');
	oCharStmCur.value = '';
	oCharStmMax = document.getElementById('char-stmmax-input');
	oCharStmMax.value = '';
	oCharManaCur = document.getElementById('char-manacur-input');
	oCharManaCur.value = '';
	oCharManaMax = document.getElementById('char-manamax-input');
	oCharManaMax.value = '';
	oCharCapCur = document.getElementById('char-capcur-input');
	oCharCapCur.value = '';
	oCharCapMax = document.getElementById('char-capmax-input');
	oCharCapMax.value = '';
	oCharSizeSelect = document.getElementById('char-size-select');
	oCharSizeSelect.selectedIndex = 3;
}

function clearImagePalette() {
	oItemset = document.getElementById("image-palette");
	while (oItemset.hasChildNodes()) oItemset.removeChild(oItemset.lastChild);
	iSelectedItem = -1;
}

function clearPortraitPalette() {
	oItemset = document.getElementById("portrait-palette");
	while (oItemset.hasChildNodes()) oItemset.removeChild(oItemset.lastChild);
	iSelectedItem = -1;
}

function showImages(oSelect) {
	setImageSet(oSelect.options[oSelect.selectedIndex].value, sImageType);
	switch(sImageType) {
	case 'portrait': sImageSet = sImageSetPortrait; break;
	case 'body'    : sImageSet = sImageSetBody;     break;
	case 'hair'    : sImageSet = sImageSetHair;     break;
	case 'wings'   : sImageSet = sImageSetWings;    break;
	case 'tail'    : sImageSet = sImageSetTail;     break;
	}
	loadScript("<?php echo PHPRPG_URL ?>/bin/admin/character/load-image-set.js.php?image-set="+sImageSet+"&image-type="+sImageType);
}

function scanImages() {
	if (checkForm()) doPopup("<?php echo PHPRPG_URL ?>/characters.php?submit=Scan+Images&image-type="+sImageType,"Scan_Images",500,350,1);
}

function uploadImages() {
	if (checkForm()) doPopup('<?php echo PHPRPG_URL ?>/characters.php?submit=Upload+Images&image-type='+sImageType,'Image_Uploader',500,175,1);
}

function editImageSet() {
	switch(sImageType) {
	case 'portrait': sImageSet = sImageSetPortrait; break;
	case 'body'    : sImageSet = sImageSetBody;     break;
	case 'hair'    : sImageSet = sImageSetHair;     break;
	case 'wings'   : sImageSet = sImageSetWings;    break;
	case 'tail'    : sImageSet = sImageSetTail;     break;
	}

	url = "<?php echo PHPRPG_URL ?>/characters.php?submit=Organize+Images&char-id="+iChar+"&image-set="+sImageSet+"&old-image-set="+sImageSet+"&image-type="+sImageType;

	if (checkForm()) doPopup(url,'Organize_Image_Sets',525,350,1);
}

function selectImage(iImage) {
	if (checkForm(true)) {
		resetForm();
		loadScript("<?php echo PHPRPG_URL ?>/bin/admin/character/swap-character-image.js.php?char-id="+iChar+"&image-id="+iImage+"&image-type="+sImageType);
	}
}

function addImageToPalette(id, imgpath) {
	oItemset = document.getElementById("image-palette");
	oItem = document.createElement("IMG");
	oItem.setAttribute("id", "image-"+id);
	oItem.setAttribute("name", "character");
	oItem.setAttribute("src", "<?php echo PHPRPG_URL ?>"+imgpath);
	oItem.className = "sprite-images";
	oItem.onclick = function(){ selectImage(id); };
	oItemset.appendChild(oItem);
}

function addPortraitToPalette(id, imgpath) {
	oItemset = document.getElementById("portrait-palette");
	oItem = document.createElement("IMG");
	oItem.setAttribute("id", "image-"+id);
	oItem.setAttribute("name", "character");
	oItem.setAttribute("src", "<?php echo PHPRPG_URL ?>"+imgpath);
	oItem.className = "portrait-images";
	oItem.onclick = function(){ selectImage(id); };
	oItemset.appendChild(oItem);
}

function loadPage() {
	loadScript("<?php echo PHPRPG_URL ?>/bin/admin/character/load-character.js.php?char-id="+iChar);
	editorSelect(sEditor);
}

window.onload = function() { loadPage(); }
