<?php

if (!defined('PHPRPG_DISPLAY')) define('PHPRPG_DISPLAY', true);

require_once(PHPRPG_DIR.'/lib/template.lib.php');

function drawBorder($CONTENTS,$WIDTH=0) {
	$tplObj = new TEMPLATE();
	$tplObj->define('CONTENTS', $CONTENTS);
	$tplObj->define('WIDTH', $WIDTH);
	return($tplObj->build('display_border'));
}

function drawMenu($mode=FALSE) {

	$admin = $_SESSION['PHPRPG']['UserLevel'];

	$tplObj = new TEMPLATE();

	if ($mode < TRUE) {
		$admin_link = "<!-- ADMIN LINK -->";
		if ($admin > 0) {
			$admin_link = "<a class='admin_menu' href='".PHPRPG_URL."/system.php'>[Admin Mode]</a>";
		}
		$tplObj->define('ADMIN_LINK', $admin_link);
		return($tplObj->build('user_menu'));
	}

	return($tplObj->build('admin_menu'));
}

function drawTime($seconds=0) {
	require_once(PHPRPG_DIR.'/lib/time.lib.php');
	$clockObj = new CLOCK();
	$date = $clockObj->date($seconds);
	$game_cycle = $clockObj->cycle($seconds);

	$TIME_IMAGE = PHPRPG_URL."/share/images/time_".$game_cycle."_".$date['period'].".png";

	$tplObj = new TEMPLATE();
	$tplObj->define('CYCLE', $date['cycle']);
	$tplObj->define('DAYS', $date['day']);
	$tplObj->define('HOURS', $date['hour']);
	$tplObj->define('MINUTES', $date['minute']);
	$tplObj->define('PERIOD', $date['period']);
	$tplObj->define('TIME_IMAGE',  $TIME_IMAGE);

	return($tplObj->build('display_time'));
}

function drawNavWindow() {

	require_once(PHPRPG_DIR.'/lib/character.lib.php');
	require_once(PHPRPG_DIR.'/lib/map.lib.php');

	$objChar   = new CHARACTER($_SESSION['PHPRPG']['CharId']);
	$objMap    = new MAP($objChar->loc['map']);
	$arrCoords = $objMap->getCoords($objChar->loc['loc']);
	$action    = '';

	$map_table = '<table class="map" id="map-table" cellpadding="0" cellspacing="0">';
	for($row=-PHPRPG_NAV_RADIUS; $row<=PHPRPG_NAV_RADIUS; $row++) {
		$map_table .= '<tr class="map">';
		for($cell=-PHPRPG_NAV_RADIUS; $cell<=PHPRPG_NAV_RADIUS; $cell++) {
			if ($cell == 0 && $row == 0) {
				// Do something for the current location
				$action = "alert('You are here');";
				$cursor = 'auto';
				$mouseover = 'clearMasks()';
				$maskFile = 'mask_trans.png';
			} else {
				$action = 'move('.$cell.','.$row.',0);';
				$mouseover = 'showMask(this);';
				$maskFile = 'mask_error.png';
			}

			$x = $arrCoords['x'] + $cell;
			$y = $arrCoords['y'] + $row;
			$cellid = $x.'|'.$y;
			// Pri Tile
			$celldata = '<img src="'.PHPRPG_URL.'/share/images/default_tile.png" alt="('.$x.','.$y.')" style="border:0; position:absolute;" />';
			// Alt Tile
			$celldata .= '<img src="'.PHPRPG_URL.'/share/images/mask_trans.png" alt="" style="border:0; position:absolute;" />';
			// Movement mask
			$celldata .= '<img src="'.PHPRPG_URL.'/share/images/'.$maskFile.'" alt="" style="border:0; position:absolute; display:none;" />';
			$map_table .= '
				<td class="map" id="'.$cellid.'"><div style="position:relative; width:32px; height:32px;"><a href="javascript:'.$action.'" onmouseover="'.$mouseover.'">'.$celldata.'</a></div></td>';
		}
		$map_table .= '</tr>';
	}
	$map_table .= '</table>';

	$page = new TEMPLATE();
	$page->define('BASE_URL',   PHPRPG_URL);
	$page->define('NAV_WINDOW', drawBorder($map_table));

	return $page->build('display_navigation');
}

function drawOverviewWindow() {

	require_once(PHPRPG_DIR.'/lib/character.lib.php');
	require_once(PHPRPG_DIR.'/lib/map.lib.php');

	$objChar = new CHARACTER($_SESSION['PHPRPG']['CharId'], PHPRPG_CHAR_CORE);
	$objMap = new MAP($objChar->loc['map']);
	$arrCoord = $objMap->getCoords($objChar->loc['loc']);

	$radZ = 0;
	$radY = PHPRPG_OVERVIEW_RADIUS;
	$radX = PHPRPG_OVERVIEW_RADIUS;

	$minY = -$radY;
	$maxY = $radY;
	$minX = -$radX;
	$maxX = $radX;

	// DRAW MAP TABLE
	$map_table = '<table class="map" id="map-table" cellpadding="0" cellspacing="0">';
	for($row=$minY; $row<=$maxY; $row++) {
		$map_table .= '<tr class="map">';
		for($cell=$minX; $cell<=$maxX; $cell++) {
			$x = $cell+$arrCoord['x'];
			$y = $row+$arrCoord['y'];
			$cellid = $x.'|'.$y;
			$celldata = '<img src="'.PHPRPG_URL.'/share/images/default_tile.png" alt="('.$x.','.$y.')" />';
			$map_table .= '<td class="map" id="'.$cellid.'">'.$celldata.'</td>';
		}
		$map_table .= '</tr>';
	}
	$map_table .= '</table>';

	$overview_load  = "<script type=\"text/javascript\" language=\"JavaScript\" src=\"".PHPRPG_URL."/lib/js/map.js.php\"></script>";
	$overview_load .= "<script type=\"text/javascript\" language=\"JavaScript\" src=\"".PHPRPG_URL."/lib/js/scriptload.js\"></script>";
	$overview_load .= '<script type="text/javascript" language="JavaScript">';
	$overview_load .= "mapWidth  = ".($radX).";";
	$overview_load .= "mapHeight = ".($radY).";";
	$overview_load .= "loadScript(\"".PHPRPG_URL."/bin/load-overview.js.php\");";
	$overview_load .= '</script>';

	$page = new TEMPLATE();
	$page->define('BASE_URL',        PHPRPG_URL);
	$page->define('OVERVIEW_WINDOW', drawBorder($map_table));
	$page->define('OVERVIEW_LOAD',   $overview_load);

	return $page->build('display_overview');
}

function drawStatsWindow() {

	$stat_load  = "<script type=\"text/javascript\" language=\"JavaScript\" src=\"".PHPRPG_URL."/lib/js/scriptload.js\"></script>";
	$stat_load .= '<script type="text/javascript" language="JavaScript">';
	$stat_load .= "loadScript(\"".PHPRPG_URL."/bin/load-stats.js.php\");";
	$stat_load .= '</script>';

	$page = new TEMPLATE();
	$page->define('BASE_URL',        PHPRPG_URL);
	$page->define('CHARACTER_STAT_LOAD',   $stat_load);
	$page->define('CHARACTER_STAT_STR',   "<div id='char-stat-str' name='char-stat-str'></div>");
	$page->define('CHARACTER_STAT_VIT',   "<div id='char-stat-vit' name='char-stat-vit'></div>");
	$page->define('CHARACTER_STAT_AGL',   "<div id='char-stat-agl' name='char-stat-agl'></div>");
	$page->define('CHARACTER_STAT_INT',   "<div id='char-stat-int' name='char-stat-int'></div>");
	$page->define('CHARACTER_STAT_WIS',   "<div id='char-stat-wis' name='char-stat-wis'></div>");
	$page->define('CHARACTER_STAT_CHR',   "<div id='char-stat-chr' name='char-stat-chr'></div>");
	$page->define('CHARACTER_STAT_AB',    "<div id='char-stat-ab'  name='char-stat-ab' ></div>");
	$page->define('CHARACTER_STAT_AC',    "<div id='char-stat-ac'  name='char-stat-ac' ></div>");
	$page->define('CHARACTER_STAT_AGE',   "<div id='char-stat-age' name='char-stat-age'></div>");
	$page->define('CHARACTER_STAT_KRM',   "<div id='char-stat-krm' name='char-stat-krm'></div>");

	return $page->build('display_player_stats');
}

function drawEquipWindow() {

	$equip_load  = "<script type=\"text/javascript\" language=\"JavaScript\" src=\"".PHPRPG_URL."/lib/js/scriptload.js\"></script>";
	$equip_load .= '<script type="text/javascript" language="JavaScript">';
	$equip_load .= "loadScript(\"".PHPRPG_URL."/bin/load-equiped.js.php\");";
	$equip_load .= '</script>';

	$sprite_image         = "<img src='".PHPRPG_URL."/share/images/x.png' id='equiped-item-sprite'  name='equiped-item-sprite'  width='128' height='128'>";
	$equiped_item_head    = "<img src='".PHPRPG_URL."/share/images/x.png' id='equiped-item-head'    name='equiped-item-head'    width='32' height='32'>";
	$equiped_item_neck    = "<img src='".PHPRPG_URL."/share/images/x.png' id='equiped-item-neck'    name='equiped-item-neck'    width='32' height='32'>";
	$equiped_item_chest   = "<img src='".PHPRPG_URL."/share/images/x.png' id='equiped-item-chest'   name='equiped-item-chest'   width='32' height='32'>";
	$equiped_item_boots   = "<img src='".PHPRPG_URL."/share/images/x.png' id='equiped-item-boots'   name='equiped-item-boots'   width='32' height='32'>";
	$equiped_item_belt    = "<img src='".PHPRPG_URL."/share/images/x.png' id='equiped-item-belt'    name='equiped-item-belt'    width='32' height='32'>";
	$equiped_item_legs    = "<img src='".PHPRPG_URL."/share/images/x.png' id='equiped-item-legs'    name='equiped-item-legs'    width='32' height='32'>";
	$equiped_item_rhand   = "<img src='".PHPRPG_URL."/share/images/x.png' id='equiped-item-rhand'   name='equiped-item-rhand'   width='32' height='32'>";
	$equiped_item_lhand   = "<img src='".PHPRPG_URL."/share/images/x.png' id='equiped-item-lhand'   name='equiped-item-lhand'   width='32' height='32'>";
	$equiped_item_rfinger = "<img src='".PHPRPG_URL."/share/images/x.png' id='equiped-item-rfinger' name='equiped-item-rfinger' width='32' height='32'>";
	$equiped_item_lfinger = "<img src='".PHPRPG_URL."/share/images/x.png' id='equiped-item-lfinger' name='equiped-item-lfigner' width='32' height='32'>";

	$page = new TEMPLATE();
	$page->define('BASE_URL',             PHPRPG_URL);
	$page->define('EQUIPED_ITEM_LOAD',    $equip_load);
	$page->define('EQUIPED_SPRITE',       $sprite_image);
	$page->define('EQUIPED_ITEM_HEAD',    drawBorder($equiped_item_head,    "1%"));
	$page->define('EQUIPED_ITEM_NECK',    drawBorder($equiped_item_neck,    "1%"));
	$page->define('EQUIPED_ITEM_CHEST',   drawBorder($equiped_item_chest,   "1%"));
	$page->define('EQUIPED_ITEM_BELT',    drawBorder($equiped_item_belt,    "1%"));
	$page->define('EQUIPED_ITEM_LEGS',    drawBorder($equiped_item_legs,    "1%"));
	$page->define('EQUIPED_ITEM_BOOTS',   drawBorder($equiped_item_boots,   "1%"));
	$page->define('EQUIPED_ITEM_RHAND',   drawBorder($equiped_item_rhand,   "1%"));
	$page->define('EQUIPED_ITEM_LHAND',   drawBorder($equiped_item_lhand,   "1%"));
	$page->define('EQUIPED_ITEM_RFINGER', drawBorder($equiped_item_rfinger, "1%"));
	$page->define('EQUIPED_ITEM_LFINGER', drawBorder($equiped_item_lfinger, "1%"));

	return $page->build('display_player_equip');
}

function drawInvWindow() {

	$char_inv  = "<div id='character-inventory-palette' name='character-inventory-palette'></div>";
	$char_inv .= "<script type=\"text/javascript\" language=\"JavaScript\" src=\"".PHPRPG_URL."/bin/load-inventory.js.php\"></script>";

	$page = new TEMPLATE();
	$page->define('BASE_URL',              PHPRPG_URL);
	$page->define('CHARACTER_INVENTORY',   $char_inv);

	return $page->build('display_inventory');
}

function drawPlayersWindow() {

	$player_palette  = "<div id='local-players-palette' name='local-players-palette'></div>";
	$player_palette .= "<script type=\"text/javascript\" language=\"JavaScript\" src=\"".PHPRPG_URL."/bin/load-players.js.php\"></script>";

	$page = new TEMPLATE();
	$page->define('BASE_URL',        PHPRPG_URL);
	$page->define('PLAYER_WINDOW',   $player_palette);

	return $page->build('display_players');
}

function drawWeather() {

	$weather_current = "<div id='weather-current' name='weather-current'></div>";
	$weather_high    = "<div id='weather-high' name='weather-high'></div>";
	$weather_low     = "<div id='weather-low' name='weather-low'></div>";
	$weather_wdir    = "<div id='weather-wdir' name='weather-wdir'></div>";
	$weather_wmph    = "<div id='weather-wmph' name='weather-wmph'></div>";

	$page = new TEMPLATE();
	$page->define('WEATHER_CURRENT', $weather_current);
	$page->define('WEATHER_HIGH',    $weather_high);
	$page->define('WEATHER_LOW',     $weather_low);
	$page->define('WEATHER_WDIR',    $weather_wdir);
	$page->define('WEATHER_WMPH',    $weather_wmph);

	return $page->build('display_weather');
}

function drawDroppedItems() {

	$player_palette  = "<div id='dropped-items-palette' name='dropped-items-palette'></div>";
	$player_palette .= "<script type=\"text/javascript\" language=\"JavaScript\" src=\"".PHPRPG_URL."/bin/load-dropped-items.js.php\"></script>";

	$page = new TEMPLATE();
	$page->define('BASE_URL',        PHPRPG_URL);
	$page->define('DROPPED_ITEMS',   drawBorder($player_palette));

	return $page->build('display_dropped_items');
}

function drawQuickStats() {

	$player_name       = "<div id='player-qstats-name' name='player-qstats-name'></div>";
	$player_cur_hp     = "<div id='player-qstats-curhp' name='player-qstats-curhp'></div>";
	$player_max_hp     = "<div id='player-qstats-maxhp' name='player-qstats-maxhp'></div>";
	$player_hp_graph   = "<div id='player-qstats-hpgraph' name='player-qstats-hpgraph'></div>";
	$player_cur_mana   = "<div id='player-qstats-curmana' name='player-qstats-curmana'></div>";
	$player_max_mana   = "<div id='player-qstats-maxmana' name='player-qstats-maxmana'></div>";
	$player_mana_graph = "<div id='player-qstats-managraph' name='player-qstats-managraph'></div>";
	$player_cur_stam   = "<div id='player-qstats-curstam' name='player-qstats-curstam'></div>";
	$player_max_stam   = "<div id='player-qstats-maxstam' name='player-qstats-maxstam'></div>";
	$player_stam_graph = "<div id='player-qstats-stamgraph' name='player-qstats-stamgraph'></div>";
	$player_currency   = "<div id='player-qstats-currency' name='player-qstats-currency'></div>";
	$player_xp         = "<div id='player-qstats-xp' name='player-qstats-xp'></div>";
	$player_xp        .= "<script type=\"text/javascript\" language=\"JavaScript\" src=\"".PHPRPG_URL."/bin/load-qstats.js.php\"></script>";

	$page = new TEMPLATE();
	$page->define('BASE_URL',             PHPRPG_URL);
	$page->define('CHARACTER_NAME',       $player_name);
	$page->define('CHARACTER_CUR_HP',     $player_cur_hp);
	$page->define('CHARACTER_MAX_HP',     $player_max_hp);
	$page->define('CHARACTER_HP_GRAPH',   $player_hp_graph);
	$page->define('CHARACTER_CUR_MANA',   $player_cur_mana);
	$page->define('CHARACTER_MAX_MANA',   $player_max_mana);
	$page->define('CHARACTER_MANA_GRAPH', $player_mana_graph);
	$page->define('CHARACTER_CUR_STAM',   $player_cur_stam);
	$page->define('CHARACTER_MAX_STAM',   $player_max_stam);
	$page->define('CHARACTER_STAM_GRAPH', $player_stam_graph);
	$page->define('CHARACTER_CURRENCY',   $player_currency);
	$page->define('CHARACTER_XP',         $player_xp);

	return $page->build('display_player_qstats');
}


?>