<?php

if (!defined('PHPRPG_AUTH'))      define('PHPRPG_AUTH', true);
if (!defined('PHPRPG_LOGIN_ENV')) define('PHPRPG_LOGIN_ENV', '');

require_once(PHPRPG_DIR.'/lib/mysql.lib.php');
require_once(PHPRPG_DIR.'/lib/template.lib.php');
require_once(PHPRPG_DIR.'/lib/error.lib.php');

define('PHPRPG_AUTH_ALL',	  63);
define('PHPRPG_AUTH_SYSTEM',  32);
define('PHPRPG_AUTH_CHAR',    16);
define('PHPRPG_AUTH_SCRIPT',  8);
define('PHPRPG_AUTH_ITEM',	  4);
define('PHPRPG_AUTH_MAP',	  2);
define('PHPRPG_AUTH_TILE',    1);
define('PHPRPG_AUTH_NONE',    0);

class AUTHENTICATE
{
// PUBLIC:

	// See if the user is logged in / identified
	function userCheck() {
		if (empty($_SESSION['PHPRPG'])) {
			$error = 'No session record: host '.$this->host();

			$errObj = new ERROR_REPORTER();
			$this->errors[] = $errObj->report(PHPRPG_ERR_NOTICE,$error,$_SERVER['PHP_SELF'],0);
			unset($errObj);

			return(false);
		}
		return(true);
	}

	// See if the user has a character selected
	function charCheck() {
		if (empty($_SESSION['PHPRPG']['CharId'])) {
			$error = 'No character selected for user';

			$errObj = new ERROR_REPORTER();
			$this->errors[] = $errObj->report(PHPRPG_ERR_NOTICE,$error,$_SERVER['PHP_SELF'],0);
			unset($errObj);

			return(false);
		}
		return(true);
	}

	// Check permissions for the current user
	function levelCheck($bitLevel=0) {
		$bitLevel = intval($bitLevel);

		// Check we're logged in at all
		if ($this->userCheck() === false) return(false);

		if (($bitLevel > 0) && !($bitLevel & $_SESSION['PHPRPG']['UserLevel'])) {
			$error = 'Insufficient permissions: user id '.@$_SESSION['PHPRPG']['UserId'];

			$errObj = new ERROR_REPORTER();
			$this->errors[] = $errObj->report(PHPRPG_ERR_NOTICE,$error,$_SERVER['PHP_SELF'],0);
			unset($errObj);

			return(false);
		}
		return(true);
	}

	// Enforce a user login
	function login($bitLevel=0) {
		if ($this->userCheck() === false) $this->processLogin();
		if ($this->hostCheck() === false) $this->processLogin();
		if ($this->charCheck() === false) $this->processSelect();
		if ($bitLevel > 0 && $this->levelCheck($bitLevel) === false) header('Location: '.PHPRPG_URL);

		return(true);
	}

	function logout() {
		unset($_SESSION['PHPRPG']);

		return(true);
	}


//PRIVATE:

	// Draw log in prompt
	function promptLogin($ERROR='<!-- WHERE ERRORS GO -->') {

		$SOURCEFORGE = 'http://sourceforge.net/sflogo.php?group_id=29487&type=1';

		$USERNAME = '<input type="text" name="username" size="12" maxlength="32" class="input" value="'.htmlspecialchars(@$_POST['username']).'">';
		$PASSWORD = '<input type="password" name="password" size="12" maxlength="32" class="input">';

		// Create and display page
		$page = new TEMPLATE('page');
		$page->define('USERNAME', $USERNAME);
		$page->define('PASSWORD', $PASSWORD);
		$page->define('SOURCEFORGE', $SOURCEFORGE);
		$page->define('ERROR', $ERROR);
		exit($page->build('auth_login'));
	}

	function processLogin() {

		if (PHPRPG_LOGIN_ENV == '') {
			if(empty($_POST['password']) || empty($_POST['username'])) $this->promptLogin();
			$username = @$_POST['username'];
			$password = @$_POST['password'];
		}
		else $username = PHPRPG_LOGIN_ENV;

		$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		$errObj = new ERROR_REPORTER();

		$table01 = PHPRPG_DB_PREFIX.'_users';
		$query  = "SELECT UserId,UserLevel ";
		$query .= "FROM $table01 ";
		$query .= "WHERE UserName='$username' ";
		if(PHPRPG_LOGIN_ENV == '') $query .= "AND UserPass=MD5('$password') ";
		$query .= "LIMIT 1";

		if (!$dbObj->query($query)) {
			$this->errors[] = $errObj->report(PHPRPG_ERR_ERROR,$dbObj->error,__FILE__,__LINE__);
			$this->promptLogin('Cannot login at this time');
		}
		$row = mysql_fetch_assoc($dbObj->result);
		$dbObj->flush();

		if ($row !== false && $row['UserId'] > 0) {
			$query  = "UPDATE $table01 ";
			$query .= "SET UserLastOn=UNIX_TIMESTAMP() ";
			$query .= "WHERE UserId=".$row['UserId'];
			if (!$dbObj->command($query)) $errObj->report(PHPRPG_ERR_ERROR,$dbObj->error,__FILE__,__LINE__);

			$row['Host'] = $this->host();

			$_SESSION['PHPRPG'] = $row;

			return(true);
		}
		else {
			$error = 'FAILED authentication attempt: username '.$username;
			$this->errors[] = $errObj->report(PHPRPG_ERR_NOTICE,$error);
			unset($errObj);
			$this->promptLogin('Wrong Username or Password');
		}
	}

	function promptSelect() {

		$header_extras  = "\n<script language=\"JavaScript\">";
		$header_extras .= "\n function goLocation() {";
		$header_extras .= "\n  url = \"".PHPRPG_URL."/create-character.php\"";
		$header_extras .= "\n  document.location = url;";
		$header_extras .= "\n }";
		$header_extras .= "\n</script>";

		$char_select  = "<select class='input' id='character-select' name='character-id'>";
		$char_select .= "<option value='0'> - "._("Select Character")." - </option>";

		$user_id = $_SESSION['PHPRPG']['UserId'];

		$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		$errObj = new ERROR_REPORTER();

		$table = PHPRPG_DB_PREFIX.'_chars';
		$sql = "SELECT CharId, CharName FROM $table WHERE CharUser='$user_id'";
		if (!$dbObj->query($sql)) die($dbObj->error);
		if ($row = mysql_fetch_assoc($dbObj->result)) {
			do {
				$set = $row['CharName'];
				$id  = $row['CharId'];
				$char_select .= "\n\t<option value='$id'>$set</option>";
			}
			while($row = mysql_fetch_assoc($dbObj->result));
		}
		$dbObj->flush();
		$char_select .= "\n</select>";

		$char_submit = "<input type='submit' class='inputbutton' id='character-submit' name='character-submit' value=\""._("Select Character")."\">";

		$char_create = "<input type='button' class='inputbutton' id='character-create' name='character-create' value=\""._("Create Character")."\" onClick='goLocation()'>";

		// Create and display page
		$page = new TEMPLATE('page');
		$page->define('HEADER_EXTRAS',    $header_extras);
		$page->define('CHARACTER_SELECT', $char_select);
		$page->define('CHARACTER_SUBMIT', $char_submit);
		$page->define('CHARACTER_CREATE', $char_create);

		exit($page->build('auth_character_select'));
	}

	function processSelect() {

		$character_id = @$_POST['character-id'];
		$user_id      = $_SESSION['PHPRPG']['UserId'];

		if ($character_id < 1) $this->promptSelect();

		$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		$errObj = new ERROR_REPORTER();

		$table01 = PHPRPG_DB_PREFIX.'_chars';
		$query  = "SELECT CharId ";
		$query .= "FROM $table01 ";
		$query .= "WHERE CharUser='$user_id' && CharId='$character_id'";

		if (!$dbObj->query($query)) {
			$this->errors[] = $errObj->report(PHPRPG_ERR_ERROR,$dbObj->error,__FILE__,__LINE__);
			$this->logout();
			$this->promptLogin('Cannot select a character at this time');
		}
		$row = mysql_fetch_assoc($dbObj->result);
		$dbObj->flush();

		if ($row !== false && $row['CharId'] > 0) {

			$_SESSION['PHPRPG']['CharId'] = $row['CharId'];
			session_write_close();

			return(true);
		}
		else $this->promptSelect();

	}

	// Get host information
	function host() {
		$quads = explode('.', $_SERVER['REMOTE_ADDR'], 4);
		$quads[3] = '0';
		return(implode('.', $quads));
	}

	// Used to verify that the user is still coming from the same host
	function hostCheck() {
		// Are we logged in to know the host in the first place?
		if ($this->userCheck() === false) return(false);

		if ($this->host() != $_SESSION['PHPRPG']['Host']) {
			$error = 'FAILED host check: user id '.$_SESSION['PHPRPG']['UserId'];

			$errObj = new ERROR_REPORTER();
			$this->errors[] = $errObj->report(PHPRPG_ERR_NOTICE,$error,$_SERVER['PHP_SELF'],0);
			unset($errObj);

			$this->logout();
			return(false);
		}
		return(true);
	}

}


?>
