<?php

// Get contents of a directory, allows for recursion
function listDir($sPath,$recursive=true,$firstRun=true) {

	if ($firstRun) $rtn = false;

	static $rtn;

	$handle = opendir($sPath);
	while ($file = readdir($handle)) $return_value[] = $file;
	closedir($handle);

	sort($return_value);
	while (list($key, $val) = each($return_value)) {
		if ($val != "." && $val != "..") {
			$path = str_replace("//","/",$sPath.$val);
			$rtn[] = $path;
			if (is_dir($sPath.$val) && $recursive) listDir($sPath.$val."/",true,false);
		}
	}

	if ($firstRun) return($rtn);
}

function drawTileScan() {

	// Get all images in the images directory
	$tmp = listDir(PHPRPG_DIR.'/share/images/tiles/',false);
	$files = array();
	foreach($tmp as $value) {
		$count  = strlen(PHPRPG_DIR);
		$value  = substr($value,$count);
		if (!stristr($value,'CVS')
		&&  !stristr($value,'htm')
		&&  !is_dir(PHPRPG_DIR.$value)) {
			$files[] = $value;
		}
	}

	// Get all entries in the images table
	$dbObj = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
	$table = PHPRPG_DB_PREFIX.'_tile_images';
	if (!$dbObj->query("SELECT TileImagePath FROM $table")) die($dbObj->error);
	$tiles = array();
	if ($tmp = mysql_fetch_array($dbObj->result)) {
		do $tiles[] = $tmp['TileImagePath'];
		while($tmp = mysql_fetch_array($dbObj->result));
	}

	// Look for files with no entries
	$no_entry = array();
	foreach($files as $value) {
		if (!in_array($value,@$tiles)) $no_entry[] = $value;
	}
	reset($files);

	// Look for entries with no files
	$no_file = array();
	foreach($tiles as $value) {
		if (!in_array($value,$files)
		&&  $value != '/share/images/default_tile.png') {
			$no_file[] = $value;
		}
	}
	reset($tiles);

	$header_extras  = "\n<script language=\"JavaScript\">";
	$header_extras .= "\n var checkflagadd = false; ";
	$header_extras .= "\n var checkflagrem = false; ";
	$header_extras .= "\n function check(form,type) {";
	$header_extras .= "\n  if (type == \"add\" && checkflagadd == false && form.length > 6) {";
	$header_extras .= "\n   for (i = 0; i < form.length; i++) { form[i].checked = true; }";
	$header_extras .= "\n   checkflagadd = true; ";
	$header_extras .= "\n   form.select_all_add[0].value = \"Unselect All\"; ";
	$header_extras .= "\n   form.select_all_add[1].value = \"Unselect All\"; ";
	$header_extras .= "\n  }";
	$header_extras .= "\n  else if (type == \"rem\" && checkflagrem == false && form.length > 6) {";
	$header_extras .= "\n   for (i = 0; i < form.length; i++) { form[i].checked = true; }";
	$header_extras .= "\n   checkflagrem = true; ";
	$header_extras .= "\n   form.select_all_rem[0].value = \"Unselect All\"; ";
	$header_extras .= "\n   form.select_all_rem[1].value = \"Unselect All\"; ";
	$header_extras .= "\n  }";
	$header_extras .= "\n  else if (type == \"add\" && checkflagadd == true) {";
	$header_extras .= "\n   for (i = 0; i < form.length; i++) { form[i].checked = false; }";
	$header_extras .= "\n   checkflagadd = false; ";
	$header_extras .= "\n   form.select_all_add[0].value = \"Select All\"; ";
	$header_extras .= "\n   form.select_all_add[1].value = \"Select All\"; ";
	$header_extras .= "\n  }";
	$header_extras .= "\n  else if (type == \"rem\" && checkflagrem == true) {";
	$header_extras .= "\n   for (i = 0; i < form.length; i++) { form[i].checked = false; }";
	$header_extras .= "\n   checkflagrem = false; ";
	$header_extras .= "\n   form.select_all_rem[0].value = \"Select All\"; ";
	$header_extras .= "\n   form.select_all_rem[1].value = \"Select All\"; ";
	$header_extras .= "\n  }";
	$header_extras .= "\n }";
	$header_extras .= "\n</script>";

	$javascript = "onClick='window.opener.editorSelect(); window.close();'";
	$scan_cancel_button = "<input type='button' class='inputbutton' id='scan-cancel-button' name='scan-cancel-button' value='Cancel' $javascript>";

	$form_header01 = "\n<form action='".PHPRPG_URL."/tiles.php' method='POST' name='add_entry_form'>";

	$javascript = "onClick='check(this.form,\"add\")'";
	$scan_select_add_button = "<input type='button' class='inputbutton' id='scan-select-add-button' name='select_all_add' value='Select All' $javascript>";

	$scan_add_images_button = "<input type='submit' value='Add Images' id='scan-add-images-button' name='submit' class='inputbutton'>";
	$scan_no_entry = drawBorder("<div id='scan-no-new-entry' name='scan-no-new-entry'>There are no new images</div>",'100%');

	if (!empty($no_entry)) {
		$i = 0;
		$scan_no_entry = '';
		foreach ($no_entry as $value) {
			$sizeof = @filesize(PHPRPG_DIR.$value);
			$entry  = "\n<table id='scan-new-entry' name='scan-new-entry'>";
			$entry .= "\n<tr>";
			$entry .= "\n<td><input type='checkbox' name='add_entries[$i]' value='$value'></td>";
			$entry .= "\n<td><img src='".PHPRPG_URL."/$value'></td>";
			$entry .= "\n<td>";
			$entry .= "\n<b>filename</b>: $value<br>";
			$entry .= "\n<b>size</b>: &nbsp; &nbsp; &nbsp; &nbsp; $sizeof<br>";
			$entry .= "\n</td>";
			$entry .= "\n</tr>";
			$entry .= "\n</table>";
			$scan_no_entry .= drawBorder($entry,'100%');
			$i++;
		}
	}

	$form_header02 = "<form action='".PHPRPG_URL."/tiles.php' method='POST' name='rem_entry_form'>";

	$javascript = "onClick='check(this.form,\"rem\")'";
	$scan_select_rem_button = "<input type='button' class='inputbutton' id='scan-select-rem-button' name='select_all_rem' value='Select All' $javascript></td>";

	$scan_rem_images_button = "<input type='submit' class='inputbutton' id='scan-rem-images-button' name='submit' value='Del Images'>";
	$scan_no_file = drawBorder("<div id='scan-no-missing-entry' name='scan-no-missing-entry'>There are no missing images</div>",'100%');

	if (!empty($no_file)) {
		$i = 0;
		$scan_no_file = '';
		foreach ($no_file as $value) {
			$file  = "\n<table id='scan-no-file' name='scan-no-file'>";
			$file .= "\n<tr>";
			$file .= "\n<td><input type='checkbox' name='rem_entries[$i]' value='$value'></td>";
			$file .= "\n<td><b>filename</b>: $value<br></td>";
			$file .= "\n</tr>";
			$file .= "\n</table>";
			$scan_no_file .= drawBorder($file,'100%');
			$i++;
		}
	}

	$page = new TEMPLATE('page');
	$page->define('TITLE',                  'PHPRPG - Tile Image Scanning Tool');
	$page->define('HEADER_EXTRAS',          $header_extras);
	$page->define('SCAN_CANCEL_BUTTON',     $scan_cancel_button);
	$page->define('FORM_HEADER01',          $form_header01);
	$page->define('SCAN_SELECT_ADD_BUTTON', $scan_select_add_button);
	$page->define('SCAN_ADD_IMAGES_BUTTON', $scan_add_images_button);
	$page->define('SCAN_NO_ENTRY',          $scan_no_entry);
	$page->define('FORM_HEADER02',          $form_header02);
	$page->define('SCAN_SELECT_REM_BUTTON', $scan_select_rem_button);
	$page->define('SCAN_REM_IMAGES_BUTTON', $scan_rem_images_button);
	$page->define('SCAN_NO_FILE',           $scan_no_file);

	return($page->build('admin_tiles_image_scan'));
}


?>