<?php

// Get contents of a directory, allows for recursion
function listDir($sPath,$recursive=true,$firstRun=true) {
	static $rtn;
	if ($firstRun) $rtn = false;

	$handle=opendir($sPath);
	while ($file = readdir($handle)) $retVal[count(@$retVal)] = $file;
	closedir($handle);

	sort($retVal);
	while (list($key, $val) = each($retVal)) {
		if ($val != "." && $val != "..") {
			$path = str_replace("//","/",$sPath.$val);
			$rtn[] = $path;
			if (is_dir($sPath.$val) && $recursive) listDir($sPath.$val."/",true,false);
		}
	}
	if ($firstRun) return($rtn);
}

function drawItemScan($type=false) {

	$type_name = ($type) ? 'icon' : 'merg';

	$tmp = listDir(PHPRPG_DIR."/share/images/items/$type_name/",false);
	$files = array();
	foreach($tmp as $value) {
		$count  = strlen(PHPRPG_DIR);
		$value  = substr($value,$count);
		if (!strstr($value,'CVS')
		&&  !strstr($value,'htm')
		&&  !strstr($value,'cvs')
		&&  !is_dir(PHPRPG_DIR.$value)) {
			$files[] = $value;
		}
	}

	// Get all entries in the images table
	$dbObj = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
	$tablename = PHPRPG_DB_PREFIX.'_item_images';
	if (!$dbObj->query("SELECT ItemImagePath FROM $tablename WHERE ItemImageType='$type'")) die($dbObj->error);
	$items = array();
	if ($tmp = mysql_fetch_array($dbObj->result)) {
		do $items[] = $tmp['ItemImagePath'];
		while($tmp = mysql_fetch_array($dbObj->result));
	}
	$dbObj->flush();

	// Look for files with no entries
	$noEntry = array();
	foreach($files as $value) {
		if (!in_array($value,@$items)) $no_entry[] = $value;
	}
	reset($files);

	// Look for entries with no files
	$noFile = array();
	foreach($items as $value) {
		if (!in_array($value,$files)
		&&  $value != '/share/images/default_item_merg.png'
		&&  $value != '/share/images/default_item_icon.png') {
			$no_file[] = $value;
		}
	}
	reset($items);

	$header_extras  = "\n<script language=\"JavaScript\">";
	$header_extras .= "\n var checkflagadd = \"false\"; ";
	$header_extras .= "\n var checkflagrem = \"false\"; ";
	$header_extras .= "\n function check(field,type) {";
	$header_extras .= "\n  if (type == \"add\" && checkflagadd == \"false\") {";
	$header_extras .= "\n   for (i = 0; i < field.length; i++) { field[i].checked = true; }";
	$header_extras .= "\n   checkflagadd = \"true\"; ";
	$header_extras .= "\n   field.select_all_add1.value = \"Unselect All\"; ";
	$header_extras .= "\n   field.select_all_add2.value = \"Unselect All\"; ";
	$header_extras .= "\n  }";
	$header_extras .= "\n  else if (type == \"rem\" && checkflagrem == \"false\") {";
	$header_extras .= "\n   for (i = 0; i < field.length; i++) { field[i].checked = true; }";
	$header_extras .= "\n   checkflagrem = \"true\"; ";
	$header_extras .= "\n   field.select_all_rem1.value = \"Unselect All\"; ";
	$header_extras .= "\n   field.select_all_rem2.value = \"Unselect All\"; ";
	$header_extras .= "\n  }";
	$header_extras .= "\n  else if (type == \"add\" && checkflagadd == \"true\") {";
	$header_extras .= "\n   for (i = 0; i < field.length; i++) { field[i].checked = false; }";
	$header_extras .= "\n   checkflagadd = \"false\"; ";
	$header_extras .= "\n   field.select_all_add1.value = \"Select All\"; ";
	$header_extras .= "\n   field.select_all_add2.value = \"Select All\"; ";
	$header_extras .= "\n  }";
	$header_extras .= "\n  else if (type == \"rem\" && checkflagrem == \"true\") {";
	$header_extras .= "\n   for (i = 0; i < field.length; i++) { field[i].checked = false; }";
	$header_extras .= "\n   checkflagrem = \"false\"; ";
	$header_extras .= "\n   field.select_all_rem1.value = \"Select All\"; ";
	$header_extras .= "\n   field.select_all_rem2.value = \"Select All\"; ";
	$header_extras .= "\n  }";
	$header_extras .= "\n }";
	$header_extras .= "\n</script>";

	$form_header01  = "\n<form action='".PHPRPG_URL."/items.php' method='POST' name='add_entry_form'>";
	$form_header01 .= "\n<input type='hidden' name='type' value='$type'>";

	$scan_add_images_button = "\n<input type='submit' value='Add Images' name='submit' class='inputbutton'/>";

	$javascript = "onClick='check(this.form,\"add\")";
	$scan_select_add_button = "\n<input type='button' value='Select All' name='select_all_add2' class='inputbutton' $javascript)'>";

	$javascript = "onClick='window.opener.loadPage(); window.close()'";
	$scan_cancel_button = "<input type='button' value='Cancel' class='inputbutton' $javascript>";

	$scan_no_entry = drawBorder("<div id='scan-no-new-entry' name='scan-no-new-entry'>There are no new images</div>",'100%');

	if (!empty($no_entry)) {
		$i = 0;
		$scan_no_entry = '';
		foreach ($no_entry as $value) {
			$sizeof = @filesize(PHPRPG_DIR.$value);
			$quote  = "\n<table border='0' width='80%' cellpadding='0' cellspacing='0'>";
			$quote .= "\n<tr>";
			$quote .= "\n<td><input type='checkbox' name='add_entries[$i]' value='$value'></td>";
			$quote .= "\n<td><img src='".PHPRPG_URL."/$value'></td>";
			$quote .= "\n<td>";
			$quote .= "\n<b>filename</b>: $value<br>";
			$quote .= "\n<b>size</b>: &nbsp; &nbsp; &nbsp; &nbsp; $sizeof<br>";
			$quote .= "\n</td>";
			$quote .= "\n</tr>";
			$quote .= "\n</table>";
			$scan_no_entry .= drawBorder($quote,"100%");
			$i++;
		}
	}

	$form_header02  = "\n<form action='".PHPRPG_URL."/items.php' method='POST' name='rem_entry_form'>";
	$form_header02 .= "\n<input type='hidden' name='type' value='$type'>";

	$scan_select_rem_button = "\n<input type='button' value='Select All' name='select_all_rem2' class='inputbutton' onClick='check(this.form,\"rem\")'>";
	$scan_rem_images_button = "\n<input type='submit' value='Del Images' name='submit' class='inputbutton'>";

	$scan_no_file = drawBorder("<div id='scan-no-missing-entry' name='scan-no-missing-entry'>There are no missing images</div>",'100%');

	if (!empty($no_file)) {
		$i = 0;
		$scan_no_file = '';
		foreach ($no_file as $value) {
			$quote  = "\n<table border='0' width='100%'>";
			$quote .= "\n<tr>";
			$quote .= "\n<td><input type='checkbox' name='rem_entries[$i]' value='$value'></td>";
			$quote .= "\n<td><b>filename</b>: $value<br></td>";
			$quote .= "\n</tr>";
			$quote .= "\n</table>";
			$scan_no_file .= drawBorder($quote,"100%");
			$i++;
		}
	}

	$page = new TEMPLATE('page');
	$page->define('TITLE',                  'PHPRPG - Item Image Scanning Tool');
	$page->define('HEADER_EXTRAS',          $header_extras);
	$page->define('SCAN_CANCEL_BUTTON',     $scan_cancel_button);
	$page->define('FORM_HEADER01',          $form_header01);
	$page->define('SCAN_SELECT_ADD_BUTTON', $scan_select_add_button);
	$page->define('SCAN_ADD_IMAGES_BUTTON', $scan_add_images_button);
	$page->define('SCAN_NO_ENTRY',          $scan_no_entry);
	$page->define('FORM_HEADER02',          $form_header02);
	$page->define('SCAN_SELECT_REM_BUTTON', $scan_select_rem_button);
	$page->define('SCAN_REM_IMAGES_BUTTON', $scan_rem_images_button);
	$page->define('SCAN_NO_FILE',           $scan_no_file);

	return($page->build('admin_item_image_scan'));
}


?>