<?php

require_once('./etc/runtime.conf.php');
require_once(PHPRPG_DIR.'/lib/auth.lib.php');
require_once(PHPRPG_DIR.'/lib/display.lib.php');
require_once(PHPRPG_DIR.'/lib/template.lib.php');
require_once(PHPRPG_DIR.'/lib/sprite.lib.php');
require_once(PHPRPG_DIR.'/lib/map.lib.php');
require_once(PHPRPG_DIR.'/lib/character.lib.php');

// Check if user has logged in and is an admin
$authObj = new AUTHENTICATE();
$authObj->login();
$admin = $_SESSION['PHPRPG']['UserLevel'];

$options = PHPRPG_CHAR_CORE + PHPRPG_CHAR_STATS;
$objChar = new CHARACTER($_SESSION['PHPRPG']['CharId'], $options);
$objMap  = new MAP($objChar->loc['map']);

$sprite = new SPRITE($_SESSION['PHPRPG']['UserId']);
$sprite->load();
$sprite->write();

$pageObj = new TEMPLATE('page');
$pageObj->define('PROGRAM_NAME',      'Local View');
$pageObj->define('MAP_NAME',          $objMap->name);
$pageObj->define('TITLE',             'Local View');
$pageObj->define('HEADER_EXTRAS',     '');
$pageObj->define('USER_MENU',         drawMenu());
$pageObj->define('NAV_WINDOW',        drawNavWindow());
$pageObj->define('DROPPED_ITEMS',     drawDroppedItems());
$pageObj->define('LOCAL_PLAYERS',     drawPlayersWindow());
$pageObj->define('TIME_WINDOW',       drawTime());
$pageObj->define('PLAYER_QSTATS',     drawQuickStats());
$pageObj->define('WEATHER_CONDITION', drawWeather());
$pageObj->define('SPRITE',            '<img src="'.$sprite->sprite_url.'">');

echo $pageObj->build('user_local');


?>