<?php

/*                                                                            */
/* General Configuration                                                      */
/* ---------------------                                                      */
/* PHPRPG_DIR   : Base directory to where the main files are located, without */
/*                  the trailing slash '/' (e.g. 'c:/path/to/game')           */
/* PHPRPG_URL   : Base URL to where the main files are located, without the   */
/*                  trailing slash '/' (e.g. 'http://yourwebserver.com/game') */
/* PHPRPG_MAIL  : Appear as the sender's e-mail address on e-mails and        */
/*                  notices sent to players                                   */
/* PHPRPG_ADMIN : The password for the root user of the game                  */
/* PHPRPG_THEME : What is the default theme for this game                     */
/*                                                                            */

define('PHPRPG_DIR',   'c:/path/to/game');
define('PHPRPG_URL',   'http://yourwebserver.com/game');
define('PHPRPG_MAIL',  'email@example.com');
define('PHPRPG_ADMIN', 'password');
define("PHPRPG_THEME", 'phantasy');

/*                                                                            */
/* Game Configuration                                                         */
/* ------------------                                                         */
/* PHPRPG_SESSION_EXPIRY : Seconds before automatic session termination       */
/* PHPRPG_EPOCH          : UNIX TIMESTAMP that defines the start of time      */
/* PHPRPG_START_MAP      : Map ID that the user should be sent when created   */
/* PHPRPG_START_LOC      : Location ID that the user should be sent when      */
/*                          created                                           */
/* PHPRPG_START_STATS    : The number of points that the player can allocate  */
/*                          when they create a new character.                 */
/* PHPRPG_START_AC       : The base armor class                               */
/* PHPRPG_START_GP       : Amount of gold to begin with                       */
/* PHPRPG_START_STAMINA  : The default amount of stamina a character has      */
/*                                                                            */

define('PHPRPG_SESSION_EXPIRY',  '1200');
define('PHPRPG_EPOCH',           '0');
define('PHPRPG_START_MAP',       '1');
define('PHPRPG_START_LOC',       '143');
define('PHPRPG_START_STATS',     '60');
define('PHPRPG_START_AC',        '10');
define('PHPRPG_START_GP',        '1000');
define('PHPRPG_START_STAMINA',   '1000');

/*                                                                            */
/* Game Log Path                                                              */
/* ------------------                                                         */
/* This is the path to your local error log.  If you would like to use this   */
/* file elsewhere on your system, please make sure the webserver has write    */
/* access, or the game WILL NOT FUNCTION                                      */
/*                                                                            */

define('PHPRPG_ERROR_FILE', PHPRPG_DIR.'/share/log/error.log');

/*                                                                            */
/* DO NOT MODIFY BEYOND THIS POINT                                            */
/* -------------------------------                                            */
/*                                                                            */

require_once(PHPRPG_DIR.'/etc/init.php');


?>
