<?php

// Do standard require_onces
require_once('./etc/runtime.conf.php');
require_once(PHPRPG_DIR.'/lib/auth.lib.php');
require_once(PHPRPG_DIR.'/lib/display.lib.php');
require_once(PHPRPG_DIR.'/lib/mysql.lib.php');
require_once(PHPRPG_DIR.'/lib/template.lib.php');

// Check if user has logged in and is an admin
$authObj = new AUTHENTICATE();
$authObj->login(PHPRPG_AUTH_CHAR);

// Main logic of the application
switch (@$_REQUEST['submit']) {

default:

	require_once(PHPRPG_DIR.'/lib/admin/character/character_editor.php');
	require_once(PHPRPG_DIR.'/lib/context.lib.php');

	exit(drawCharacterEditor());

case 'Search':

	include(PHPRPG_DIR.'/lib/admin/character/search_results.php');
	require_once(PHPRPG_DIR.'/lib/context.lib.php');

	exit(drawSearchResults($_GET['query-string']));

case 'User Editor':

	include(PHPRPG_DIR.'/lib/admin/character/user_editor.php');
	require_once(PHPRPG_DIR.'/lib/context.lib.php');

	exit(drawUserEditor($_GET['user-id'],$_GET['action']));

case 'Edit Attributes':

	require_once(PHPRPG_DIR.'/lib/admin/character/attribute_editor.php');
	require_once(PHPRPG_DIR.'/lib/attributes.lib.php');

	exit(drawAttributeEditor($_GET['char-id'],
	                         $_GET['action'],
	                         $_GET['attrib-key'],
	                         $_GET['attrib-value'],
	                         $_GET['attrib-key-old']));

case 'Organize Images':

	require_once(PHPRPG_DIR.'/lib/admin/character/image_set_editor.php');

	exit(drawImageEditor($_GET['image-id'],
	                     $_GET['image-set'],
	                     $_GET['action'],
	                     $_GET['char-id'],
	                     $_GET['old-image-id'],
	                     $_GET['image-type']));

case 'Colour Editor':

	require_once(PHPRPG_DIR.'/lib/admin/character/colour_editor.php');

	exit(drawColourEditor($_GET['char-id'],
	                      $_GET['action']));

case 'Upload Images':

	require_once(PHPRPG_DIR.'/lib/admin/character/image_uploader.php');

	exit(UploadImages($_POST['action'],$_GET['image-type']));

case 'Scan Images':

	require_once(PHPRPG_DIR.'/lib/admin/character/image_scan.php');

	exit(drawImageScan($_GET['image-type']));

case 'Add Images':

	// See if $add_entries exists and if so try to add them to database
	$addEntries = @$_POST['add_entries'];
	$type       = @$_POST['type'];
	if (@$addEntries) {
		$dbObj = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		foreach ($addEntries as $value) {
			$tablename = PHPRPG_DB_PREFIX.'_char_images';
			$query = "INSERT INTO $tablename (CharImagePath,CharImageType) VALUES ('$value','$type')";
			if (!$dbObj->command($query)) die($dbObj->error);
		}
		$dbObj->flush();
	}

	exit(header("location: ".PHPRPG_URL."/characters.php?submit=Scan+Images&image-type=$type"));

case 'Del Images':

	// See if $del_entries exists and if so try to remove them from the database
	$remEntries = @$_POST['rem_entries'];
	$type       = @$_POST['type'];
	if (@$remEntries) {
		$dbObj = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		foreach ($remEntries as $value) {
			$tablename = PHPRPG_DB_PREFIX.'_char_images';
			$query = "DELETE FROM $tablename WHERE CharImagePath='$value' && CharImageType='$type'";
			if (!$dbObj->command($query)) die($dbObj->error);
		}
		$dbObj->flush();
	}

	exit(header("location: ".PHPRPG_URL."/characters.php?submit=Scan+Images&image-type=$type"));
}


?>