<?php
// Do standard require_onces
require_once('../etc/runtime.conf.php');
require_once(PHPRPG_DIR.'/lib/auth.lib.php');
require_once(PHPRPG_DIR.'/lib/character.lib.php');
require_once(PHPRPG_DIR.'/lib/item.lib.php');
require_once(PHPRPG_DIR.'/lib/context.lib.php');
require_once(PHPRPG_DIR.'/lib/display.lib.php');
require_once(PHPRPG_DIR.'/lib/template.lib.php');

// Check if user has logged in and is an admin
$authObj = new AUTHENTICATE();
if ($authObj->userCheck() === false) return;

$char_id   = $_SESSION['PHPRPG']['CharId'];

echo "\n oLocalPalette = document.getElementById('character-inventory-palette');";
echo "\n while (oLocalPalette.hasChildNodes()) oLocalPalette.removeChild(oLocalPalette.lastChild);";

$charObj = new CHARACTER($char_id );

$olObj = new Overlib(PHPRPG_URL.'/lib/js');
$olObj->set('sticky',    'true');
$olObj->set('fullhtml',  'true');

$inventory = $charObj->getInventory();

if (empty($inventory)) return;

foreach ($inventory as $item_id) {

	$itemObj = new ITEM($item_id);
	$tempObj = new TEMPLATE('page');

	$image = "<img src='".$itemObj->image()."' width='64'>";

	$select  = "<select class='input'>";
	$select .= "<option>Select an Action</option>";
	$select .= "<option>Drop Item</option>";
	$select .= "</select>";

	$tempObj->register('INV_ITEM_NAME',     $itemObj->item_info->name);
	$tempObj->register('INV_ITEM_IMAGE',    $image);
	$tempObj->register('INV_ITEM_SELECT',   $select);

	$tempObj->register('INV_ITEM_AC',       $itemObj->item_info->ar);
	$tempObj->register('INV_ITEM_AB',       $itemObj->item_info->ar);

	$tempObj->register('INV_ITEM_COUNT',    $itemObj->count);
	$tempObj->register('INV_ITEM_VALUE',    $itemObj->item_info->value);
	$tempObj->register('INV_ITEM_DMG_MIN',  $itemObj->item_info->dmgMin);
	$tempObj->register('INV_ITEM_DMG_MAX',  $itemObj->item_info->dmgMax);
	$tempObj->register('INV_ITEM_DMG_ADJ',  $itemObj->item_info->dmgAdj);
	$tempObj->register('INV_ITEM_WEIGHT',   $itemObj->item_info->weight);
	$tempObj->register('INV_CONTEXT_CLOSE', " onClick='cClick();' ");
	$tempObj->register('INV_CONTEXT_GO',    " onClick='cClick();' ");

	$context = drawBorder($tempObj->build('context_inventory'), '1');

	$context = ereg_replace("\n", '',   $context);
	$context = ereg_replace('"',  '\"', $context);
	$context = ereg_replace("'",  '\"', $context);

	echo "\n oItem = document.createElement('IMG');";
	echo "\n oItem.className = '';";
	echo "\n oItem.setAttribute('id', 'item-'+".$itemObj->id.");";
	echo "\n oItem.setAttribute('name', 'item');";
	echo "\n oItem.setAttribute('src', '".$itemObj->image()."');";
	echo "\n oItem.onclick = function() { return overlib(".$olObj->mkcmd($context)."); }";

	$itemObj->flush();

	echo "\n oLocalPalette.appendChild(oItem);";
}


?>