<?php

// Do standard require_onces
require_once('../../../etc/runtime.conf.php');
require_once(PHPRPG_DIR.'/lib/auth.lib.php');
require_once(PHPRPG_DIR.'/lib/script.lib.php');

// Check if user has logged in and is an admin
$authObj = new AUTHENTICATE();
$authObj->login(PHPRPG_AUTH_SCRIPT);

header('Content-type: text/javascript');

$scriptId = intval(@$_GET['script-id']);

if ($scriptId > 0) {

	$loadObj  = new SCRIPT($scriptId);
	$id       = $loadObj->id;
	$name     = $loadObj->name;
	$type     = $loadObj->type;
	$targeted = $loadObj->targeted;
	$content  = $loadObj->content;

	switch($type) {
	case PHPRPG_EVENT_DESTROY:
		$type = 1;
		break;
	case PHPRPG_EVENT_CREATE:
		$type = 2;
		break;
	case PHPRPG_EVENT_DROP:
		$type = 3;
		break;
	case PHPRPG_EVENT_PICKUP:
		$type = 4;
		break;
	case PHPRPG_EVENT_DEFEND:
		$type = 5;
		break;
	case PHPRPG_EVENT_ATTACK:
		$type = 6;
		break;
	case PHPRPG_EVENT_UNEQUIP:
		$type = 7;
		break;
	case PHPRPG_EVENT_EQUIP:
		$type = 8;
		break;
	case PHPRPG_EVENT_USE:
		$type = 9;
		break;
	case PHPRPG_EVENT_TALK:
		$type = 13;
		break;
	}

	if ($targeted) $targeted = "true";
	else $targeted = "false";

	echo "\n clearScript();";
	echo "\n setScript($id);";

	echo "\n oScriptNameInput = document.getElementById('script-name-input'); ";
	echo "\n oScriptNameInput.value = '$name'; ";

	echo "\n oScriptTypeSelect = document.getElementById('script-type-select'); ";
	echo "\n oScriptTypeSelect.selectedIndex = $type; ";

	echo "\n oScriptTargetedCheckbox = document.getElementById('script-targeted-checkbox'); ";
	echo "\n oScriptTargetedCheckbox.checked = $targeted; ";

	echo "\n oScriptContent = document.getElementById('script-textarea'); ";
	echo "\n oScriptContent.value = decodeURIComponent('".rawurlencode($content)."'); ";
}


?>
