<?php
require_once('../../../etc/runtime.conf.php');
require_once(PHPRPG_DIR.'/lib/map.lib.php');
require_once(PHPRPG_DIR.'/lib/tile.lib.php');
require_once(PHPRPG_DIR.'/lib/character.lib.php');
require_once(PHPRPG_DIR.'/lib/auth.lib.php');

header('Content-type: text/javascript');

$defTileId = 0;
$defTilePath = '/share/images/default_tile.png';
$transTileId = 0;
$transTilePath = '/share/images/mask_trans.png';

$maskTruePath = '/share/images/mask_success.png';
$maskFalsePath = '/share/images/mask_error.png';

$objAuth = new AUTHENTICATE();

// Check if user has logged in
if ($objAuth->userCheck() === false) exit;

// Check if user has admin status
$admin = $_SESSION['PHPRPG']['UserLevel'];

unset($objAuth);

$objChar = new CHARACTER($_SESSION['PHPRPG']['CharId'], PHPRPG_CHAR_CORE);
$objMap = new MAP($objChar->loc['map']);
$arrCoord = $objMap->getCoords($objChar->loc['loc']);

$radZ = 0;
if ($admin > PHPRPG_AUTH_NONE) {
	$radY = max(PHPRPG_NAV_RADIUS,PHPRPG_EDIT_HEIGHT);
	$radX = max(PHPRPG_NAV_RADIUS,PHPRPG_EDIT_WIDTH);
}
else {
	$radY = PHPRPG_NAV_RADIUS;
	$radX = PHPRPG_NAV_RADIUS;
}

$minY = $arrCoord['y']-$radY;
$maxY = $arrCoord['y']+$radY;
$minX = $arrCoord['x']-$radX;
$maxX = $arrCoord['x']+$radX;

$minY = -$radY;
$maxY = $radY;
$minX = -$radX;
$maxX = $radX;

$arrLocs = $objMap->snapshot($arrCoord['z'],$arrCoord['y'],$arrCoord['x'],$radZ,$radY,$radX);

// Only use the maps default tile if we have a fixed size map and are at z=0
// Otherwise, stick with the default-default tile (blank)
if($objMap->sizeX > 0 && $objMap->sizeY > 0 && $arrCoord['z'] == 0) {
	$defTileId = $objMap->defTile;
	$defTilePath = TILE::getImagePath($objMap->defTile);
}

$locZ = $arrCoord['z'];
for($y=$minY;$y<=$maxY;$y++) {
	for($x=$minX;$x<=$maxX;$x++) {
		$locY = $y+$arrCoord['y'];
		$locX = $x+$arrCoord['x'];
		$trans = 0;
		if($objMap->sizeZ > 0 && ($locZ < 0 || $locZ >= $objMap->sizeZ)) {
			if($objMap->wrapZ) {
				$locZ = $objMap->wrapCoord($locZ, $objMap->sizeZ);
			} else {
				$trans = 1;
			}
		}
		if($objMap->sizeY > 0 && ($locY < 0 || $locY >= $objMap->sizeY)) {
			if($objMap->wrapY) {
				$locY = $objMap->wrapCoord($locY, $objMap->sizeY);
			} else {
				$trans = 1;
			}
		}
		if($objMap->sizeX > 0 && ($locX < 0 || $locX >= $objMap->sizeX)) {
			if($objMap->wrapX) {
				$locX = $objMap->wrapCoord($locX, $objMap->sizeX);
			} else {
				$trans = 1;
			}
		}
		if(is_array(@$arrLocs["$locZ"]["$locY"]["$locX"])) {
			$tileId = @$arrLocs["$locZ"]["$locY"]["$locX"]['tile'];
			$image = @$arrLocs["$locZ"]["$locY"]["$locX"]['image'];
			// Work out if that tile is accessible
			$image[2] = $maskTruePath;
		} else {
			if($trans) {
				$tileId = $transTileId;
				$image = array($transTilePath, $transTilePath, $transTilePath);
			} else {
				$tileId = $defTileId;
				$image = array($defTilePath, $transTilePath);
				// Default tile type - work out if it's accessible
				$image[2] = $maskTruePath;
			}
		}
		if(!@$image[1]) $image[1] = $transTilePath;
		if(!@$image[2]) $image[2] = $transTilePath;
		echo '
		updateLoc('.$locX.', '.$locY.', "'.$image[0].'", "'.$image[1].'", "'.$image[2].'");';
	}
}


?>