<?php
// Admin move script to allow navigation round the editor
// Uses session vars to keep current location

require_once('../../../etc/runtime.conf.php');
require_once(PHPRPG_DIR.'/lib/auth.lib.php');
require_once(PHPRPG_DIR.'/lib/map.lib.php');
require_once(PHPRPG_DIR.'/lib/tile.lib.php');
require_once(PHPRPG_DIR.'/lib/character.lib.php');

header('Content-type: text/javascript');

$z = intval(@$_REQUEST['z']);
$y = intval(@$_REQUEST['y']);
$x = intval(@$_REQUEST['x']);
$abs = trim(@$_REQUEST['abs']);

$objAuth = new AUTHENTICATE();

// Check if user has pick status
if (!$objAuth->levelCheck(PHPRPG_AUTH_MAP)) exit;

unset($objAuth);

// Check for a current location, or exit (this should be set on map load)
if (empty($_SESSION['PHPRPG']['pick_zyx'])) exit;

// We can move to an absolute loc, or move relative to our current loc
if ($abs != '') {
	$_SESSION['PHPRPG']['pick_zyx'] = array('z'=>$z, 'y'=>$y, 'x'=>$x);
} else {
	$_SESSION['PHPRPG']['pick_zyx']['z'] += $z;
	$_SESSION['PHPRPG']['pick_zyx']['y'] += $y;
	$_SESSION['PHPRPG']['pick_zyx']['x'] += $x;
}

$objMap = new MAP($_SESSION['PHPRPG']['pick_map']);
$zyx = $_SESSION['PHPRPG']['pick_zyx'];
if ($objMap->wrapZ) {
	$zyx['z'] = $objMap->wrapCoord($zyx['z'], $objMap->sizeZ);
} elseif ($objMap->sizeZ > 0) {
	$zyx['z'] = max(0,min($objMap->sizeZ-1,$zyx['z']));
}
if ($objMap->wrapY) {
	$zyx['y'] = $objMap->wrapCoord($zyx['y'], $objMap->sizeY);
} elseif ($objMap->sizeY > 0) {
	$zyx['y'] = max(0,min($objMap->sizeY-1,$zyx['y']));
}
if ($objMap->wrapX) {
	$zyx['x'] = $objMap->wrapCoord($zyx['x'], $objMap->sizeX);
} elseif ($objMap->sizeX > 0) {
	$zyx['x'] = max(0,min($objMap->sizeX-1,$zyx['x']));
}
$_SESSION['PHPRPG']['pick_zyx'] = $zyx;

$rebuildArgs  = $_SESSION['PHPRPG']['pick_zyx']['x'].','.$_SESSION['PHPRPG']['pick_zyx']['y'].',';
$rebuildArgs .= $objMap->sizeX.','.$objMap->sizeY.',';
$rebuildArgs .= $objMap->wrapX.','.$objMap->wrapY;
echo 'rebuildMap('.$rebuildArgs.');';
?>
