<?php

$this->register('META',     'drawMeta');
$this->register('DYNAMIC',  'dynamicContentInc');
$this->register('BGCOLOR',  'getBGColor');
$this->register('TBCOLOR',  'getTBColor');
$this->register('GRADIANT', 'drawGradiant');
$this->register('STYLE',    'drawPageStyle');

function dynamicContentInc() {
	// Ensures content is dynamic, uncached
	@header("Expires: Mon, 1 Jan 1970 00:00:00 GMT");
	@header("Last-Modified: " . gmdate("D, d M Y H:i:s") . "GMT");
	@header("Cache-Control: no-cache, must-revalidate");
	@header("Pragma: no-cache");
	return(null);
}

function drawPageStyle() {
	$BGCOLOR = gamePallet(35);
	$tplObj = new TEMPLATE();
	$tplObj->define('BGCOLOR', $BGCOLOR);
	return($tplObj->build('master_style'));
}

function drawMeta() {
	$tplObj = new TEMPLATE();
	return($tplObj->build('master_meta'));
}

function getBGColor() {
	return(gamePallet(35));
}

function getTBColor() {
	return(gamePallet(-40,1));
}

function drawGradiant() {
	$tmp  =  "<table cellpadding='0' cellspacing='0' border='0' width='100%'>";
	$tmp .=  "\n<tr><td bgcolor='".gamePallet(80)."' width='100%'><img src='".PHPRPG_CORE_IMG."/images/x.png' width='0' height='3' border='0' alt=''></td></tr>";
	$tmp .=  "\n<tr><td bgcolor='".gamePallet(75)."' width='100%'><img src='".PHPRPG_CORE_IMG."/images/x.png' width='0' height='3' border='0' alt=''></td></tr>";
	$tmp .=  "\n<tr><td bgcolor='".gamePallet(70)."' width='100%'><img src='".PHPRPG_CORE_IMG."/images/x.png' width='0' height='3' border='0' alt=''></td></tr>";
	$tmp .=  "\n<tr><td bgcolor='".gamePallet(65)."' width='100%'><img src='".PHPRPG_CORE_IMG."/images/x.png' width='0' height='3' border='0' alt=''></td></tr>";
	$tmp .=  "\n<tr><td bgcolor='".gamePallet(60)."' width='100%'><img src='".PHPRPG_CORE_IMG."/images/x.png' width='0' height='3' border='0' alt=''></td></tr>";
	$tmp .=  "\n<tr><td bgcolor='".gamePallet(55)."' width='100%'><img src='".PHPRPG_CORE_IMG."/images/x.png' width='0' height='3' border='0' alt=''></td></tr>";
	$tmp .=  "\n<tr><td bgcolor='".gamePallet(50)."' width='100%'><img src='".PHPRPG_CORE_IMG."/images/x.png' width='0' height='3' border='0' alt=''></td></tr>";
	$tmp .=  "\n<tr><td bgcolor='".gamePallet(45)."' width='100%'><img src='".PHPRPG_CORE_IMG."/images/x.png' width='0' height='3' border='0' alt=''></td></tr>";
	$tmp .=  "\n<tr><td bgcolor='".gamePallet(40)."' width='100%'><img src='".PHPRPG_CORE_IMG."/images/x.png' width='0' height='3' border='0' alt=''></td></tr>";
	$tmp .=  "\n</table>";
	return($tmp);
}

function gamePallet($per,$offset=0) {

	require_once(PHPRPG_DIR.'/lib/time.lib.php');
	$clockObj = new CLOCK();

	// Theme colour depends on which game cycle
	$cycle = $clockObj->cycle();
	if ($offset > 0) $cycle += $offset;

	switch ($cycle) {
	case 1:
		$theme_R = 124; $theme_G = 44; $theme_B = 64;
		break;
	case 2:
		$theme_R = 202; $theme_G = 193; $theme_B = 41;
		break;
	case 3:
		$theme_R = 46; $theme_G = 120; $theme_B = 56;
		break;
	default:
		$theme_R = 44; $theme_G = 43; $theme_B = 129;
		break;
	}

	// If $per is negative, create theme with negative colours
	if ($per < 0) {
		$theme_R = 255 - $theme_R; $theme_G = 255 - $theme_G; $theme_B = 255 - $theme_B;
		$per = abs($per);
	}

	$day_fraction = ($clockObj->secInCycle() / $clockObj->seconds_in_day);
	if ($day_fraction > 0.5) { $day_fraction = 1 - $day_fraction; }
	$day_fraction = $day_fraction * 2;
	$fade = 240 * $day_fraction;

	$bg_R = $fade - (($fade - $theme_R) * $per / 100);
	$bg_R_hex = dechex(round($bg_R));
	$bg_R_hex = str_repeat('0', 2 - strlen($bg_R_hex)) . $bg_R_hex;

	$bg_G = $fade - (($fade - $theme_G) * $per / 100);
	$bg_G_hex = dechex(round($bg_G));
	$bg_G_hex = str_repeat('0', 2 - strlen($bg_G_hex)) . $bg_G_hex;

	$bg_B = $fade - (($fade - $theme_B) * $per / 100);
	$bg_B_hex = dechex(round($bg_B));
	$bg_B_hex = str_repeat('0', 2 - strlen($bg_B_hex)) . $bg_B_hex;

	return('#'.$bg_R_hex.$bg_G_hex.$bg_B_hex);
}


?>
