<?php

if (!defined('PHPRPG_USER')) define('PHPRPG_USER', true);

require_once(PHPRPG_DIR.'/lib/error.lib.php');
require_once(PHPRPG_DIR.'/lib/mysql.lib.php');

class USER {
//PUBLIC:
	var $id;
	var $name;
	var $pass;
	var $email;
	var $level;
	var $laston;

	var $errors;

	function load($userId=0) {

		$userId = intval($userId);

		if ($userId < 1 && $this->id < 1) return(false);
		if ($userId < 1 && $this->id > 0) $userId = $this->id;

		$this->flush();
		$this->errors = NULL;

		$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		$errObj = new ERROR_REPORTER();

		$table = PHPRPG_DB_PREFIX."_users";
		$sql  = "SELECT UserId, UserName, UserPass, UserMail, UserLevel, UserLastOn ";
		$sql .= "FROM $table ";
		$sql .= "WHERE UserId=$userId";

		if (!($dbObj->query($sql))) $this->errors[] = $errObj->report(PHPRPG_ERR_CRITICAL, $dbObj->error, __FILE__, __LINE__);
		list($this->id,
		     $this->name,
		     $this->pass,
		     $this->email,
		     $this->level,
		     $this->laston) = mysql_fetch_row($dbObj->result);
		$dbObj->flush();

		if (empty($this->errors)) return(true);
		return(false);
	}

	function save($newChar=false) {

		$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		$errObj = new ERROR_REPORTER();

		$this->errors = NULL;

		$table = PHPRPG_DB_PREFIX."_users";
		if ($this->id > 0) {

			$sql  = "UPDATE $table SET ";
			$sql .= "UserName='$this->name',UserPass='$this->pass',UserMail='$this->email',";
			$sql .= "UserLevel='$this->level' ";
			$sql .= "WHERE UserId=$this->id";

			if (!$dbObj->command($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_CRITICAL, $dbObj->error, __FILE__, __LINE__);
		}
		else {

			$sql  = "INSERT INTO $table ";
			$sql .= "(UserName, UserPass, UserMail, UserLevel)";
			$sql .= " VALUES ";
			$sql .= "('$this->name','$this->pass','$this->email','$this->level')";

			if (!$dbObj->command($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_CRITICAL, $dbObj->error, __FILE__, __LINE__);

			$this->id = mysql_insert_id();
		}
		if (empty($this->errors)) return(true);
		return(false);
	}

	function delete($userId=0) {

		if ($userId < 1 && $this->id < 1) return(false);
		if ($userId < 1) $userId = $this->id;

		require_once(PHPRPG_DIR."/lib/character.lib.php");

		$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		$errObj = new ERROR_REPORTER();
		$delObj = new CHARACTER();

		$this->errors = NULL;

		$table = PHPRPG_DB_PREFIX.'_users';
		$sql = "DELETE FROM $table WHERE UserId='$userId'";
		if (!$dbObj->command($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_CRITICAL, $dbObj->error, __FILE__, __LINE__);

		$table = PHPRPG_DB_PREFIX.'_chars';
		$sql = "SELECT CharId FROM $table WHERE CharUser='$userId'";
		if (!$dbObj->query($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_CRITICAL, $dbObj->error, __FILE__, __LINE__);
		if ($row = mysql_fetch_assoc($dbObj->result)) {
			do {
				$id  = $row['CharId'];
				$delObj->delete($id);
			}
			while($row = mysql_fetch_assoc($dbObj->result));
		}
		$dbObj->flush();

		if (empty($this->errors)) return(true);
		return(false);
	}

	function flush () {
		$this->id = 0;
		$this->name = '';
		$this->pass = "";
		$this->email = "";
		$this->level = 0;
		$this->laston = 0;
	}

	//Does a particular user exist?
	function exists($userId) {

		if (empty($userId)) return(false);

		$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		$errObj = new ERROR_REPORTER();

		$this->errors = NULL;

		$table = PHPRPG_DB_PREFIX.'_users';
		$sql = "SELECT UserId FROM $table WHERE UserId='$userId'";
		if (!$dbObj->query($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_CRITICAL, $dbObj->error, __FILE__, __LINE__);
		$row = mysql_fetch_assoc($dbObj->result);
		$dbObj->flush();

		if (empty($this->errors) && !empty($row['UserId'])) return(true);
		return(false);
	}

	//Is a username unique in the database?
	function uniqueUser($username) {

		if (empty($username)) return(false);

		$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		$errObj = new ERROR_REPORTER();

		$this->errors = NULL;

		$table = PHPRPG_DB_PREFIX.'_users';
		$sql = "SELECT UserId FROM $table WHERE UserName='$username'";
		if (!$dbObj->query($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_CRITICAL, $dbObj->error, __FILE__, __LINE__);
		$row = mysql_fetch_assoc($dbObj->result);
		$dbObj->flush();

		if (empty($this->errors) && empty($row['UserId'])) return(true);
		return(false);
	}

	//Is a email address unique in the database?
	function uniqueEmail($email) {

		if (empty($email)) return(false);

		$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		$errObj = new ERROR_REPORTER();

		$this->errors = NULL;

		$table = PHPRPG_DB_PREFIX.'_users';
		$sql = "SELECT UserId FROM $table WHERE UserMail='$email'";
		if (!$dbObj->query($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_CRITICAL, $dbObj->error, __FILE__, __LINE__);
		$row = mysql_fetch_assoc($dbObj->result);
		$dbObj->flush();

		if (empty($this->errors) && empty($row['UserId'])) return(true);
		return(false);
	}

	function setPassword($password) {
		if (empty($password)) return(false);
		$this->pass = md5($password);
		return(true);
	}


//PRIVATE:

	function USER($userId=0) {
		$this->flush();
		$userId = intval($userId);
		if ($userId > 0) $this->load($userId);
	}
}


?>
