<?php

if (!defined('PHPRPG_TILE')) define('PHPRPG_TILE', true);

require_once(PHPRPG_DIR.'/lib/error.lib.php');
require_once(PHPRPG_DIR.'/lib/mysql.lib.php');
require_once(PHPRPG_DIR.'/lib/terrain.lib.php');

class TILE
{
//PUBLIC:
	var $id;
	var $name;
	var $imagePath;
	var $terrain;
	var $override;
	var $cost;
	var $event;

	var $errors;

	function load($tileId=0) {

		$tileId = intval($tileId);

		if ($tileId < 1 && @$this->id < 1) return(false);
		if ($tileId < 1 && @$this->id > 0) $tileId = $this->id;

		$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		$errObj = new ERROR_REPORTER();

		$this->errors = NULL;

		$table01 = PHPRPG_DB_PREFIX."_tiles";
		$table02 = PHPRPG_DB_PREFIX."_tile_images";
		$table03 = PHPRPG_DB_PREFIX."_tile_cost";
		$table04 = PHPRPG_DB_PREFIX."_tile_events";

		$sql  = "SELECT TileId,TileName,TileTerrain,TileOverride,TileImage,TileImagePath,TileCostDN,TileCostNE,";
		$sql .= "       TileCostDE,TileCostSE,TileCostDS,TileCostSW,TileCostDW,TileCostNW,TileCostDU,TileCostDD, ";
		$sql .= "       TileEventCreate,TileEventDestroy,TileEventEnter,TileEventLeave,TileEventAttack,TileEventDefend ";
		$sql .= "FROM $table01 ";
		$sql .= "LEFT OUTER JOIN $table02 ";
		$sql .= "ON $table01.TileImage = $table02.TileImageId ";
		$sql .= "LEFT OUTER JOIN $table03 ";
		$sql .= "ON $table01.TileId = $table03.TileCostId ";
		$sql .= "LEFT OUTER JOIN $table04 ";
		$sql .= "ON $table01.TileId = $table04.TileEventId ";
		$sql .= "WHERE $table01.TileId='$tileId'";

		if (!$dbObj->query($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);

		list($this->id,
		     $this->name,
		     $this->terrainId,
		     $this->override,
		     $this->imageId,
		     $this->imagePath,
		     $this->cost['dn'],
		     $this->cost['ne'],
		     $this->cost['de'],
		     $this->cost['se'],
		     $this->cost['ds'],
		     $this->cost['sw'],
		     $this->cost['dw'],
		     $this->cost['nw'],
		     $this->cost['du'],
		     $this->cost['dd'],
		     $this->event['Create'],
		     $this->event['Destroy'],
		     $this->event['Enter'],
		     $this->event['Leave'],
		     $this->event['Attack'],
		     $this->event['Defend']) = mysql_fetch_row($dbObj->result);

		$dbObj->flush();

		if (empty($this->imagePath)) $this->imagePath = '/share/images/default_tile.png';

		$this->terrain = new TERRAIN($this->terrainId);

		if (empty($this->errors)) return(true);
		return(false);
	}

	function save() {

		$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		$errObj = new ERROR_REPORTER();

		$this->errors = NULL;

		$table01 = PHPRPG_DB_PREFIX."_tiles";
		$table02 = PHPRPG_DB_PREFIX."_tile_cost";
		$table03 = PHPRPG_DB_PREFIX."_tile_events";

		if ($this->id > 0) {

			if (!empty($this->terrainId)) $terrainId = $this->terrainId;
			else $terrainId = $this->terrain->id;

			$sql  = "UPDATE $table01 SET ";
			$sql .= "TileName='$this->name',";
			$sql .= "TileTerrain='$terrainId',TileOverride='$this->override',";
			$sql .= "TileImage='$this->imageId' ";
			$sql .= "WHERE TileId='$this->id'";

			if (!$dbObj->command($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);

			$sql  = "UPDATE $table02 SET ";
			$sql .= "TileCostDN='".$this->cost['dn']."',TileCostNE='".$this->cost['ne']."',TileCostDE='".$this->cost['de']."', ";
			$sql .= "TileCostSE='".$this->cost['se']."',TileCostDS='".$this->cost['ds']."',TileCostSW='".$this->cost['sw']."', ";
			$sql .= "TileCostDW='".$this->cost['dw']."',TileCostNW='".$this->cost['nw']."',TileCostDU='".$this->cost['du']."', ";
			$sql .= "TileCostDD='".$this->cost['dd']."' ";
			$sql .= "WHERE TileCostId='$this->id'";

			if (!$dbObj->command($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);

			$sql  = "UPDATE $table03 SET ";
			$sql .= "TileEventEnter='".$this->event['Enter']."',TileEventLeave='".$this->event['Leave']."', ";
			$sql .= "TileEventCreate='".$this->event['Create']."',TileEventDestroy='".$this->event['Destroy']."', ";
			$sql .= "TileEventAttack='".$this->event['Attack']."',TileEventDefend='".$this->event['Defend']."' ";
			$sql .= "WHERE TileEventId='$this->id'";

			if (!$dbObj->command($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);
		}
		else {

			if ($this->id < 0) $this->id = 0;

			if (!empty($this->terrainId)) $terrainId = $this->terrainId;
			else $terrainId = $this->terrain->id;

			$sql  = "INSERT INTO $table01 ";
			$sql .= "(TileName,TileTerrain,TileOverride,TileImage)";
			$sql .= " VALUES ";
			$sql .= "('$this->name','$terrainId','$this->override','$this->imageId')";

			if (!$dbObj->command($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);

			$this->id = mysql_insert_id();

			$sql  = "INSERT INTO $table02 ";
			$sql .= "(TileCostId,TileCostDN,TileCostNE,TileCostDE,TileCostSE,TileCostDS,TileCostSW,TileCostDW,TileCostNW,TileCostDU,TileCostDD)";
			$sql .= " VALUES ($this->id,";
			$sql .= " '".$this->cost['dn']."','".$this->cost['ne']."','".$this->cost['de']."',";
			$sql .= " '".$this->cost['se']."','".$this->cost['ds']."','".$this->cost['sw']."',";
			$sql .= " '".$this->cost['dw']."','".$this->cost['nw']."','".$this->cost['du']."',";
			$sql .= " '".$this->cost['dd']."')";

			if (!$dbObj->command($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);

			$sql  = "INSERT INTO $table03 ";
			$sql .= "(TileEventId,TileEventCreate,TileEventDestroy,TileEventEnter,TileEventLeave,TileEventAttack,TileEventDefend)";
			$sql .= " VALUES ($this->id,";
			$sql .= " '".$this->event['Create']."','".$this->event['Destroy']."',";
			$sql .= " '".$this->event['Enter']."','".$this->event['Leave']."',";
			$sql .= " '".$this->event['Attack']."','".$this->event['Defend']."')";

			if (!$dbObj->command($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);
		}
		if (empty($this->errors)) return(true);
		return(false);
	}

	function delete($tileId = 0) {

		If ($tileId < 1 && @$this->id < 1) return(false);
		if ($tileId < 1) $tileId = $this->id;

		$this->errors = NULL;

		$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		$errObj = new ERROR_REPORTER();

		if ($tileId > 0) {

			$table01 = PHPRPG_DB_PREFIX.'_tiles';
			$table02 = PHPRPG_DB_PREFIX.'_tile_cost';
			$table03 = PHPRPG_DB_PREFIX.'_tile_events';
			$table04 = PHPRPG_DB_PREFIX.'_tile_attrib';

			$sql = "DELETE FROM $table01 WHERE TileId=$tileId";
			if (!$dbObj->command($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);
			$sql = "DELETE FROM $table02 WHERE TileCostId=$tileId";
			if (!$dbObj->command($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);
			$sql = "DELETE FROM $table03 WHERE TileEventId=$tileId";
			if (!$dbObj->command($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);
			$sql = "DELETE FROM $table04 WHERE TileAttribTarget=$tileId";
			if (!$dbObj->command($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);
		}
		if (empty($this->errors)) return(true);
		return(false);
	}

	function flush() {
		$this->id = 0;
		$this->name = '';
		$this->imageId = 1;
		$this->imagePath = '/share/images/default_tile.png';
		$this->terrain = NULL;
		$this->terrainId = 0;
		$this->override = false;
		$this->cost   = array('dn'=>0,'ne'=>0,'de'=>0,'se'=>0,'ds'=>0,'sw'=>0,'dw'=>0,'nw'=>0,'du'=>0,'dd'=>0);
		$this->events = array('Create'=>'','Destroy'=>'','Enter'=>'','Leave'=>'','Attack'=>'','Defend'=>'');
	}

	// Return the image path given Tile Id
	function getImagePath($tileId) {

		if ($tileId < 1 && @$this->id < 1) return('/share/images/default_tile.png');
		if ($tileId < 1) $tileId = $this->id;

		$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		$errObj = new ERROR_REPORTER();

		$this->errors = NULL;

		$table01 = PHPRPG_DB_PREFIX.'_tile_images';
		$table02 = PHPRPG_DB_PREFIX.'_tiles';

		$query = "SELECT TileImagePath FROM $table01,$table02 WHERE TileId = '$tileId' AND $table02.TileImage = $table01.TileImageId LIMIT 1";
		if (!$dbObj->query($query)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);
		$row = mysql_fetch_assoc($dbObj->result);

		if (!empty($row['TileImagePath'])) $rtn = $row['TileImagePath'];
		else $rtn = '/share/images/default_tile.png';

		return($rtn);
	}

	// Replace old image of current instance with new image from $imageId
	function swapImage($imageId) {

		If ($imageId < 1) return(false);

		$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		$errObj = new ERROR_REPORTER();

		$this->errors = NULL;

		if ($imageId > 0) {

			$table = PHPRPG_DB_PREFIX."_tile_images";
			$sql  = "SELECT TileImagePath FROM $table WHERE TileImageId=$imageId";
			if (!$dbObj->query($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);
			$row = mysql_fetch_assoc($dbObj->result);

			$this->imageId = $imageId;
			$this->imagePath = $row["TileImagePath"];
		}
		if (empty($this->errors)) return(true);
		return(false);
	}

//PRIVATE:
	var $imageId;
	var $terrainId;

	function TILE($tileId=0) {
		$this->flush();
		$this->id = intval($tileId);
		if (!empty($this->id)) $this->load($this->id);
	}
}


?>
