<?php

if (!defined('PHPRPG_SPRITE')) define('PHPRPG_SPRITE', true);

require_once(PHPRPG_DIR.'/lib/error.lib.php');
require_once(PHPRPG_DIR.'/lib/mysql.lib.php');

define('PHPRPG_IMGLOC_PORTRAIT', 1);
define('PHPRPG_IMGLOC_BODY',     2);
define('PHPRPG_IMGLOC_HAIR',     3);
define('PHPRPG_IMGLOC_WINGS',    4);
define('PHPRPG_IMGLOC_TAIL',     5);

define('PHPRPG_IMG_WIDTH',       64);
define('PHPRPG_IMG_LENGTH',      64);


class SPRITE
{
//PUBLIC:

	var $sprite_url;
	var $portrait_url;

	function load($char_id=0) {

		$char_id = intval($char_id);

		if ($char_id < 1 && @$this->char_id < 1) return(false);
		if ($char_id < 1 && @$this->char_id > 0) $char_id = $this->char_id;

		$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		$errObj = new ERROR_REPORTER();

		$table01 = PHPRPG_DB_PREFIX."_char_sprite";
		$table02 = PHPRPG_DB_PREFIX."_char_images";

		$sql  = "SELECT ib.CharImagePath as CharImageBody,";
		$sql .= "       CharImageBodyPF, CharImageBodyHF,";
		$sql .= "       ih.CharImagePath as CharImageHair,";
		$sql .= "       CharImageHairPF, CharImageHairHF, ";
		$sql .= "       iw.CharImagePath as CharImageWings,";
		$sql .= "       CharImageWingsPF, CharImageWingsHF, ";
		$sql .= "       it.CharImagePath as CharImageTail,";
		$sql .= "       CharImageTailPF, CharImageTailHF, ";
		$sql .= "       ip.CharImagePath as CharImagePortrait ";
		$sql .= "FROM $table01 ";
		$sql .= "LEFT OUTER JOIN $table02 as ib";
		$sql .= "	ON ib.CharImageId = $table01.CharImageBody ";
		$sql .= "LEFT OUTER JOIN $table02 as ih";
		$sql .= "	ON ih.CharImageId = $table01.CharImageHair ";
		$sql .= "LEFT OUTER JOIN $table02 as iw";
		$sql .= "	ON iw.CharImageId = $table01.CharImageWings ";
		$sql .= "LEFT OUTER JOIN $table02 as it";
		$sql .= "	ON it.CharImageId = $table01.CharImageTail ";
		$sql .= "LEFT OUTER JOIN $table02 as ip";
		$sql .= "	ON ip.CharImageId = $table01.CharImagePortrait ";
		$sql .= "WHERE $table01.CharImageId = '$char_id'";

		if (!($dbObj->query($sql))) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);

		list($this->body,
		     $body_pf,
		     $body_hf,
			 $this->hair,
			 $hair_pf,
			 $hair_hf,
			 $this->wings,
			 $wings_pf,
			 $wings_hf,
			 $this->tail,
			 $tail_pf,
			 $tail_hf,
			 $this->portrait) = mysql_fetch_row($dbObj->result);

		$this->body_pf  = @unserialize($body_pf);
		$this->body_hf  = @unserialize($body_hf);
		$this->hair_pf  = @unserialize($hair_pf);
		$this->hair_hf  = @unserialize($hair_hf);
		$this->wings_pf = @unserialize($wings_pf);
		$this->wings_hf = @unserialize($wings_hf);
		$this->tail_pf  = @unserialize($tail_pf);
		$this->tail_hf  = @unserialize($tail_hf);

		$this->portrait_url = PHPRPG_URL.$this->portrait;

		$dbObj->flush();

		$table01 = PHPRPG_DB_PREFIX."_char_equip";
		$table02 = PHPRPG_DB_PREFIX."_items";
		$table03 = PHPRPG_DB_PREFIX."_item_info";
		$table04 = PHPRPG_DB_PREFIX."_item_images";

		$sql  = "SELECT t41.ItemImagePath as CharEquipHead, ";
		$sql .= "       t21.ItemPFColour  as CharEquipHeadPF,";
		$sql .= "       t21.ItemHFColour  as CharEquipHeadHF,";
		$sql .= "       t42.ItemImagePath as CharEquipChest, ";
		$sql .= "       t22.ItemPFColour  as CharEquipChestPF,";
		$sql .= "       t22.ItemHFColour  as CharEquipChestHF,";
		$sql .= "       t43.ItemImagePath as CharEquipBack, ";
		$sql .= "       t23.ItemPFColour  as CharEquipBackPF,";
		$sql .= "       t23.ItemHFColour  as CharEquipBackHF,";
		$sql .= "       t44.ItemImagePath as CharEquipFeet, ";
		$sql .= "       t24.ItemPFColour  as CharEquipFeetPF,";
		$sql .= "       t24.ItemHFColour  as CharEquipFeetHF,";
		$sql .= "       t45.ItemImagePath as CharEquipRHand, ";
		$sql .= "       t25.ItemPFColour  as CharEquipRHandPF,";
		$sql .= "       t25.ItemHFColour  as CharEquipRHandHF,";
		$sql .= "       t46.ItemImagePath as CharEquipLHand, ";
		$sql .= "       t26.ItemPFColour  as CharEquipLHandPF,";
		$sql .= "       t26.ItemHFColour  as CharEquipLHandHF, ";
		$sql .= "       t47.ItemImagePath as CharEquipLegs, ";
		$sql .= "       t27.ItemPFColour  as CharEquipLegsPF,";
		$sql .= "       t27.ItemHFColour  as CharEquipLegsHF ";
		$sql .= "FROM $table01 ";

		$sql .= "LEFT OUTER JOIN $table02 as t21 ";
		$sql .= "	ON t21.ItemId = $table01.CharEquipHead ";
		$sql .= "LEFT OUTER JOIN $table03 as t31 ";
		$sql .= "	ON t31.ItemInfoId = t21.ItemInfo ";
		$sql .= "LEFT OUTER JOIN $table04 as t41 ";
		$sql .= "	ON t41.ItemImageId = t31.ItemInfoImageMerg ";

		$sql .= "LEFT OUTER JOIN $table02 as t22 ";
		$sql .= "	ON t22.ItemId = $table01.CharEquipChest ";
		$sql .= "LEFT OUTER JOIN $table03 as t32 ";
		$sql .= "	ON t32.ItemInfoId = t22.ItemInfo ";
		$sql .= "LEFT OUTER JOIN $table04 as t42 ";
		$sql .= "	ON t42.ItemImageId = t32.ItemInfoImageMerg ";

		$sql .= "LEFT OUTER JOIN $table02 as t23 ";
		$sql .= "	ON t23.ItemId = $table01.CharEquipBack ";
		$sql .= "LEFT OUTER JOIN $table03 as t33 ";
		$sql .= "	ON t33.ItemInfoId = t23.ItemInfo ";
		$sql .= "LEFT OUTER JOIN $table04 as t43 ";
		$sql .= "	ON t43.ItemImageId = t33.ItemInfoImageMerg ";

		$sql .= "LEFT OUTER JOIN $table02 as t24 ";
		$sql .= "	ON t24.ItemId = $table01.CharEquipFeet ";
		$sql .= "LEFT OUTER JOIN $table03 as t34 ";
		$sql .= "	ON t34.ItemInfoId = t24.ItemInfo ";
		$sql .= "LEFT OUTER JOIN $table04 as t44 ";
		$sql .= "	ON t44.ItemImageId = t34.ItemInfoImageMerg ";

		$sql .= "LEFT OUTER JOIN $table02 as t25 ";
		$sql .= "	ON t25.ItemId = $table01.CharEquipRHand ";
		$sql .= "LEFT OUTER JOIN $table03 as t35 ";
		$sql .= "	ON t35.ItemInfoId = t25.ItemInfo ";
		$sql .= "LEFT OUTER JOIN $table04 as t45 ";
		$sql .= "	ON t45.ItemImageId = t35.ItemInfoImageMerg ";

		$sql .= "LEFT OUTER JOIN $table02 as t26 ";
		$sql .= "	ON t26.ItemId = $table01.CharEquipLHand ";
		$sql .= "LEFT OUTER JOIN $table03 as t36 ";
		$sql .= "	ON t36.ItemInfoId = t26.ItemInfo ";
		$sql .= "LEFT OUTER JOIN $table04 as t46 ";
		$sql .= "	ON t46.ItemImageId = t36.ItemInfoImageMerg ";

		$sql .= "LEFT OUTER JOIN $table02 as t27 ";
		$sql .= "	ON t27.ItemId = $table01.CharEquipLegs ";
		$sql .= "LEFT OUTER JOIN $table03 as t37 ";
		$sql .= "	ON t37.ItemInfoId = t27.ItemInfo ";
		$sql .= "LEFT OUTER JOIN $table04 as t47 ";
		$sql .= "	ON t47.ItemImageId = t37.ItemInfoImageMerg ";

		$sql .= "WHERE $table01.CharEquipId = '$char_id'";

		if (!($dbObj->query($sql))) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);

		list($this->head,
		     $head_pf,
		     $head_hf,
		     $this->chest,
		     $chest_pf,
		     $chest_hf,
		     $this->back,
		     $back_pf,
		     $back_hf,
		     $this->feet,
		     $feet_pf,
		     $feet_hf,
		     $this->r_hand,
		     $r_hand_pf,
		     $r_hand_hf,
		     $this->l_hand,
		     $l_hand_pf,
		     $l_hand_hf,
		     $this->legs,
		     $legs_pf,
		     $legs_hf) = mysql_fetch_row($dbObj->result);

		$this->head_pf   = @unserialize($head_pf);
		$this->head_hf   = @unserialize($head_hf);
		$this->chest_pf  = @unserialize($chest_pf);
		$this->chest_hf  = @unserialize($chest_hf);
		$this->back_pf   = @unserialize($back_pf);
		$this->back_hf   = @unserialize($back_hf);
		$this->feet_pf   = @unserialize($feet_pf);
		$this->feet_hf   = @unserialize($feet_hf);
		$this->r_hand_pf = @unserialize($r_hand_pf);
		$this->r_hand_hf = @unserialize($r_hand_hf);
		$this->l_hand_pf = @unserialize($l_hand_pf);
		$this->l_hand_hf = @unserialize($l_hand_hf);
		$this->legs_pf   = @unserialize($legs_pf);
		$this->legs_hf   = @unserialize($legs_hf);

		$dbObj->flush();

		if (!file_exists($this->sprite_dir)) $this->write();
	}

	function write() {

		@unlink($this->sprite_dir);

		$image = imagecreatefrompng(PHPRPG_DIR."/share/images/default_sprite.png");


		if (!empty($this->tail)) {
			$tail = $this->GetImage($this->tail,$this->tail_pf,$this->tail_hf);
			imagecopy($image, $tail, 0, 0, 0, 0, PHPRPG_IMG_WIDTH, PHPRPG_IMG_LENGTH);
		}
		if (!empty($this->wings)) {
			$wings = $this->GetImage($this->wings,$this->wings_pf,$this->wings_hf);
			imagecopy($image, $wings, 0, 0, 0, 0, PHPRPG_IMG_WIDTH, PHPRPG_IMG_LENGTH);
		}
		if (!empty($this->body)) {
			$body = $this->GetImage($this->body,$this->body_pf,$this->body_hf);
			imagecopy($image, $body, 0, 0, 0, 0, PHPRPG_IMG_WIDTH, PHPRPG_IMG_LENGTH);
		}
		if (!empty($this->hair)) {
			$hair = $this->GetImage($this->hair,$this->hair_pf,$this->hair_hf);
			imagecopy($image, $hair, 0, 0, 0, 0, PHPRPG_IMG_WIDTH, PHPRPG_IMG_LENGTH);
		}

		if (!empty($this->head)) {
			$head = $this->GetImage($this->head,$this->head_pf,$this->head_hf);
			imagecopy($image, $head, 0, 0, 0, 0, PHPRPG_IMG_WIDTH, PHPRPG_IMG_LENGTH);
		}
		if (!empty($this->chest)) {
			$chest = $this->GetImage($this->chest,$this->chest_pf,$this->chest_hf);
			imagecopy($image, $chest, 0, 0, 0, 0, PHPRPG_IMG_WIDTH, PHPRPG_IMG_LENGTH);
		}
		if (!empty($this->legs)) {
			$legs = $this->GetImage($this->legs,$this->legs_pf,$this->legs_hf);
			imagecopy($image, $legs, 0, 0, 0, 0, PHPRPG_IMG_WIDTH, PHPRPG_IMG_LENGTH);
		}
		if (!empty($this->back)) {
			$back = $this->GetImage($this->back,$this->back_pf,$this->back_hf);
			imagecopy($image, $back, 0, 0, 0, 0, PHPRPG_IMG_WIDTH, PHPRPG_IMG_LENGTH);
		}
		if (!empty($this->r_hand)) {
			$r_hand = $this->GetImage($this->r_hand,$this->r_hand_pf,$this->r_hand_hf);
			imagecopy($image, $r_hand, 0, 0, 0, 0, PHPRPG_IMG_WIDTH, PHPRPG_IMG_LENGTH);
		}
		if (!empty($this->l_hand)) {
			$l_hand = $this->GetImage($this->l_hand,$this->l_hand_pf,$this->l_hand_hf);
			imagecopy($image, $l_hand, 0, 0, 0, 0, PHPRPG_IMG_WIDTH, PHPRPG_IMG_LENGTH);
		}
		if (!empty($this->feet)) {
			$feet = $this->GetImage($this->feet,$this->feet_pf,$this->feet_hf);
			imagecopy($image, $feet, 0, 0, 0, 0, PHPRPG_IMG_WIDTH, PHPRPG_IMG_LENGTH);
		}

		imagepng($image,$this->sprite_dir);
	}

	function flush () {

		$this->sprite_dir   = "";
		$this->sprite_url   = "";

		$this->body         = "";
		$this->body_pf      = "";
		$this->body_hf      = "";
		$this->hair         = "";
		$this->hair_pf      = "";
		$this->hair_hf      = "";
		$this->wings        = "";
		$this->wings_pf     = "";
		$this->wings_hf     = "";
		$this->tail         = "";
		$this->tail_pf      = "";
		$this->tail_hf      = "";

		$this->head         = "";
		$this->head_pf      = "";
		$this->head_hf      = "";
		$this->chest        = "";
		$this->chest_pf     = "";
		$this->chest_hf     = "";
		$this->back         = "";
		$this->back_pf      = "";
		$this->back_hf      = "";
		$this->r_hand       = "";
		$this->r_hand_pf    = "";
		$this->r_hand_hf    = "";
		$this->l_hand       = "";
		$this->l_hand_pf    = "";
		$this->l_hand_hf    = "";
		$this->feet         = "";
		$this->feet_pf      = "";
		$this->feet_hf      = "";
	}

	function swapImage($imageId,$imageType) {

		If ($imageId < 1) return(false);

		switch($imageType){
		case PHPRPG_IMGLOC_PORTRAIT: $col = "CharImagePortrait"; break;
		case PHPRPG_IMGLOC_BODY:     $col = "CharImageBody";     break;
		case PHPRPG_IMGLOC_HAIR:     $col = "CharImageHair";     break;
		case PHPRPG_IMGLOC_WINGS:    $col = "CharImageWings";    break;
		case PHPRPG_IMGLOC_TAIL:     $col = "CharImageTail";     break;
		}

		$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		$errObj = new ERROR_REPORTER();

		$this->errors = NULL;

		if ($imageId > 0) {
			$id = $this->char_id;
			$table = PHPRPG_DB_PREFIX."_char_sprite";
			$sql  = "UPDATE $table SET $col=$imageId WHERE CharImageId=$id";

			if (!$dbObj->query($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);
			$this->load($id);
		}

		if (empty($this->errors)) return(true);
		return(false);
	}

	function changeColours($imageId,$imageType) {

		If ($imageId < 1) return(false);

		switch($imageType){
		case PHPRPG_IMGLOC_BODY:     $col = "CharImageBody";     break;
		case PHPRPG_IMGLOC_HAIR:     $col = "CharImageHair";     break;
		case PHPRPG_IMGLOC_WINGS:    $col = "CharImageWings";    break;
		case PHPRPG_IMGLOC_TAIL:     $col = "CharImageTail";     break;
		}

		$col_pf_red = $col."PF";
		$col_pf_red = $col."PF";
		$col_pf_red = $col."PF";
		$col_hf_red = $col."HF";
		$col_hf_red = $col."HF";
		$col_hf_red = $col."HF";

		$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		$errObj = new ERROR_REPORTER();

		$this->errors = NULL;

		if ($imageId > 0) {
			$id = $this->char_id;
			$table = PHPRPG_DB_PREFIX."_char_sprite";
			$sql  = "UPDATE $table SET $col=$imageId WHERE CharImageId=$id";

			if (!$dbObj->query($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);
			$this->load($id);
		}

		if (empty($this->errors)) return(true);
		return(false);
	}

//PRIVATE:
	// core user information
	var $char_id;
	var $sprite_dir;

	// core image information
	var $body;
	var $body_pf;
	var $body_hf;
	var $hair;
	var $hair_pf;
	var $hair_hf;
	var $wings;
	var $wings_pf;
	var $wings_hf;
	var $tail;
	var $tail_pf;
	var $tail_hf;
	var $portrait;

	// inventory items
	var $head;
	var $head_pf;
	var $head_hf;
	var $chest;
	var $chest_pf;
	var $chest_hf;
	var $back;
	var $back_pf;
	var $back_hf;
	var $r_hand;
	var $r_hand_pf;
	var $r_hand_hf;
	var $l_hand;
	var $l_hand_pf;
	var $l_hand_hf;
	var $feet;
	var $feet_pf;
	var $feet_hf;

	function SPRITE($char_id=0) {
		$this->flush();

		$file_name = md5("sprite-$char_id");
		$this->sprite_dir = PHPRPG_TMP_DIR."/".$file_name.".png";
		$this->sprite_url = PHPRPG_TMP_URL."/".$file_name.".png";

		$this->char_id = intval($char_id);
		if ($this->char_id > 0) {
			$this->load($this->char_id);
		}

		$this->write();
	}

	function GetImage($template,$pf,$hf) {

		$r_pf = $pf[0]; $g_pf = $pf[1];	$b_pf = $pf[2];
		$r_hf = $hf[0];	$g_hf = $hf[1];	$b_hf = $hf[2];

		$tmp_img  = imagecreatefrompng(PHPRPG_DIR.$template);

		if($pf != "") {
			$image_pf = imagecolorexact($tmp_img, 255,255,255);
			imagecolorset($tmp_img, $image_pf, $r_pf, $g_pf, $b_pf);
		}
		if($hf != "") {
			$image_hf = imagecolorexact($tmp_img, 128,128,128);
			imagecolorset($tmp_img, $image_hf, $r_hf, $g_hf, $b_hf);
		}

		return($tmp_img);
	}

	function GetImageId($path) {

		if (empty($path)) return false;

		$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		$errObj = new ERROR_REPORTER();

		$table = PHPRPG_DB_PREFIX.'_char_images';
		$sql   = "SELECT CharImageId FROM $table WHERE CharImagePath='$path' LIMIT 1";
		if (!($dbObj->query($sql))) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);
		while ($row = mysql_fetch_assoc($dbObj->result)) return $row['CharImageId'];

		return false;
	}
}